/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 *
 */
package alma.archive.idregistry.shared;

public class ArchiveDescriptor {
		protected String hostname;
		protected String ipAddress;
		protected String macAddress;
		protected String username;
		protected String type;
		protected String archiveId;
		
		//- constructors ---------------------------------------------------------
		
		public ArchiveDescriptor() {
		}
		
		public ArchiveDescriptor(String hostname, String ipAddress, String macAddress, String type, String username) {
			this.hostname = hostname;
			this.ipAddress = ipAddress;
			this.macAddress = macAddress;
			this.type = type;
			this.username = username;
		}

		public ArchiveDescriptor(ArchiveDescriptor archiveDescriptor) {
			this.setHostname(archiveDescriptor.getHostname());
			this.setIpAddress(archiveDescriptor.getIpAddress());
			this.setMacAddress(archiveDescriptor.getMacAddress());
			this.setType(archiveDescriptor.getType());
			this.setUsername(archiveDescriptor.getUsername());
		}		

		//- public methods -------------------------------------------------------		
		
		//- getters and setters --------------------------------------------------
		
		public String getArchiveId() {
			return archiveId;
		}

		public void setArchiveId(String archiveId) {
			this.archiveId = archiveId;
		}

		public String getHostname() {
			return hostname;
		}

		public void setHostname(String hostname) {
			this.hostname = hostname;
		}

		public String getIpAddress() {
			return ipAddress;
		}

		public void setIpAddress(String ipAddress) {
			this.ipAddress = ipAddress;
		}

		public String getMacAddress() {
			return macAddress;
		}

		public void setMacAddress(String macAddress) {
			this.macAddress = macAddress;
		}

		public String getType() {
			return type;
		}

		public void setType(String type) {
			this.type = type;
		}

		public String getUsername() {
			return username;
		}

		public void setUsername(String username) {
			this.username = username;
		}

}
