/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 *
 * ========================================================================
 * == THIS IS GENERATED CODE!!! DO NOT MODIFY! ALL CHANGES WILL BE LOST! ==
 * ======================================================================== 
 *
 */
 
package alma.ACSErrTypeDevIO.wrappers;

import alma.ACSErr.Completion;
import alma.acs.exceptions.*;
import alma.ACSErrTypeDevIO.wrappers.AcsJWriteErrorEx;

public class WriteErrorAcsJCompletion extends AcsJCompletion
{
	/**
	 * Creates a new <code>WriteErrorAcsJCompletion</code>
	 * with a corresponding exception (AcsJWriteErrorEx) attached.
	 */
	public WriteErrorAcsJCompletion () {
		super(new AcsJWriteErrorEx()); 
	}

	/**
	 * Creates a new <code>WriteErrorAcsJCompletion</code>
	 * with a corresponding exception (AcsJWriteErrorEx) attached 
	 * that wraps an existing exception (<code>acsJEx</code>.)
	 */
	public WriteErrorAcsJCompletion (AcsJException acsJEx) {
		super(new AcsJWriteErrorEx(acsJEx));  
	}
	
	/**
	 * Creates a new <code>WriteErrorAcsJCompletion</code>
	 * from another <code>AcsJCompletion</code> (<code>acsJComp</code>).
	 * <p>
	 * If present, the existing error trace is converted to Java exceptions
	 * and wrapped with an <code>AcsJWriteErrorEx</code>.
	 */
	public WriteErrorAcsJCompletion(AcsJCompletion acsJComp) {		
			init(new AcsJWriteErrorEx(acsJComp.getAcsJException()));
	}
	
	/**
	 * Converts a Corba completion to an <code>WriteErrorAcsJCompletion</code>
	 * such that a new <code>AcsJWriteErrorEx</code> is created as the attached error.
	 * If <code>corbaComp</code> carries error information, these <code>ErrorTrace</code>
	 * objects are converted to Java exceptions, which are attached as the course of
	 * the new <code>AcsJWriteErrorEx</code>.
	 * @param corbaComp
	 */
	public WriteErrorAcsJCompletion(Completion corbaComp) {
		
		 this(AcsJCompletion.fromCorbaCompletion(corbaComp));
	}
	
       /**
        * Returns the short description of the error
        */
	public String getShortDescription() 
	{
	   return "Write error";
	}	

	/////////////////////////////////////////////////////////////
	// Getter/Setter for members
	/////////////////////////////////////////////////////////////	

}
