/*
 * 	  Created on 24-Nov-2005
 * 
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 */
package alma.archive.wrappers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;

/**
 * @author simon
 */
public class TextFileWindow
{
	// Bounds
	private int pre;
	private int post;
	private int total;
	
	//Pointer
	private int read = 0;
	
	//File
	BufferedReader in = null;
	
	//Window buffer
	Vector prew = null;
	Vector postw = null;
	/**
	 * @throws IOException
	 * 
	 */
	public TextFileWindow(int pre, int post, File file) 
		throws 
			IOException
	{
		this.pre = pre;
		this.post = post;
		total = pre + post + 1;
		
		prew = new Vector();
		postw = new Vector();
		in = new BufferedReader(new FileReader(file));
		
		//Do a preemptive read to fill up the window
		String str;
		while ((prew.size() < pre) && ((str = in.readLine()) != null)) {
			prew.add(str);
			//System.out.println("ADDED: " + str);
		}
		
		while ((postw.size() < post) && ((str = in.readLine()) != null)) {
			postw.add(str);
			//System.out.println("ADDED: " + str);
		}
	}
	
	public String readLine() throws IOException
	{
		if (read > prew.size() -1) 
		{
			return null;
		}
		
		String result = (String)prew.get(read);
		//System.out.println(result);
		
		if (read < prew.size() -1) 
		{
			read++;
		}
		else
		{
			String removed = (String)prew.remove(0);
			if (postw.size() > 0)
			{
				String moved = (String)postw.remove(0);
				prew.add(moved);
			}
			String str;
			while ((postw.size() < post) && ((str = in.readLine()) != null)) {
				postw.add(str);
				//System.out.println("ADDED: " + str);
			}
		}
		return result;
	}
	
	public String readWindow()
	{
		String result = "";
		Iterator iter = prew.iterator();
		while (iter.hasNext())
		{
			result += (String)iter.next() + "\n";
		}
		iter = postw.iterator();
		while (iter.hasNext())
		{
			result += (String)iter.next() + "\n";
		}
		return result;
	}
	
	public void close() throws IOException
	{
		in.close();
	}
}
