/*
 * 	  Created on 21-Sep-2004
 * 
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 */
package alma.archive.database.vdoc;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;

import org.jdom.Element;
import org.jdom.output.XMLOutputter;

import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.database.interfaces.SchemaManager;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.VDocException;
import alma.archive.wrappers.ArchiveTimeStamp;

/**
 * @author simon
 */
public class XPathDefinition extends Definition
{
	/**
	 * Parameter list for the XPath ContextSource 
	 */
	public String paramXPath = "";
	public String paramSchema = "";
	public String paramUser = "";
	
	public XPathDefinition() 
		throws 
			VDocException{}
	
	/**
	 * Createx a list from the given source information. In this case the
	 * parameters XPath, Schema and User are required to create the context.
	 * @throws ModuleCriticalException
	 * @throws DatabaseException
	 */
	public Element createList(InternalIF internal) 
		throws 
			VDocException
	{
		try
		{
			//Get the interfaces necessary for the query
			SchemaManager smanager = internal.getSchemaManager(paramUser);
			URI schemaUri = smanager.getSchemaURI(paramSchema);
			HashMap namespaces = smanager.getSchemaNamespaces(schemaUri);
			//Perform the query
			URI[] uris = internal.queryIDs(
				paramXPath,
				paramSchema,
				namespaces,
				false,
				paramUser);
			//Create the items and add them
			Element uriList = new Element("uriList");
			for (int x = 0; x < uris.length; x++)
			{
				Element uri = new Element("uri");
				uri.setAttribute("location",uris[x].toASCIIString());
				uriList.addContent(uri);
			}
			//Clean up the internal stuff
			smanager.close();
			internal.close();

			return uriList;
		}
		catch (DatabaseException e){
			throw new VDocException(e);
		}
		catch (ModuleCriticalException e){
			throw new VDocException(e);
		}
		catch (ArchiveException e){
			throw new VDocException(e);
		}
		//MPA: three times no logging
	}
}