/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 *
 *    Created on Jan 16, 2004
 *
 */

// $Author: hsommer $
// $Date: 2006/09/06 10:14:02 $
// $Log: DatabaseCache.java,v $
// Revision 1.5  2006/09/06 10:14:02  hsommer
// generics
//
// Revision 1.4  2005/07/21 13:48:12  hmeuss
// replaced DB2 in log messages by Oracle
//
// Revision 1.3  2005/01/13 10:45:08  hmeuss
// - Constructed command line query interface for Archive.
// - Added functionality to init() for Oracle.
//
// Revision 1.2  2004/05/05 08:45:55  hmeuss
// *** empty log message ***
//
// Revision 1.1  2004/04/05 13:59:29  hmeuss
// Internal IF implementation adapted to Oracle
//
// Revision 1.1  2004/01/19 16:29:46  hmeuss
// Splitted functionality of Db2Database into Db2DatabaseReader, Db2DatabaseWriter, Db2DatabaseCache
// 
package alma.archive.database.oracle;

import java.net.URI;
import java.util.HashMap;
import java.util.logging.Logger;

/**
 * @author hmeuss
 * 
 * A class that caches various things from Oracle in order to avoid to many
 * database accesses
 * 
 *  
 */
public class DatabaseCache {

	/* Should be set with setLogger() */
	protected Logger m_logger = Logger.getLogger("ARCHIVE");

	/*
	 * Cache for schema names,
	 * 
	 * @see alma.archive.database.db2.Db2DatabaseReader.initSchemaMap(). These
	 *      variables are set by initSchemaMap(). Keys and values are Strings.
	 */
	protected HashMap<URI, String> uri2schemaName;
	protected HashMap<String, URI> schemaName2uri;

	/* for the singleton pattern */
	private static DatabaseCache m_instance;

	/* for the singleton pattern */
	protected static DatabaseCache instance() {
		if (m_instance == null) {
			m_instance = new DatabaseCache();
		}
		return m_instance;
	}

	private DatabaseCache() {
		super();
	}

	protected void setLogger(Logger logger) {
		m_logger = logger;
	}

	/**
	 *  
	 */
	protected void init() {
		// empty for the time being...
	}

}