/*
 * 	  Created on 01-Feb-2005
 * 
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 */
package alma.archive.database.lite;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;

import alma.archive.database.interfaces.SchemaManager;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.access.PermissionDeniedException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.NamespaceDefinedException;
import alma.archive.exceptions.general.UnknownSchemaException;
import alma.archive.exceptions.syntax.MalformedURIException;
import alma.archive.exceptions.syntax.MalformedXMLException;
import alma.archive.wrappers.Permissions;

/**
 * @author simon
 * 
 * A lite implementation of the SchemaManager interface, this is designed to fill a
 * gap in testing intermediate layers of software and eliminate the need for a
 * database.
 */
public class LiteSchemaManager implements SchemaManager
{

	private String _schemas = "archive://schemas";
	private String _namespaces = "archive://namespaces";
	private String _testns = "uid://test";
	private String _schemans = "http://www.w3.org/2001/XMLSchema";
	private String _schemauri = "uid://X0000000000000000/X00000000";
	private String schemaName = "SchemaName";
	private URI schemasUri,namespacesUri,testns,schemans,schemauri;
	
	private HashMap schemas = null;
	
	/**
	 * @throws DatabaseException
	 * 
	 */
	public LiteSchemaManager() throws DatabaseException
	{
		try 
		{
			schemasUri = new URI(_schemas);
			namespacesUri = new URI(_namespaces);
			testns = new URI(_testns);
			schemans = new URI(_schemans);
			schemauri = new URI(_schemauri);
			
			schemas = new HashMap();
		}
		catch (URISyntaxException e) 
		{
			throw new DatabaseException(e);
		}
	}

	/**
	 * @see alma.archive.database.interfaces.SchemaManager#close()
	 */
	public void close() throws DatabaseException
	{

	}

	/**
	 * @see alma.archive.database.interfaces.SchemaManager#getSchemaURI(java.lang.String)
	 */
	public URI getSchemaURI(String schemaName) throws ModuleCriticalException,
			DatabaseException, ArchiveException, UnknownSchemaException
	{
		return schemauri;
	}

	public void refresh() throws ModuleCriticalException, DatabaseException {}

	/**
	 * @see alma.archive.database.interfaces.SchemaManager#getSchemaURI(java.lang.String, int)
	 */
	public URI getSchemaURI(String schema, int version)
			throws ModuleCriticalException, DatabaseException,
			ArchiveException, UnknownSchemaException
	{
		return schemauri;
	}

	/**
	 * @see alma.archive.database.interfaces.SchemaManager#getSchemaName(java.net.URI)
	 */
	public String getSchemaName(URI schemaUri) throws ModuleCriticalException,
			DatabaseException, ArchiveException, UnknownSchemaException,
			MalformedURIException
	{
		return (String)schemas.get(schemaUri);
	}

	/**
	 * @see alma.archive.database.interfaces.SchemaManager#getSchemaVersion(java.net.URI)
	 */
	public int getSchemaVersion(URI schemaUri) throws ModuleCriticalException,
			DatabaseException, ArchiveException, UnknownSchemaException,
			MalformedURIException
	{
		return 0;
	}

	/**
	 * @see alma.archive.database.interfaces.SchemaManager#getSchemaNamespaces(java.net.URI)
	 */
	public HashMap getSchemaNamespaces(URI schemaUri)
			throws ModuleCriticalException, DatabaseException,
			ArchiveException, UnknownSchemaException
	{
		return null;
	}

	/**
	 * @see alma.archive.database.interfaces.SchemaManager#registerNamespace(java.lang.String, java.net.URI)
	 */
	public void registerNamespace(String prefix, URI namespace)
			throws ModuleCriticalException, NamespaceDefinedException,
			DatabaseException, ArchiveException, MalformedURIException
	{

	}

	/**
	 * @see alma.archive.database.interfaces.SchemaManager#removeNamespace(java.lang.String)
	 */
	public void removeNamespace(String prefix) throws ModuleCriticalException,
			DatabaseException, ArchiveException, MalformedURIException
	{

	}

	/**
	 * @see alma.archive.database.interfaces.SchemaManager#removeAll()
	 */
	public void removeAll() throws ModuleCriticalException, DatabaseException,
			ArchiveException, MalformedURIException
	{

	}

	/**
	 * @see alma.archive.database.interfaces.SchemaManager#namespaceExists(java.net.URI)
	 */
	public boolean namespaceExists(URI namespace)
			throws ModuleCriticalException, ArchiveException
	{
		if (namespace.equals(testns)){
			return true;
		}
		else{
			return false;
		}
	}

	/**
	 * @see alma.archive.database.interfaces.SchemaManager#assignNamespace(java.lang.String, java.net.URI)
	 */
	public void assignNamespace(String namespaceName, URI schemaUri)
			throws ModuleCriticalException, DatabaseException,
			ArchiveException, UnknownSchemaException
	{

	}

	/**
	 * @see alma.archive.database.interfaces.SchemaManager#withdrawNamespace(java.lang.String, java.net.URI)
	 */
	public void withdrawNamespace(String name, URI schemaUri)
			throws ModuleCriticalException, DatabaseException,
			ArchiveException, UnknownSchemaException
	{

	}

	/**
	 * @see alma.archive.database.interfaces.SchemaManager#namespaces()
	 */
	public HashMap namespaces() throws ModuleCriticalException,
			DatabaseException, ArchiveException
	{
		return null;
	}

	/**
	 * @see alma.archive.database.interfaces.SchemaManager#listSchema()
	 */
	public List listSchema() throws ModuleCriticalException, DatabaseException,
			ArchiveException
	{
		return null;
	}

	/**
	 * @see alma.archive.database.interfaces.SchemaManager#addSchema(java.lang.String, java.lang.String, java.lang.String, java.net.URI, java.lang.String, alma.archive.wrappers.Permissions)
	 */
	public void addSchema(String schemaName, String xml, String indexConfig,
			URI schemaURInew, String owner, Permissions permissions)
			throws ModuleCriticalException, DatabaseException,
			ArchiveException, MalformedURIException, UnknownSchemaException,
			PermissionDeniedException, MalformedXMLException
	{
		schemas.put(schemaURInew,schemaName);
	}

	/**
	 * @see alma.archive.database.interfaces.SchemaManager#updateSchema(java.lang.String, java.lang.String, java.lang.String, java.net.URI, java.net.URI, java.lang.String, alma.archive.wrappers.Permissions)
	 */
	public void updateSchema(String schemaName, String xml, String indexConfig,
			URI schemaURIold, URI schemaURInew, String owner,
			Permissions permissions) throws ModuleCriticalException,
			DatabaseException, ArchiveException, MalformedURIException,
			UnknownSchemaException, PermissionDeniedException,
			MalformedXMLException
	{

	}

	/**
	 * @see alma.archive.database.interfaces.SchemaManager#removeSchema(java.lang.String)
	 */
	public void removeSchema(String schemaName) throws ModuleCriticalException,
			DatabaseException, ArchiveException, UnknownSchemaException,
			PermissionDeniedException
	{

	}

}
