/*
 * 	  Created on 04-Apr-2005
 * 
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 */
package alma.archive.database.lite;

import java.net.URI;

import org.jdom.Element;

import alma.archive.database.interfaces.IdentifierManager;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.wrappers.UniqueIdentifier;

/**
 * @author simon
 * 
 * A lite implementation of the IdentifierManager interface, this is designed to fill a
 * gap in testing intermediate layers of software and eliminate the need for a
 * database.
 */
public class LiteIdentifierManager extends IdentifierManager
{
	Element ids = null;

	/**
	 * 
	 */
	public LiteIdentifierManager()
	{
		ids = new Element("ids");
		ids.setAttribute("archvieid","0");
		ids.setAttribute("rangeid","0");
	}

	/**
	 * @see alma.archive.database.interfaces.IdentifierManager#close()
	 */
	public void close() throws DatabaseException
	{
		ids = null;
	}
	
	/**
	 * Return the Archive ID value stored in the Database, if no value is set
	 * return an empty string "" not null.
	 * @return
	 * @throws DatabaseException
	 */
	public String getArchiveId() throws DatabaseException
	{
		String archId=ids.getAttributeValue("archiveid");
		try {
		return String.valueOf(Long.parseLong(archId));
		} catch (NumberFormatException e) {
			// new style archiveId starting with a character:
			return archId;
		}
	}
	
	/**
	 * Store the Archive ID in the Database, calling set will overwrite any
	 * previous value. 
	 * @param archiveId
	 * @throws DatabaseException
	 */
	protected void setArchiveId(String archiveId) throws DatabaseException
	{
		ids.setAttribute("archiveid",archiveId);
	}
	
	/**
	 * Return the Range ID value stored in the Database, if no value is set
	 * return and empty string "" not null;
	 * @return
	 * @throws DatabaseException
	 */
	protected long getRangeId() throws DatabaseException
	{
		return Long.parseLong(ids.getAttributeValue("rangeid"));
	}
	
	/**
	 * Store the Range ID in the database, calling set will overwrite any 
	 * previous value.
	 * @param rangeId
	 * @throws DatabaseException
	 */
	protected void setRangeId(long rangeId) throws DatabaseException
	{
		ids.setAttribute("rangeid",Long.toString(rangeId));
	}
}
