/*
 * 	  Created on 01-Feb-2005
 * 
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 */
package alma.archive.database.lite;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;

import alma.archive.database.interfaces.DBCursor;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.cursor.CursorClosedException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.wrappers.ResultStruct;

/**
 * @author simon
 * 
 * A lite implementation of the Cursor interface, this is designed to fill a
 * gap in testing intermediate layers of software and eliminate the need for a
 * database.
 */
public class LiteCursor implements DBCursor
{

	private HashMap documents = null;
	private Iterator uids = null;
	/**
	 * 
	 */
	public LiteCursor(HashMap documents)
	{
		this.documents = documents;
		uids = documents.keySet().iterator();
	}

	/**
	 * @see alma.archive.database.interfaces.DBCursor#hasNext()
	 */
	public boolean hasNext() throws DatabaseException, ArchiveException
	{
		return uids.hasNext();
	}

	/**
	 * @see alma.archive.database.interfaces.DBCursor#next()
	 */
	public ResultStruct next() throws CursorClosedException, DatabaseException,
			ArchiveException
	{
		URI next = (URI)uids.next();
		return new ResultStruct(next,(String)documents.get(next));
	}

	/**
	 * @see alma.archive.database.interfaces.DBCursor#nextBlock(short)
	 */
	public ResultStruct[] nextBlock(short blockSize)
			throws CursorClosedException, DatabaseException, ArchiveException
	{
		return null;
	}

	/**
	 * @see alma.archive.database.interfaces.DBCursor#close()
	 */
	public void close() throws CursorClosedException, DatabaseException,
			ArchiveException
	{
		
	}

}
