/*
 * 	  Created on 08-Jul-2004
 * 
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 */
package alma.archive.database.helpers;

import java.util.HashMap;
import java.util.LinkedList;


/**
 * @author simon
 */
public class Cache
{
	HashMap map = null;
	LinkedList queue = null;
	int capacity = 0;
	/**
	 * 
	 */
	public Cache(int capacity)
	{
		map = new HashMap();
		queue = new LinkedList();
		this.capacity = capacity;
	}
	
	public void put(Object key, Object content)
	{
		if (!map.containsKey(key))
		{
			if (map.size() >= capacity)
			{
				Object oldKey = queue.removeLast();
				map.remove(oldKey);
			}
			map.put(key,content);
			queue.addLast(key);
		}
	}
	
	public boolean containsKey(Object key)
	{
		return map.containsKey(key);
	}
	
	public Object get(Object key)
	{
		return map.get(key);
	}
	
	public void remove(Object key)
	{
		queue.remove(key);
		map.remove(key);
	}
}
