/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 *
 */
package alma.userrepository.addressbook.acs;

import alma.userrepository.addressbook.ldap.beans.LdapAddress;

public class AcsAddress extends alma.xmljbind.userrepository.address.Address
		implements alma.userrepository.domainmodel.Address {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public AcsAddress(alma.xmljbind.userrepository.address.Address address) {
		this.setCity(address.getCity());
		this.setCountry(address.getCountry());
		this.setDepartment(address.getDepartment());
		this.setEmail(address.getEmail());
		this.setFax(address.getFax());
		this.setJobTitle(address.getJobTitle());
		this.setMobile(address.getMobile());
		this.setModifiedTimestamp(address.getModifiedTimestamp());
		this.setOrganization(address.getOrganization());
		this.setPager(address.getPager());
		this.setPhone(address.getPhone());
		this.setPostcode(address.getPostcode());
		this.setRegion(address.getRegion());
		this.setStreetAddress(address.getStreetAddress());
		this.setUid(address.getUid());
		this.setWebsite(address.getWebsite());
	}

	public AcsAddress(alma.userrepository.domainmodel.Address address) {
		this.setCity(address.getCity());
		this.setCountry(address.getCountry());
		this.setDepartment(address.getDepartment());
		this.setEmail(address.getEmail());
		this.setFax(address.getFax());
		this.setJobTitle(address.getJobTitle());
		this.setMobile(address.getMobile());
		this.setOrganization(address.getOrganization());
		this.setPager(address.getPager());
		this.setPhone(address.getPhone());
		this.setPostcode(address.getPostcode());
		this.setRegion(address.getRegion());
		this.setStreetAddress(address.getStreetAddress());
		this.setUid(address.getUid());
		this.setWebsite(address.getWebsite());
		
		// LDAP address beans also have modification date to import
		if (address instanceof LdapAddress) {
			this.setModifiedTimestamp(((LdapAddress) address).getModifiedTimestamp());
		}
	}

	public alma.xmljbind.userrepository.address.Address getCastor() {
		alma.xmljbind.userrepository.address.Address address = new alma.xmljbind.userrepository.address.Address();

		address.setCity(getCity());
		address.setCountry(getCountry());
		address.setDepartment(getDepartment());
		address.setEmail(getEmail());
		address.setFax(getFax());
		address.setJobTitle(getJobTitle());
		address.setMobile(getMobile());
		address.setModifiedTimestamp(getModifiedTimestamp());
		address.setOrganization(getOrganization());
		address.setPager(getPager());
		address.setPhone(getPhone());
		address.setPostcode(getPostcode());
		address.setRegion(getRegion());
		address.setStreetAddress(getStreetAddress());
		address.setUid(getUid());
		address.setWebsite(getWebsite());
		
		return address;
	}

	public alma.userrepository.addressbook.ldap.beans.LdapAddress getLdapAddress() {
		alma.userrepository.addressbook.ldap.beans.LdapAddress address = new alma.userrepository.addressbook.ldap.beans.LdapAddress();

		address.setCity(getCity());
		address.setCountry(getCountry());
		address.setDepartment(getDepartment());
		address.setEmail(getEmail());
		address.setFax(getFax());
		address.setJobTitle(getJobTitle());
		address.setMobile(getMobile());
		address.setModifiedTimestamp(getModifiedTimestamp());
		address.setOrganization(getOrganization());
		address.setPager(getPager());
		address.setPhone(getPhone());
		address.setPostcode(getPostcode());
		address.setRegion(getRegion());
		address.setStreetAddress(getStreetAddress());
		address.setUid(getUid());
		address.setWebsite(getWebsite());
		
		return address;
	}
}
