package alma.userrepository;

/**
 * XML binding class aware ACS component interface ProjectDirectoryJ */
public interface ProjectDirectoryJ extends alma.ACS.ACSComponentOperations
{
    /**
     * Check connectivity to the back-end database. For an LDAP
     * backend, this method performs an anonymous login and a
     * basic search of the LDAP server.
     * 
     * @returns  true if the server is alive and is responding
     * correctly.
     */
    public boolean isAlive();

    /**
     * Establish an connection to the project directory. A unique
     * identifier corresponding to the open connection is
     * returned. Most user repository operations require a valid
     * non-anonymous, authenticated connection to complete
     * successfully. Note that the connection is NOT closed on
     * completion of this method.
     * 
     * @param  uid the uid of the user to connect as
     * 
     * @param  password the user's password
     * 
     * @return  the connection's unique identifier
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while establishing the connection
     */
    public String createConnection(String uid, String password)
        throws alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Close a connection to the project directory. This method
     * instructs the connection manager to close the connection
     * referenced by the unique ID and allows the connection
     * manager to free its internal references to it. The
     * behaviour of subsequent functions called using a closed
     * connection is undefined.
     * 
     * @param  connectionId the connection ID
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while releasing the connection.
     */
    public void releaseConnection(String connectionId)
        throws alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * List the ids of all projects in the directory.
     * 
     * @returns  the list of project ids
     * 
     * @param  connectionId the connection ID
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while listing the projects.
     */
    public alma.ProjectCodeModule.ProjectCodeStruct[] listProjects(String connectionId)
        throws alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Determine whether a project with the given id exists.
     * 
     * @param  connectionId the connection ID
     * 
     * @param  projectId the project ID
     * 
     * @return  true if a project with the given ID exists
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while searching for the project.
     */
    public boolean exists(String connectionId, alma.ProjectCodeModule.ProjectCodeStruct projectId)
        throws alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * List the project members with the given project role.
     * 
     * @param  connectionId the connection ID
     * 
     * @param  projectId the project ID
     * 
     * @param  role the project role
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while determing the project members.
     */
    public String[] getMembers(String connectionId, alma.ProjectCodeModule.ProjectCodeStruct projectId, alma.userrepository.ProjectRole role)
        throws alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Determine if a user has the specified role in the given
     * project. For an LDAP backend, the member argument should be
     * specified as a fully qualified distinguished name.
     * 
     * @param  connectionId the connection ID
     * 
     * @param  member the member to search for
     * 
     * @param  projectId the project ID
     * 
     * @param  role the project role
     * 
     * @return  true if the user has the given role in the given
     * project
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while performing the operation
     */
    public boolean isMember(String connectionId, String member, alma.ProjectCodeModule.ProjectCodeStruct projectId, alma.userrepository.ProjectRole role)
        throws alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Assign a user the specified role of the given project. For
     * an LDAP backend, the member attribute should be specified
     * as the fully-qualified distinguished name of the entry.
     * 
     * @param  connectionId the connection ID
     * 
     * @param  member the member
     * 
     * @param  role the project role
     * 
     * @param  projectId the project ID
     * 
     * @throws  DuplicateObjectErrorEx if the user is already
     * assigned the role
     * 
     * @throws  InvalidAttributeErrorEx if the member argument is
     * invalid
     * 
     * @throws  InvalidOperationErrorEx if an attempt is made to
     * add a user to the ANY project role.
     * 
     * @throws  ObjectNotFoundErrorEx if the project cannot be
     * found
     * 
     * @throws  PermissionErrorEx if the connection does not have
     * the privileges required to perform this operation
     * 
     * @throws  UserRepositoryErrorEx if the server raises an error
     * while performing this operation
     */
    public void assignProjectRole(String connectionId, String member, alma.userrepository.ProjectRole role, alma.ProjectCodeModule.ProjectCodeStruct projectId)
        throws alma.UserRepositoryError.DuplicateObjectErrorEx, alma.UserRepositoryError.InvalidAttributeErrorEx, alma.UserRepositoryError.InvalidOperationErrorEx, alma.UserRepositoryError.ObjectNotFoundErrorEx, alma.UserRepositoryError.PermissionErrorEx, alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Remove a user from the specified role in the given
     * project. For an LDAP backend, the member attribute should
     * be specified as the fully-qualified distinguished name of
     * the entry.
     * 
     * @param  connectionId the connection ID
     * 
     * @param  member the member to remove
     * 
     * @param  role the project role to revoke
     * 
     * @param  projectId the project ID
     * from
     * 
     * @throws  InvalidAttributeErrorEx if the user did not have
     * the specified role
     * 
     * @throws  InvalidOperationErrorEx if an attempt is made to
     * remove the user from the ANY role
     * 
     * @throws  ObjectNotFoundErrorEx if the project cannot be
     * found
     * 
     * @throws  PermissionErrorEx if the connection does not have
     * the privileges required to perform this operation
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while revoking the project role
     */
    public void revokeProjectRole(String connectionId, String member, alma.userrepository.ProjectRole role, alma.ProjectCodeModule.ProjectCodeStruct projectId)
        throws alma.UserRepositoryError.InvalidAttributeErrorEx, alma.UserRepositoryError.InvalidOperationErrorEx, alma.UserRepositoryError.ObjectNotFoundErrorEx, alma.UserRepositoryError.PermissionErrorEx, alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * Create a new project. The project is created with empty PI,
     * CoI and system membership lists.
     * 
     * @param  connectionId the connection ID
     * 
     * @param  projectId the project ID
     * 
     * @throws  DuplicateObjectErrorEx if a project with the given ID
     * already exists.
     * 
     * @throws  InvalidAttributeEx if projectId is in an invalid
     * format
     * 
     * @throws  PermissionErrorEx if the connection does not have
     * the privileges required to perform this operation
     * 
     * @throws  UserRepositoryErrorEx if an unexpected error
     * occurred while creating the project
     */
    public void createNewProject(String connectionId, alma.ProjectCodeModule.ProjectCodeStruct projectId)
        throws alma.UserRepositoryError.DuplicateObjectErrorEx, alma.UserRepositoryError.InvalidAttributeErrorEx, alma.UserRepositoryError.PermissionErrorEx, alma.UserRepositoryError.UserRepositoryErrorEx;

    /**
     * ACS will not generate the Castor xxxJ binding classes unless there
     * is at least one method with an out parameteter. When the methods
     * are all 'in's, they binding classes are not compiled into the
     * library.
     */
    public void junkMethodSoWeGenerateBindingClass(alma.xmljbind.userrepository.user.User junkIn, org.omg.CORBA.StringHolder junkOut);

}
