/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 *
 */
package alma.archive.idregistry.ws;

import java.net.MalformedURLException;
import java.net.URL;

import javax.xml.namespace.QName;

import alma.archive.idregistry.exceptions.DatabaseException;
import alma.archive.idregistry.exceptions.DocumentDoesNotExistException;
import alma.archive.idregistry.exceptions.PermissionDeniedException;
import alma.archive.idregistry.ws.generated.DatabaseException_Exception;
import alma.archive.idregistry.ws.generated.DocumentDoesNotExistException_Exception;
import alma.archive.idregistry.ws.generated.PermissionDeniedException_Exception;
import alma.archive.idregistry.ws.generated.UserRepositoryException_Exception;
import alma.userrepository.errors.UserRepositoryException;

/**
 * 
 * @author stewart
 */
public class ArchiveIdRegistryWebServiceClient implements
		alma.archive.idregistry.server.ArchiveIdRegistry {
	private static final QName serviceName = new QName(
			"http://ws.idregistry.archive.alma/", "ArchiveIdRegistryService");

	private URL wsdlLocation = null;

	public ArchiveIdRegistryWebServiceClient() {
		URL url = null;
		try {
			url = new URL(
					"http://localhost:8180/ArchiveIdRegistry/ArchiveIdRegistry?wsdl");
		} catch (MalformedURLException e) {
			e.printStackTrace();
		}
		this.wsdlLocation = url;
	}

	public ArchiveIdRegistryWebServiceClient(URL wsdlLocation) {
		this.wsdlLocation = wsdlLocation;
	}

	public String getArchiveId(
			alma.archive.idregistry.shared.ArchiveDescriptor archiveDescriptor,
			String username, String password) throws UserRepositoryException,
			DatabaseException, PermissionDeniedException {
		try {
			alma.archive.idregistry.ws.generated.ArchiveIdRegistryService service = new alma.archive.idregistry.ws.generated.ArchiveIdRegistryService(
					wsdlLocation, serviceName);
			alma.archive.idregistry.ws.generated.ArchiveIdRegistry port = service
					.getArchiveIdRegistryPort();

			// convert to web service archive descriptor
			alma.archive.idregistry.ws.generated.ArchiveDescriptor wsDescriptor = new alma.archive.idregistry.ws.generated.ArchiveDescriptor();
			wsDescriptor.setHostname(archiveDescriptor.getHostname());
			wsDescriptor.setIpAddress(archiveDescriptor.getIpAddress());
			wsDescriptor.setMacAddress(archiveDescriptor.getMacAddress());
			wsDescriptor.setType(archiveDescriptor.getType());
			wsDescriptor.setUsername(archiveDescriptor.getUsername());

			String result = port.getArchiveId(wsDescriptor, username, password);
			return result;
		} catch (DatabaseException_Exception e) {
			throw new DatabaseException(e);
		} catch (PermissionDeniedException_Exception e) {
			throw new PermissionDeniedException(e);
		} catch (UserRepositoryException_Exception e) {
			throw new UserRepositoryException(e);
		}
	}

	public alma.archive.idregistry.shared.ArchiveDescriptor getArchiveDescriptor(
			String archiveId, String username, String password)
			throws UserRepositoryException, PermissionDeniedException,
			DatabaseException, DocumentDoesNotExistException {
		try {
			alma.archive.idregistry.ws.generated.ArchiveIdRegistryService service = new alma.archive.idregistry.ws.generated.ArchiveIdRegistryService(
					wsdlLocation, serviceName);
			alma.archive.idregistry.ws.generated.ArchiveIdRegistry port = service
					.getArchiveIdRegistryPort();
			alma.archive.idregistry.ws.generated.ArchiveDescriptor result = port
					.getArchiveDescriptor(archiveId, username, password);

			alma.archive.idregistry.shared.ArchiveDescriptor d = new alma.archive.idregistry.shared.ArchiveDescriptor();
			d.setArchiveId(result.getArchiveId());
			d.setHostname(result.getHostname());
			d.setIpAddress(result.getIpAddress());
			d.setMacAddress(result.getMacAddress());
			d.setType(result.getType());
			d.setUsername(result.getUsername());

			return d;
		} catch (DatabaseException_Exception e) {
			throw new DatabaseException(e);
		} catch (DocumentDoesNotExistException_Exception e) {
			throw new DocumentDoesNotExistException(e);
		} catch (PermissionDeniedException_Exception e) {
			throw new PermissionDeniedException(e);
		} catch (UserRepositoryException_Exception e) {
			throw new UserRepositoryException(e);
		}
	}
}
