/*
 * This class was automatically generated with 
 * <a href="http://www.castor.org">Castor 0.9.6</a>, using an XML
 * Schema.
 * $Id$
 */

package alma.maci.loggingconfig;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import alma.maci.loggingconfig.types.LogLevel;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.xml.sax.ContentHandler;

/**
 * Configuration for the log production of an entire process, e.g.
 * a container or manager. This includes shared settings for the
 * communication with the central log service, as well as settings
 * for individual loggers.
 * The inherited 'minLogLevel' and 'minLogLevelLocal' are the
 * default log levels for all loggers in the container or other
 * process. They can be overridden for specific loggers using
 * 'log:_' XML child elements.
 * 
 * @version $Revision$ $Date$
 */
public class LoggingConfig extends alma.maci.loggingconfig.UnnamedLogger 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Name of the service representing the logging service. This
     * is the name used to query the Manager for the reference to
     * the logging service. In the current installations the
     * default value is normally used. The value can be changed to
     * distribute logs to different instances of the service in
     * order to improve performance and scalability of the system.
     * In the future it will be possible to federate instances of
     * the logging service, but this is not implemented yet.
     */
    private java.lang.String _centralizedLogger = "Log";

    /**
     * In order to improve performance and reduce network traffic,
     * containers do not send immediately logs to the logging
     * system. This parameter specifies how many logs are packaged
     * together and sent to the logging system in one call. Note
     * that the real package size may be smaller if sending off the
     * records is also triggered by a timer and /or by the log
     * level. 
     * For debugging purposes it may be convenient to set the cache
     * to 0, to avoid losing logs when a Container crashes. 
     * This value was called "CacheSize" prior to ACS 6.0.
     */
    private int _dispatchPacketSize = 100;

    /**
     * keeps track of state for field: _dispatchPacketSize
     */
    private boolean _has_dispatchPacketSize;

    /**
     * Normally a number of log records are sent together to the
     * logging system, as described for "dispatchPacketSize". The
     * "immediateDispatchLevel" triggers sending all cached log
     * records immediately once a record with the given (or higher)
     * log level appears, even before the specified packet size has
     * been reached.
     * This value was called "MaxCachePriority" prior to ACS 6.0
     */
    private alma.maci.loggingconfig.types.LogLevel _immediateDispatchLevel = alma.maci.loggingconfig.types.LogLevel.valueOf("10");

    /**
     * If log records are queued locally in order to send a bunch
     * of them together to the remote log service, we still may
     * want to send packages with fewer records after a certain
     * time. This makes sure that log receivers see the messages in
     * time, even if very few records get produced. 
     * This value sets the time period in seconds after which the
     * log record queue should be flushed if it contains log
     * records, regardless of the resulting 'dispatchPacketSize'. A
     * value "0" turns off the time-triggered flushing.
     */
    private int _flushPeriodSeconds = 10;

    /**
     * keeps track of state for field: _flushPeriodSeconds
     */
    private boolean _has_flushPeriodSeconds;

    /**
     * Log records are stored in a queue not only to send them in a
     * packet over the wire (see dispatchPacketSize), but also to
     * not lose any records in times when the log service is not
     * available (e.g. during container start, or any kind of
     * network and service failure). Thus they get stored in a
     * queue, which gets drained once the log service becomes
     * available. However, logging should not compete for memory
     * with the functional parts of the software, so we limit this
     * queue. Values below "dispatchPacketSize" will be ignored, as
     * we first must queue the records that should be sent together.
     */
    private int _maxLogQueueSize = 1000;

    /**
     * keeps track of state for field: _maxLogQueueSize
     */
    private boolean _has_maxLogQueueSize;

    /**
     * !!! CONFIGURATION OF NAMED LOGGERS NOT YET SUPPORTED IN ACS
     * 6.0!!! Optional configuration for specific loggers that
     * should use different log levels than the default values from
     * 'LoggingConfig'. The odd name '_' follows the CDB convention
     * for 'map attributes' and allows easy access without
     * iterating over a list of loggers.
     */
    private java.util.ArrayList _List;


      //----------------/
     //- Constructors -/
    //----------------/

    public LoggingConfig() {
        super();
        setCentralizedLogger("Log");
        setImmediateDispatchLevel(alma.maci.loggingconfig.types.LogLevel.valueOf("10"));
        _List = new ArrayList();
    } //-- alma.maci.loggingconfig.LoggingConfig()


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method add
     * 
     * 
     * 
     * @param v
     */
    public void add(alma.maci.loggingconfig.NamedLogger v)
        throws java.lang.IndexOutOfBoundsException
    {
        _List.add(v);
    } //-- void add(alma.maci.loggingconfig.NamedLogger) 

    /**
     * Method add
     * 
     * 
     * 
     * @param index
     * @param v
     */
    public void add(int index, alma.maci.loggingconfig.NamedLogger v)
        throws java.lang.IndexOutOfBoundsException
    {
        _List.add(index, v);
    } //-- void add(int, alma.maci.loggingconfig.NamedLogger) 

    /**
     * Method clear
     * 
     */
    public void clear()
    {
        _List.clear();
    } //-- void clear() 

    /**
     * Method deleteDispatchPacketSize
     * 
     */
    public void deleteDispatchPacketSize()
    {
        this._has_dispatchPacketSize= false;
    } //-- void deleteDispatchPacketSize() 

    /**
     * Method deleteFlushPeriodSeconds
     * 
     */
    public void deleteFlushPeriodSeconds()
    {
        this._has_flushPeriodSeconds= false;
    } //-- void deleteFlushPeriodSeconds() 

    /**
     * Method deleteMaxLogQueueSize
     * 
     */
    public void deleteMaxLogQueueSize()
    {
        this._has_maxLogQueueSize= false;
    } //-- void deleteMaxLogQueueSize() 

    /**
     * Method enumerate
     * 
     * 
     * 
     * @return Enumeration
     */
    public java.util.Enumeration enumerate()
    {
        return new org.exolab.castor.util.IteratorEnumeration(_List.iterator());
    } //-- java.util.Enumeration enumerate() 

    /**
     * Method get
     * 
     * 
     * 
     * @param index
     * @return NamedLogger
     */
    public alma.maci.loggingconfig.NamedLogger get(int index)
        throws java.lang.IndexOutOfBoundsException
    {
        //-- check bounds for index
        if ((index < 0) || (index > _List.size())) {
            throw new IndexOutOfBoundsException();
        }
        
        return (alma.maci.loggingconfig.NamedLogger) _List.get(index);
    } //-- alma.maci.loggingconfig.NamedLogger get(int) 

    /**
     * Method get
     * 
     * 
     * 
     * @return NamedLogger
     */
    public alma.maci.loggingconfig.NamedLogger[] get()
    {
        int size = _List.size();
        alma.maci.loggingconfig.NamedLogger[] mArray = new alma.maci.loggingconfig.NamedLogger[size];
        for (int index = 0; index < size; index++) {
            mArray[index] = (alma.maci.loggingconfig.NamedLogger) _List.get(index);
        }
        return mArray;
    } //-- alma.maci.loggingconfig.NamedLogger[] get() 

    /**
     * Returns the value of field 'centralizedLogger'. The field
     * 'centralizedLogger' has the following description: Name of
     * the service representing the logging service. This is the
     * name used to query the Manager for the reference to the
     * logging service. In the current installations the default
     * value is normally used. The value can be changed to
     * distribute logs to different instances of the service in
     * order to improve performance and scalability of the system.
     * In the future it will be possible to federate instances of
     * the logging service, but this is not implemented yet.
     * 
     * @return String
     * @return the value of field 'centralizedLogger'.
     */
    public java.lang.String getCentralizedLogger()
    {
        return this._centralizedLogger;
    } //-- java.lang.String getCentralizedLogger() 

    /**
     * Method getCount
     * 
     * 
     * 
     * @return int
     */
    public int getCount()
    {
        return _List.size();
    } //-- int getCount() 

    /**
     * Returns the value of field 'dispatchPacketSize'. The field
     * 'dispatchPacketSize' has the following description: In order
     * to improve performance and reduce network traffic,
     * containers do not send immediately logs to the logging
     * system. This parameter specifies how many logs are packaged
     * together and sent to the logging system in one call. Note
     * that the real package size may be smaller if sending off the
     * records is also triggered by a timer and /or by the log
     * level. 
     * For debugging purposes it may be convenient to set the cache
     * to 0, to avoid losing logs when a Container crashes. 
     * This value was called "CacheSize" prior to ACS 6.0.
     * 
     * @return int
     * @return the value of field 'dispatchPacketSize'.
     */
    public int getDispatchPacketSize()
    {
        return this._dispatchPacketSize;
    } //-- int getDispatchPacketSize() 

    /**
     * Returns the value of field 'flushPeriodSeconds'. The field
     * 'flushPeriodSeconds' has the following description: If log
     * records are queued locally in order to send a bunch of them
     * together to the remote log service, we still may want to
     * send packages with fewer records after a certain time. This
     * makes sure that log receivers see the messages in time, even
     * if very few records get produced. 
     * This value sets the time period in seconds after which the
     * log record queue should be flushed if it contains log
     * records, regardless of the resulting 'dispatchPacketSize'. A
     * value "0" turns off the time-triggered flushing.
     * 
     * @return int
     * @return the value of field 'flushPeriodSeconds'.
     */
    public int getFlushPeriodSeconds()
    {
        return this._flushPeriodSeconds;
    } //-- int getFlushPeriodSeconds() 

    /**
     * Returns the value of field 'immediateDispatchLevel'. The
     * field 'immediateDispatchLevel' has the following
     * description: Normally a number of log records are sent
     * together to the logging system, as described for
     * "dispatchPacketSize". The "immediateDispatchLevel" triggers
     * sending all cached log records immediately once a record
     * with the given (or higher) log level appears, even before
     * the specified packet size has been reached.
     * This value was called "MaxCachePriority" prior to ACS 6.0
     * 
     * @return LogLevel
     * @return the value of field 'immediateDispatchLevel'.
     */
    public alma.maci.loggingconfig.types.LogLevel getImmediateDispatchLevel()
    {
        return this._immediateDispatchLevel;
    } //-- alma.maci.loggingconfig.types.LogLevel getImmediateDispatchLevel() 

    /**
     * Returns the value of field 'maxLogQueueSize'. The field
     * 'maxLogQueueSize' has the following description: Log records
     * are stored in a queue not only to send them in a packet over
     * the wire (see dispatchPacketSize), but also to not lose any
     * records in times when the log service is not available (e.g.
     * during container start, or any kind of network and service
     * failure). Thus they get stored in a queue, which gets
     * drained once the log service becomes available. However,
     * logging should not compete for memory with the functional
     * parts of the software, so we limit this queue. Values below
     * "dispatchPacketSize" will be ignored, as we first must queue
     * the records that should be sent together.
     * 
     * @return int
     * @return the value of field 'maxLogQueueSize'.
     */
    public int getMaxLogQueueSize()
    {
        return this._maxLogQueueSize;
    } //-- int getMaxLogQueueSize() 

    /**
     * Method hasDispatchPacketSize
     * 
     * 
     * 
     * @return boolean
     */
    public boolean hasDispatchPacketSize()
    {
        return this._has_dispatchPacketSize;
    } //-- boolean hasDispatchPacketSize() 

    /**
     * Method hasFlushPeriodSeconds
     * 
     * 
     * 
     * @return boolean
     */
    public boolean hasFlushPeriodSeconds()
    {
        return this._has_flushPeriodSeconds;
    } //-- boolean hasFlushPeriodSeconds() 

    /**
     * Method hasMaxLogQueueSize
     * 
     * 
     * 
     * @return boolean
     */
    public boolean hasMaxLogQueueSize()
    {
        return this._has_maxLogQueueSize;
    } //-- boolean hasMaxLogQueueSize() 

    /**
     * Method isValid
     * 
     * 
     * 
     * @return boolean
     */
    public boolean isValid()
    {
        try {
            validate();
        }
        catch (org.exolab.castor.xml.ValidationException vex) {
            return false;
        }
        return true;
    } //-- boolean isValid() 

    /**
     * Method marshal
     * 
     * 
     * 
     * @param out
     */
    public void marshal(java.io.Writer out)
        throws org.exolab.castor.xml.MarshalException, org.exolab.castor.xml.ValidationException
    {
        
        Marshaller.marshal(this, out);
    } //-- void marshal(java.io.Writer) 

    /**
     * Method marshal
     * 
     * 
     * 
     * @param handler
     */
    public void marshal(org.xml.sax.ContentHandler handler)
        throws java.io.IOException, org.exolab.castor.xml.MarshalException, org.exolab.castor.xml.ValidationException
    {
        
        Marshaller.marshal(this, handler);
    } //-- void marshal(org.xml.sax.ContentHandler) 

    /**
     * Method remove
     * 
     * 
     * 
     * @param v
     * @return boolean
     */
    public boolean remove(alma.maci.loggingconfig.NamedLogger v)
    {
        boolean removed = _List.remove(v);
        return removed;
    } //-- boolean remove(alma.maci.loggingconfig.NamedLogger) 

    /**
     * Method set
     * 
     * 
     * 
     * @param index
     * @param v
     */
    public void set(int index, alma.maci.loggingconfig.NamedLogger v)
        throws java.lang.IndexOutOfBoundsException
    {
        //-- check bounds for index
        if ((index < 0) || (index > _List.size())) {
            throw new IndexOutOfBoundsException();
        }
        _List.set(index, v);
    } //-- void set(int, alma.maci.loggingconfig.NamedLogger) 

    /**
     * Method set
     * 
     * 
     * 
     * @param Array
     */
    public void set(alma.maci.loggingconfig.NamedLogger[] Array)
    {
        //-- copy array
        _List.clear();
        for (int i = 0; i < Array.length; i++) {
            _List.add(Array[i]);
        }
    } //-- void set(alma.maci.loggingconfig.NamedLogger) 

    /**
     * Sets the value of field 'centralizedLogger'. The field
     * 'centralizedLogger' has the following description: Name of
     * the service representing the logging service. This is the
     * name used to query the Manager for the reference to the
     * logging service. In the current installations the default
     * value is normally used. The value can be changed to
     * distribute logs to different instances of the service in
     * order to improve performance and scalability of the system.
     * In the future it will be possible to federate instances of
     * the logging service, but this is not implemented yet.
     * 
     * @param centralizedLogger the value of field
     * 'centralizedLogger'.
     */
    public void setCentralizedLogger(java.lang.String centralizedLogger)
    {
        this._centralizedLogger = centralizedLogger;
    } //-- void setCentralizedLogger(java.lang.String) 

    /**
     * Sets the value of field 'dispatchPacketSize'. The field
     * 'dispatchPacketSize' has the following description: In order
     * to improve performance and reduce network traffic,
     * containers do not send immediately logs to the logging
     * system. This parameter specifies how many logs are packaged
     * together and sent to the logging system in one call. Note
     * that the real package size may be smaller if sending off the
     * records is also triggered by a timer and /or by the log
     * level. 
     * For debugging purposes it may be convenient to set the cache
     * to 0, to avoid losing logs when a Container crashes. 
     * This value was called "CacheSize" prior to ACS 6.0.
     * 
     * @param dispatchPacketSize the value of field
     * 'dispatchPacketSize'.
     */
    public void setDispatchPacketSize(int dispatchPacketSize)
    {
        this._dispatchPacketSize = dispatchPacketSize;
        this._has_dispatchPacketSize = true;
    } //-- void setDispatchPacketSize(int) 

    /**
     * Sets the value of field 'flushPeriodSeconds'. The field
     * 'flushPeriodSeconds' has the following description: If log
     * records are queued locally in order to send a bunch of them
     * together to the remote log service, we still may want to
     * send packages with fewer records after a certain time. This
     * makes sure that log receivers see the messages in time, even
     * if very few records get produced. 
     * This value sets the time period in seconds after which the
     * log record queue should be flushed if it contains log
     * records, regardless of the resulting 'dispatchPacketSize'. A
     * value "0" turns off the time-triggered flushing.
     * 
     * @param flushPeriodSeconds the value of field
     * 'flushPeriodSeconds'.
     */
    public void setFlushPeriodSeconds(int flushPeriodSeconds)
    {
        this._flushPeriodSeconds = flushPeriodSeconds;
        this._has_flushPeriodSeconds = true;
    } //-- void setFlushPeriodSeconds(int) 

    /**
     * Sets the value of field 'immediateDispatchLevel'. The field
     * 'immediateDispatchLevel' has the following description:
     * Normally a number of log records are sent together to the
     * logging system, as described for "dispatchPacketSize". The
     * "immediateDispatchLevel" triggers sending all cached log
     * records immediately once a record with the given (or higher)
     * log level appears, even before the specified packet size has
     * been reached.
     * This value was called "MaxCachePriority" prior to ACS 6.0
     * 
     * @param immediateDispatchLevel the value of field
     * 'immediateDispatchLevel'.
     */
    public void setImmediateDispatchLevel(alma.maci.loggingconfig.types.LogLevel immediateDispatchLevel)
    {
        this._immediateDispatchLevel = immediateDispatchLevel;
    } //-- void setImmediateDispatchLevel(alma.maci.loggingconfig.types.LogLevel) 

    /**
     * Sets the value of field 'maxLogQueueSize'. The field
     * 'maxLogQueueSize' has the following description: Log records
     * are stored in a queue not only to send them in a packet over
     * the wire (see dispatchPacketSize), but also to not lose any
     * records in times when the log service is not available (e.g.
     * during container start, or any kind of network and service
     * failure). Thus they get stored in a queue, which gets
     * drained once the log service becomes available. However,
     * logging should not compete for memory with the functional
     * parts of the software, so we limit this queue. Values below
     * "dispatchPacketSize" will be ignored, as we first must queue
     * the records that should be sent together.
     * 
     * @param maxLogQueueSize the value of field 'maxLogQueueSize'.
     */
    public void setMaxLogQueueSize(int maxLogQueueSize)
    {
        this._maxLogQueueSize = maxLogQueueSize;
        this._has_maxLogQueueSize = true;
    } //-- void setMaxLogQueueSize(int) 

    /**
     * Method unmarshalLoggingConfig
     * 
     * 
     * 
     * @param reader
     * @return LoggingConfig
     */
    public static alma.maci.loggingconfig.LoggingConfig unmarshalLoggingConfig(java.io.Reader reader)
        throws org.exolab.castor.xml.MarshalException, org.exolab.castor.xml.ValidationException
    {
        return (alma.maci.loggingconfig.LoggingConfig) Unmarshaller.unmarshal(alma.maci.loggingconfig.LoggingConfig.class, reader);
    } //-- alma.maci.loggingconfig.LoggingConfig unmarshalLoggingConfig(java.io.Reader) 

    /**
     * Method validate
     * 
     */
    public void validate()
        throws org.exolab.castor.xml.ValidationException
    {
        org.exolab.castor.xml.Validator validator = new org.exolab.castor.xml.Validator();
        validator.validate(this);
    } //-- void validate() 

}
