#!/usr/bin/env python
# @(#) $Id: AES2Py.xslt,v 1.21 2009/02/18 00:36:46 agrimstrup Exp $
#
#    ALMA - Atacama Large Millimiter Array
#    (c) Associated Universities, Inc. Washington DC, USA,  2001
#    (c) European Southern Observatory, 2002
#    Copyright by ESO (in the framework of the ALMA collaboration)
#    and Cosylab 2002, All rights reserved
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
######################################################################
'''
Some form of custom documentation goes here...
'''
######################################################################
from   Acspy.Common.Err import ACSError
import ACSErr
import acsdaemonErrType
from Acspy.Common.TimeHelper import getTimeStamp
######################################################################

class BaseException:
    '''
    Class serves as a base exception for all error type/code exception
    pairs defined within this module. The reason this is provided is so 
    that one can generically catch ACS Error System based Python 
    exceptions using a single Python "except BaseException, e:" type
    statement.
    '''
    pass
######################################################################
class FailedToStartContainerExImpl(acsdaemonErrType.FailedToStartContainerEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Failed to start container"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.FailedToStartContainer,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        acsdaemonErrType.FailedToStartContainerEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getacsdaemonErrTypeEx(self):
        '''
        Returns this exception converted into an acsdaemonErrTypeEx
        '''
        return acsdaemonErrType.acsdaemonErrTypeEx(self.getErrorTrace())


######################################################################
class FailedToStopContainerExImpl(acsdaemonErrType.FailedToStopContainerEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Failed to stop container"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.FailedToStopContainer,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        acsdaemonErrType.FailedToStopContainerEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getacsdaemonErrTypeEx(self):
        '''
        Returns this exception converted into an acsdaemonErrTypeEx
        '''
        return acsdaemonErrType.acsdaemonErrTypeEx(self.getErrorTrace())


######################################################################
class AcsStartServicesExImpl(acsdaemonErrType.AcsStartServicesEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Status of ACS services start"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.AcsStartServices,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        acsdaemonErrType.AcsStartServicesEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getacsdaemonErrTypeEx(self):
        '''
        Returns this exception converted into an acsdaemonErrTypeEx
        '''
        return acsdaemonErrType.acsdaemonErrTypeEx(self.getErrorTrace())


######################################################################
class FailedToStopAcsExImpl(acsdaemonErrType.FailedToStopAcsEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Failed to stop ACS services"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.FailedToStopAcs,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        acsdaemonErrType.FailedToStopAcsEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getacsdaemonErrTypeEx(self):
        '''
        Returns this exception converted into an acsdaemonErrTypeEx
        '''
        return acsdaemonErrType.acsdaemonErrTypeEx(self.getErrorTrace())


######################################################################
class ServiceAlreadyRunningExImpl(acsdaemonErrType.ServiceAlreadyRunningEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "The requested service is running already."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.ServiceAlreadyRunning,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        acsdaemonErrType.ServiceAlreadyRunningEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getacsdaemonErrTypeEx(self):
        '''
        Returns this exception converted into an acsdaemonErrTypeEx
        '''
        return acsdaemonErrType.acsdaemonErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setService(self, value):
        '''
        Member setter method.
        '''
        self.setData("Service", value)
        return
        
    def getService(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Service")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class ServiceNotRunningExImpl(acsdaemonErrType.ServiceNotRunningEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "The requested service is not running."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.ServiceNotRunning,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        acsdaemonErrType.ServiceNotRunningEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getacsdaemonErrTypeEx(self):
        '''
        Returns this exception converted into an acsdaemonErrTypeEx
        '''
        return acsdaemonErrType.acsdaemonErrTypeEx(self.getErrorTrace())


######################################################################
class FailedToGetAcsStatusExImpl(acsdaemonErrType.FailedToGetAcsStatusEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Failed to get ACS status"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.FailedToGetAcsStatus,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        acsdaemonErrType.FailedToGetAcsStatusEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getacsdaemonErrTypeEx(self):
        '''
        Returns this exception converted into an acsdaemonErrTypeEx
        '''
        return acsdaemonErrType.acsdaemonErrTypeEx(self.getErrorTrace())


######################################################################
class ProcessingAbortedExImpl(acsdaemonErrType.ProcessingAbortedEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Processing was stopped."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.ProcessingAborted,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        acsdaemonErrType.ProcessingAbortedEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getacsdaemonErrTypeEx(self):
        '''
        Returns this exception converted into an acsdaemonErrTypeEx
        '''
        return acsdaemonErrType.acsdaemonErrTypeEx(self.getErrorTrace())


######################################################################
class CannotCreateInstanceExImpl(acsdaemonErrType.CannotCreateInstanceEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Cannot create requested instance."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.CannotCreateInstance,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        acsdaemonErrType.CannotCreateInstanceEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getacsdaemonErrTypeEx(self):
        '''
        Returns this exception converted into an acsdaemonErrTypeEx
        '''
        return acsdaemonErrType.acsdaemonErrTypeEx(self.getErrorTrace())


######################################################################
class CannotUseInstanceExImpl(acsdaemonErrType.CannotUseInstanceEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Instance is in use and cannot be used."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.CannotUseInstance,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        acsdaemonErrType.CannotUseInstanceEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getacsdaemonErrTypeEx(self):
        '''
        Returns this exception converted into an acsdaemonErrTypeEx
        '''
        return acsdaemonErrType.acsdaemonErrTypeEx(self.getErrorTrace())


######################################################################
class FailedToProcessRequestExImpl(acsdaemonErrType.FailedToProcessRequestEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Failed to process request."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.FailedToProcessRequest,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        acsdaemonErrType.FailedToProcessRequestEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getacsdaemonErrTypeEx(self):
        '''
        Returns this exception converted into an acsdaemonErrTypeEx
        '''
        return acsdaemonErrType.acsdaemonErrTypeEx(self.getErrorTrace())


######################################################################
class BadArgumentsExImpl(acsdaemonErrType.BadArgumentsEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Command line arguments wrong or missing."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.BadArguments,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        acsdaemonErrType.BadArgumentsEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getacsdaemonErrTypeEx(self):
        '''
        Returns this exception converted into an acsdaemonErrTypeEx
        '''
        return acsdaemonErrType.acsdaemonErrTypeEx(self.getErrorTrace())


######################################################################
class PortInUseExImpl(acsdaemonErrType.PortInUseEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Service port is in use."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.PortInUse,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        acsdaemonErrType.PortInUseEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getacsdaemonErrTypeEx(self):
        '''
        Returns this exception converted into an acsdaemonErrTypeEx
        '''
        return acsdaemonErrType.acsdaemonErrTypeEx(self.getErrorTrace())


######################################################################
class RequestProcessingTimedOutExImpl(acsdaemonErrType.RequestProcessingTimedOutEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Request processing has timed out."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.RequestProcessingTimedOut,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        acsdaemonErrType.RequestProcessingTimedOutEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getacsdaemonErrTypeEx(self):
        '''
        Returns this exception converted into an acsdaemonErrTypeEx
        '''
        return acsdaemonErrType.acsdaemonErrTypeEx(self.getErrorTrace())


######################################################################
class FailedToStartContainerCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Failed to start container"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.FailedToStartContainer,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return


######################################################################
class FailedToStopContainerCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Failed to stop container"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.FailedToStopContainer,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return


######################################################################
class AcsStartServicesCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Status of ACS services start"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.AcsStartServices,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return


######################################################################
class FailedToStopAcsCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Failed to stop ACS services"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.FailedToStopAcs,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return


######################################################################
class ServiceAlreadyRunningCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "The requested service is running already."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.ServiceAlreadyRunning,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setService(self, value):
        '''
        Member setter method.
        '''
        self.setData("Service", value)
        return
        
    def getService(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Service")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class ServiceNotRunningCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "The requested service is not running."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.ServiceNotRunning,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return


######################################################################
class FailedToGetAcsStatusCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Failed to get ACS status"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.FailedToGetAcsStatus,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return


######################################################################
class ProcessingAbortedCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Processing was stopped."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.ProcessingAborted,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return


######################################################################
class CannotCreateInstanceCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Cannot create requested instance."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.CannotCreateInstance,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return


######################################################################
class CannotUseInstanceCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Instance is in use and cannot be used."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.CannotUseInstance,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return


######################################################################
class FailedToProcessRequestCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Failed to process request."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.FailedToProcessRequest,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return


######################################################################
class BadArgumentsCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Command line arguments wrong or missing."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.BadArguments,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return


######################################################################
class PortInUseCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Service port is in use."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.PortInUse,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return


######################################################################
class RequestProcessingTimedOutCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Request processing has timed out."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.acsdaemonErrType,
                          acsdaemonErrType.RequestProcessingTimedOut,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return


######################################################################
if __name__ == "__main__":

    try:
        raise FailedToStartContainerExImpl
    except acsdaemonErrType.FailedToStartContainerEx, e:
        print "Caught the correct type of exception:", e
        g = FailedToStartContainerExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise FailedToStopContainerExImpl
    except acsdaemonErrType.FailedToStopContainerEx, e:
        print "Caught the correct type of exception:", e
        g = FailedToStopContainerExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise AcsStartServicesExImpl
    except acsdaemonErrType.AcsStartServicesEx, e:
        print "Caught the correct type of exception:", e
        g = AcsStartServicesExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise FailedToStopAcsExImpl
    except acsdaemonErrType.FailedToStopAcsEx, e:
        print "Caught the correct type of exception:", e
        g = FailedToStopAcsExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise ServiceAlreadyRunningExImpl
    except acsdaemonErrType.ServiceAlreadyRunningEx, e:
        print "Caught the correct type of exception:", e
        g = ServiceAlreadyRunningExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise ServiceNotRunningExImpl
    except acsdaemonErrType.ServiceNotRunningEx, e:
        print "Caught the correct type of exception:", e
        g = ServiceNotRunningExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise FailedToGetAcsStatusExImpl
    except acsdaemonErrType.FailedToGetAcsStatusEx, e:
        print "Caught the correct type of exception:", e
        g = FailedToGetAcsStatusExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise ProcessingAbortedExImpl
    except acsdaemonErrType.ProcessingAbortedEx, e:
        print "Caught the correct type of exception:", e
        g = ProcessingAbortedExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise CannotCreateInstanceExImpl
    except acsdaemonErrType.CannotCreateInstanceEx, e:
        print "Caught the correct type of exception:", e
        g = CannotCreateInstanceExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise CannotUseInstanceExImpl
    except acsdaemonErrType.CannotUseInstanceEx, e:
        print "Caught the correct type of exception:", e
        g = CannotUseInstanceExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise FailedToProcessRequestExImpl
    except acsdaemonErrType.FailedToProcessRequestEx, e:
        print "Caught the correct type of exception:", e
        g = FailedToProcessRequestExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise BadArgumentsExImpl
    except acsdaemonErrType.BadArgumentsEx, e:
        print "Caught the correct type of exception:", e
        g = BadArgumentsExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise PortInUseExImpl
    except acsdaemonErrType.PortInUseEx, e:
        print "Caught the correct type of exception:", e
        g = PortInUseExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise RequestProcessingTimedOutExImpl
    except acsdaemonErrType.RequestProcessingTimedOutEx, e:
        print "Caught the correct type of exception:", e
        g = RequestProcessingTimedOutExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e


    joe = FailedToStartContainerCompletionImpl()
    joe.Print()


    joe = FailedToStopContainerCompletionImpl()
    joe.Print()


    joe = AcsStartServicesCompletionImpl()
    joe.Print()


    joe = FailedToStopAcsCompletionImpl()
    joe.Print()


    joe = ServiceAlreadyRunningCompletionImpl()
    joe.Print()


    joe = ServiceNotRunningCompletionImpl()
    joe.Print()


    joe = FailedToGetAcsStatusCompletionImpl()
    joe.Print()


    joe = ProcessingAbortedCompletionImpl()
    joe.Print()


    joe = CannotCreateInstanceCompletionImpl()
    joe.Print()


    joe = CannotUseInstanceCompletionImpl()
    joe.Print()


    joe = FailedToProcessRequestCompletionImpl()
    joe.Print()


    joe = BadArgumentsCompletionImpl()
    joe.Print()


    joe = PortInUseCompletionImpl()
    joe.Print()


    joe = RequestProcessingTimedOutCompletionImpl()
    joe.Print()


    print
