#!/usr/bin/env python
# @(#) $Id: AES2Py.xslt,v 1.21 2009/02/18 00:36:46 agrimstrup Exp $
#
#    ALMA - Atacama Large Millimiter Array
#    (c) Associated Universities, Inc. Washington DC, USA,  2001
#    (c) European Southern Observatory, 2002
#    Copyright by ESO (in the framework of the ALMA collaboration)
#    and Cosylab 2002, All rights reserved
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
######################################################################
'''
Some form of custom documentation goes here...
'''
######################################################################
from   Acspy.Common.Err import ACSError
import ACSErr
import MonitorCollectorErr
from Acspy.Common.TimeHelper import getTimeStamp
######################################################################

class BaseException:
    '''
    Class serves as a base exception for all error type/code exception
    pairs defined within this module. The reason this is provided is so 
    that one can generically catch ACS Error System based Python 
    exceptions using a single Python "except BaseException, e:" type
    statement.
    '''
    pass
######################################################################
class DeviceAlreadyRegistredExImpl(MonitorCollectorErr.DeviceAlreadyRegistredEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Device already registred."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.MonitorCollectorErr,
                          MonitorCollectorErr.DeviceAlreadyRegistred,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        MonitorCollectorErr.DeviceAlreadyRegistredEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getMonitorCollectorErrEx(self):
        '''
        Returns this exception converted into an MonitorCollectorErrEx
        '''
        return MonitorCollectorErr.MonitorCollectorErrEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setDevice(self, value):
        '''
        Member setter method.
        '''
        self.setData("Device", value)
        return
        
    def getDevice(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Device")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class RegisteringDeviceProblemExImpl(MonitorCollectorErr.RegisteringDeviceProblemEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Registering Device Problem."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.MonitorCollectorErr,
                          MonitorCollectorErr.RegisteringDeviceProblem,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        MonitorCollectorErr.RegisteringDeviceProblemEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getMonitorCollectorErrEx(self):
        '''
        Returns this exception converted into an MonitorCollectorErrEx
        '''
        return MonitorCollectorErr.MonitorCollectorErrEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setDevice(self, value):
        '''
        Member setter method.
        '''
        self.setData("Device", value)
        return
        
    def getDevice(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Device")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class DeviceNotRegistredExImpl(MonitorCollectorErr.DeviceNotRegistredEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Device has not been registred."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.MonitorCollectorErr,
                          MonitorCollectorErr.DeviceNotRegistred,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        MonitorCollectorErr.DeviceNotRegistredEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getMonitorCollectorErrEx(self):
        '''
        Returns this exception converted into an MonitorCollectorErrEx
        '''
        return MonitorCollectorErr.MonitorCollectorErrEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setDevice(self, value):
        '''
        Member setter method.
        '''
        self.setData("Device", value)
        return
        
    def getDevice(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Device")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class StartMonitoringProblemExImpl(MonitorCollectorErr.StartMonitoringProblemEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Could not start monitoring."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.MonitorCollectorErr,
                          MonitorCollectorErr.StartMonitoringProblem,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        MonitorCollectorErr.StartMonitoringProblemEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getMonitorCollectorErrEx(self):
        '''
        Returns this exception converted into an MonitorCollectorErrEx
        '''
        return MonitorCollectorErr.MonitorCollectorErrEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setDevice(self, value):
        '''
        Member setter method.
        '''
        self.setData("Device", value)
        return
        
    def getDevice(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Device")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class StopMonitoringProblemExImpl(MonitorCollectorErr.StopMonitoringProblemEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Could not stop monitoring."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.MonitorCollectorErr,
                          MonitorCollectorErr.StopMonitoringProblem,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        MonitorCollectorErr.StopMonitoringProblemEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getMonitorCollectorErrEx(self):
        '''
        Returns this exception converted into an MonitorCollectorErrEx
        '''
        return MonitorCollectorErr.MonitorCollectorErrEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setDevice(self, value):
        '''
        Member setter method.
        '''
        self.setData("Device", value)
        return
        
    def getDevice(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Device")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class NonExsistentPropertyExImpl(MonitorCollectorErr.NonExsistentPropertyEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Property does not exist."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.MonitorCollectorErr,
                          MonitorCollectorErr.NonExsistentProperty,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        MonitorCollectorErr.NonExsistentPropertyEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getMonitorCollectorErrEx(self):
        '''
        Returns this exception converted into an MonitorCollectorErrEx
        '''
        return MonitorCollectorErr.MonitorCollectorErrEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setProperty(self, value):
        '''
        Member setter method.
        '''
        self.setData("Property", value)
        return
        
    def getProperty(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Property")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class NonSupportedTypeExImpl(MonitorCollectorErr.NonSupportedTypeEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Non supported type."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.MonitorCollectorErr,
                          MonitorCollectorErr.NonSupportedType,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        MonitorCollectorErr.NonSupportedTypeEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getMonitorCollectorErrEx(self):
        '''
        Returns this exception converted into an MonitorCollectorErrEx
        '''
        return MonitorCollectorErr.MonitorCollectorErrEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setProperty(self, value):
        '''
        Member setter method.
        '''
        self.setData("Property", value)
        return
        
    def getProperty(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Property")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setPropertyType(self, value):
        '''
        Member setter method.
        '''
        self.setData("PropertyType", value)
        return
        
    def getPropertyType(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("PropertyType")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class NotCollocatedComponentExImpl(MonitorCollectorErr.NotCollocatedComponentEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Device not collocated."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.MonitorCollectorErr,
                          MonitorCollectorErr.NotCollocatedComponent,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        MonitorCollectorErr.NotCollocatedComponentEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getMonitorCollectorErrEx(self):
        '''
        Returns this exception converted into an MonitorCollectorErrEx
        '''
        return MonitorCollectorErr.MonitorCollectorErrEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setComponent(self, value):
        '''
        Member setter method.
        '''
        self.setData("Component", value)
        return
        
    def getComponent(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Component")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class DeviceAlreadyRegistredCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Device already registred."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.MonitorCollectorErr,
                          MonitorCollectorErr.DeviceAlreadyRegistred,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setDevice(self, value):
        '''
        Member setter method.
        '''
        self.setData("Device", value)
        return
        
    def getDevice(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Device")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class RegisteringDeviceProblemCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Registering Device Problem."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.MonitorCollectorErr,
                          MonitorCollectorErr.RegisteringDeviceProblem,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setDevice(self, value):
        '''
        Member setter method.
        '''
        self.setData("Device", value)
        return
        
    def getDevice(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Device")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class DeviceNotRegistredCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Device has not been registred."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.MonitorCollectorErr,
                          MonitorCollectorErr.DeviceNotRegistred,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setDevice(self, value):
        '''
        Member setter method.
        '''
        self.setData("Device", value)
        return
        
    def getDevice(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Device")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class StartMonitoringProblemCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Could not start monitoring."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.MonitorCollectorErr,
                          MonitorCollectorErr.StartMonitoringProblem,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setDevice(self, value):
        '''
        Member setter method.
        '''
        self.setData("Device", value)
        return
        
    def getDevice(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Device")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class StopMonitoringProblemCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Could not stop monitoring."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.MonitorCollectorErr,
                          MonitorCollectorErr.StopMonitoringProblem,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setDevice(self, value):
        '''
        Member setter method.
        '''
        self.setData("Device", value)
        return
        
    def getDevice(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Device")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class NonExsistentPropertyCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Property does not exist."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.MonitorCollectorErr,
                          MonitorCollectorErr.NonExsistentProperty,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setProperty(self, value):
        '''
        Member setter method.
        '''
        self.setData("Property", value)
        return
        
    def getProperty(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Property")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class NonSupportedTypeCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Non supported type."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.MonitorCollectorErr,
                          MonitorCollectorErr.NonSupportedType,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setProperty(self, value):
        '''
        Member setter method.
        '''
        self.setData("Property", value)
        return
        
    def getProperty(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Property")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setPropertyType(self, value):
        '''
        Member setter method.
        '''
        self.setData("PropertyType", value)
        return
        
    def getPropertyType(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("PropertyType")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class NotCollocatedComponentCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Device not collocated."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.MonitorCollectorErr,
                          MonitorCollectorErr.NotCollocatedComponent,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setComponent(self, value):
        '''
        Member setter method.
        '''
        self.setData("Component", value)
        return
        
    def getComponent(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Component")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
if __name__ == "__main__":

    try:
        raise DeviceAlreadyRegistredExImpl
    except MonitorCollectorErr.DeviceAlreadyRegistredEx, e:
        print "Caught the correct type of exception:", e
        g = DeviceAlreadyRegistredExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise RegisteringDeviceProblemExImpl
    except MonitorCollectorErr.RegisteringDeviceProblemEx, e:
        print "Caught the correct type of exception:", e
        g = RegisteringDeviceProblemExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise DeviceNotRegistredExImpl
    except MonitorCollectorErr.DeviceNotRegistredEx, e:
        print "Caught the correct type of exception:", e
        g = DeviceNotRegistredExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise StartMonitoringProblemExImpl
    except MonitorCollectorErr.StartMonitoringProblemEx, e:
        print "Caught the correct type of exception:", e
        g = StartMonitoringProblemExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise StopMonitoringProblemExImpl
    except MonitorCollectorErr.StopMonitoringProblemEx, e:
        print "Caught the correct type of exception:", e
        g = StopMonitoringProblemExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise NonExsistentPropertyExImpl
    except MonitorCollectorErr.NonExsistentPropertyEx, e:
        print "Caught the correct type of exception:", e
        g = NonExsistentPropertyExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise NonSupportedTypeExImpl
    except MonitorCollectorErr.NonSupportedTypeEx, e:
        print "Caught the correct type of exception:", e
        g = NonSupportedTypeExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise NotCollocatedComponentExImpl
    except MonitorCollectorErr.NotCollocatedComponentEx, e:
        print "Caught the correct type of exception:", e
        g = NotCollocatedComponentExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e


    joe = DeviceAlreadyRegistredCompletionImpl()
    joe.Print()


    joe = RegisteringDeviceProblemCompletionImpl()
    joe.Print()


    joe = DeviceNotRegistredCompletionImpl()
    joe.Print()


    joe = StartMonitoringProblemCompletionImpl()
    joe.Print()


    joe = StopMonitoringProblemCompletionImpl()
    joe.Print()


    joe = NonExsistentPropertyCompletionImpl()
    joe.Print()


    joe = NonSupportedTypeCompletionImpl()
    joe.Print()


    joe = NotCollocatedComponentCompletionImpl()
    joe.Print()


    print
