#!/usr/bin/env python
# @(#) $Id: AES2Py.xslt,v 1.21 2009/02/18 00:36:46 agrimstrup Exp $
#
#    ALMA - Atacama Large Millimiter Array
#    (c) Associated Universities, Inc. Washington DC, USA,  2001
#    (c) European Southern Observatory, 2002
#    Copyright by ESO (in the framework of the ALMA collaboration)
#    and Cosylab 2002, All rights reserved
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
######################################################################
'''
Some form of custom documentation goes here...
'''
######################################################################
from   Acspy.Common.Err import ACSError
import ACSErr
import ACSErrTypeAlarm
from Acspy.Common.TimeHelper import getTimeStamp
######################################################################
class ACSErrAlarmClearedCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        Parameters: None
        '''
        self.shortDescription = "All alarm conditions have disappeared."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.ACSErrTypeAlarm,
                          ACSErrTypeAlarm.ACSErrAlarmCleared,
                          None,
                          description,
                          [],
                          0,
                          None)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   getTimeStamp().value,
                                   ACSErr.ACSErrTypeAlarm,
                                   ACSErrTypeAlarm.ACSErrAlarmCleared,
                                   [])
        return

    def isOK(self):
        return 1

    def getDescription(self):
        return self.shortDescription

    def getErrorCode(self):
        return self.code

    def getErrorType(self):
        return self.type


######################################################################
class ACSErrAlarmChangedCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        Parameters: None
        '''
        self.shortDescription = " At least one alarm condition remains."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.ACSErrTypeAlarm,
                          ACSErrTypeAlarm.ACSErrAlarmChanged,
                          None,
                          description,
                          [],
                          0,
                          None)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   getTimeStamp().value,
                                   ACSErr.ACSErrTypeAlarm,
                                   ACSErrTypeAlarm.ACSErrAlarmChanged,
                                   [])
        return

    def isOK(self):
        return 1

    def getDescription(self):
        return self.shortDescription

    def getErrorCode(self):
        return self.code

    def getErrorType(self):
        return self.type


######################################################################
class ACSErrAlarmLowCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        Parameters: None
        '''
        self.shortDescription = "Value below alarm LoLo (includes hysteresis)."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.ACSErrTypeAlarm,
                          ACSErrTypeAlarm.ACSErrAlarmLow,
                          None,
                          description,
                          [],
                          0,
                          None)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   getTimeStamp().value,
                                   ACSErr.ACSErrTypeAlarm,
                                   ACSErrTypeAlarm.ACSErrAlarmLow,
                                   [])
        return

    def isOK(self):
        return 1

    def getDescription(self):
        return self.shortDescription

    def getErrorCode(self):
        return self.code

    def getErrorType(self):
        return self.type


######################################################################
class ACSErrAlarmHighCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        Parameters: None
        '''
        self.shortDescription = "Value above alarm HiHi (includes hysteresis)."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.ACSErrTypeAlarm,
                          ACSErrTypeAlarm.ACSErrAlarmHigh,
                          None,
                          description,
                          [],
                          0,
                          None)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   getTimeStamp().value,
                                   ACSErr.ACSErrTypeAlarm,
                                   ACSErrTypeAlarm.ACSErrAlarmHigh,
                                   [])
        return

    def isOK(self):
        return 1

    def getDescription(self):
        return self.shortDescription

    def getErrorCode(self):
        return self.code

    def getErrorType(self):
        return self.type


######################################################################
class ACSErrAlarmSoftwareCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        Parameters: None
        '''
        self.shortDescription = "An alarm on the status determined by software."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.ACSErrTypeAlarm,
                          ACSErrTypeAlarm.ACSErrAlarmSoftware,
                          None,
                          description,
                          [],
                          0,
                          None)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   getTimeStamp().value,
                                   ACSErr.ACSErrTypeAlarm,
                                   ACSErrTypeAlarm.ACSErrAlarmSoftware,
                                   [])
        return

    def isOK(self):
        return 1

    def getDescription(self):
        return self.shortDescription

    def getErrorCode(self):
        return self.code

    def getErrorType(self):
        return self.type


######################################################################
class ACSErrAlarmHardwareCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        Parameters: None
        '''
        self.shortDescription = "Hardware alarm."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.ACSErrTypeAlarm,
                          ACSErrTypeAlarm.ACSErrAlarmHardware,
                          None,
                          description,
                          [],
                          0,
                          None)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   getTimeStamp().value,
                                   ACSErr.ACSErrTypeAlarm,
                                   ACSErrTypeAlarm.ACSErrAlarmHardware,
                                   [])
        return

    def isOK(self):
        return 1

    def getDescription(self):
        return self.shortDescription

    def getErrorCode(self):
        return self.code

    def getErrorType(self):
        return self.type


######################################################################
if __name__ == "__main__":


    joe = ACSErrAlarmClearedCompletionImpl()
    joe.Print()


    joe = ACSErrAlarmChangedCompletionImpl()
    joe.Print()


    joe = ACSErrAlarmLowCompletionImpl()
    joe.Print()


    joe = ACSErrAlarmHighCompletionImpl()
    joe.Print()


    joe = ACSErrAlarmSoftwareCompletionImpl()
    joe.Print()


    joe = ACSErrAlarmHardwareCompletionImpl()
    joe.Print()


    print
