#ifndef UTIL_BULKHEADER_H
#define UTIL_BULKHEADER_H
/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) Associated Universities Inc., 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* who       when      what
* --------  --------  ----------------------------------------------
* Viola    2006-05-08 created
*/

/**
 * @class bulkUserParam
 * bulkUserParam is a utility class providing method to construct data for cbStart
 * in BulkReceiver and MonitorReceiver.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <sstream>

class BulkUserParam
{
  public:
    ////////////////////////////////////////////////////////////////////////
    /** Constructor
     */
    BulkUserParam() {};

    /** Constructor 2
        parse userParam to uid and fileLength
     */
    BulkUserParam(const char* userParam);
    /** Destructor
     */
    virtual ~BulkUserParam() {};

    void setUid(const char *uid);
    void setFileLength(int len);
    char * getUid();
    char * getUidFileName();
    int  getFileLength();
   
    /* compose uid and fileLength to a char string */ 
    static std::string toString(const char *id, int len);
    
  private:
    /* fix length here, I think it is better then new/delete */
    char uid[40];
    char uidFileName[40];
    int  fileLength;
};

#endif
