#ifndef _cdbErrType_H_
#define _cdbErrType_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "cdbErrTypeC.h"

#include "acserrExceptionManager.h"

namespace cdbErrType
{

class CouldntReadCDBCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::cdbErrType; // = 51
	static const ACSErr::ErrorCode m_code = CouldntReadCDB;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CouldntReadCDBCompletion::m_shortDescription; }
	CouldntReadCDBCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CouldntReadCDBCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CouldntReadCDBCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CouldntReadCDBCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CouldntReadCDBCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CouldntReadCDBCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class CouldntWriteCDBCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::cdbErrType; // = 51
	static const ACSErr::ErrorCode m_code = CouldntWriteCDB;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CouldntWriteCDBCompletion::m_shortDescription; }
	CouldntWriteCDBCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CouldntWriteCDBCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CouldntWriteCDBCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CouldntWriteCDBCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CouldntWriteCDBCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CouldntWriteCDBCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class CDBRecordIsReadOnlyCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::cdbErrType; // = 51
	static const ACSErr::ErrorCode m_code = CDBRecordIsReadOnly;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CDBRecordIsReadOnlyCompletion::m_shortDescription; }
	CDBRecordIsReadOnlyCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CDBRecordIsReadOnlyCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CDBRecordIsReadOnlyCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CDBRecordIsReadOnlyCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CDBRecordIsReadOnlyCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CDBRecordIsReadOnlyCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setCurl(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Curl", value); }            				
	ACE_CString getCurl (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Curl");  }

	
};

class CDBFieldIsReadOnlyCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::cdbErrType; // = 51
	static const ACSErr::ErrorCode m_code = CDBFieldIsReadOnly;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CDBFieldIsReadOnlyCompletion::m_shortDescription; }
	CDBFieldIsReadOnlyCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CDBFieldIsReadOnlyCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CDBFieldIsReadOnlyCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CDBFieldIsReadOnlyCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CDBFieldIsReadOnlyCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CDBFieldIsReadOnlyCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setFieldName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("FieldName", value); }            				
	ACE_CString getFieldName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("FieldName");  }

	
};

class CDBReadoOnlyDataCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::cdbErrType; // = 51
	static const ACSErr::ErrorCode m_code = CDBReadoOnlyData;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CDBReadoOnlyDataCompletion::m_shortDescription; }
	CDBReadoOnlyDataCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CDBReadoOnlyDataCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CDBReadoOnlyDataCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CDBReadoOnlyDataCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CDBReadoOnlyDataCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CDBReadoOnlyDataCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class WrongCDBDataTypeCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::cdbErrType; // = 51
	static const ACSErr::ErrorCode m_code = WrongCDBDataType;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return WrongCDBDataTypeCompletion::m_shortDescription; }
	WrongCDBDataTypeCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	WrongCDBDataTypeCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	WrongCDBDataTypeCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	WrongCDBDataTypeCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	WrongCDBDataTypeCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	WrongCDBDataTypeCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setValue(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Value", value); }            				
	ACE_CString getValue (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Value");  }

		void setDataType(ACE_CString value){ getErrorTraceHelper()->setMemberValue("DataType", value); }            				
	ACE_CString getDataType (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("DataType");  }

	
};

class CDBRecordAlreadyExistsCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::cdbErrType; // = 51
	static const ACSErr::ErrorCode m_code = CDBRecordAlreadyExists;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CDBRecordAlreadyExistsCompletion::m_shortDescription; }
	CDBRecordAlreadyExistsCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CDBRecordAlreadyExistsCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CDBRecordAlreadyExistsCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CDBRecordAlreadyExistsCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CDBRecordAlreadyExistsCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CDBRecordAlreadyExistsCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setCurl(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Curl", value); }            				
	ACE_CString getCurl (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Curl");  }

	
};

class CDBExceptionCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::cdbErrType; // = 51
	static const ACSErr::ErrorCode m_code = CDBException;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CDBExceptionCompletion::m_shortDescription; }
	CDBExceptionCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CDBExceptionCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CDBExceptionCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CDBExceptionCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CDBExceptionCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CDBExceptionCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class CDBFieldDoesNotExistCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::cdbErrType; // = 51
	static const ACSErr::ErrorCode m_code = CDBFieldDoesNotExist;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CDBFieldDoesNotExistCompletion::m_shortDescription; }
	CDBFieldDoesNotExistCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CDBFieldDoesNotExistCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CDBFieldDoesNotExistCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CDBFieldDoesNotExistCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CDBFieldDoesNotExistCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CDBFieldDoesNotExistCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setFieldName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("FieldName", value); }            				
	ACE_CString getFieldName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("FieldName");  }

	
};

class CDBRecordDoesNotExistCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::cdbErrType; // = 51
	static const ACSErr::ErrorCode m_code = CDBRecordDoesNotExist;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CDBRecordDoesNotExistCompletion::m_shortDescription; }
	CDBRecordDoesNotExistCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CDBRecordDoesNotExistCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CDBRecordDoesNotExistCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CDBRecordDoesNotExistCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CDBRecordDoesNotExistCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CDBRecordDoesNotExistCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setCurl(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Curl", value); }            				
	ACE_CString getCurl (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Curl");  }

	
};

class CDBXMLErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::cdbErrType; // = 51
	static const ACSErr::ErrorCode m_code = CDBXMLError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CDBXMLErrorCompletion::m_shortDescription; }
	CDBXMLErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CDBXMLErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CDBXMLErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CDBXMLErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CDBXMLErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CDBXMLErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setFilename(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Filename", value); }            				
	ACE_CString getFilename (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Filename");  }


		void setCurl(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Curl", value); }            				
	ACE_CString getCurl (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Curl");  }

		
		void setNodename(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Nodename", value); }            				
	ACE_CString getNodename (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Nodename");  }

				
		void setErrorString(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ErrorString", value); }            				
	ACE_CString getErrorString (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ErrorString");  }


	
};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class cdbErrTypeExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	cdbErrTypeExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	cdbErrTypeExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	cdbErrTypeExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	cdbErrTypeExImpl (cdbErrType::cdbErrTypeEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	cdbErrType::cdbErrTypeEx getcdbErrTypeEx () { return cdbErrType::cdbErrTypeEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class CouldntReadCDBExImpl: public cdbErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::cdbErrType;
	static const ACSErr::ErrorCode m_code = CouldntReadCDB;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CouldntReadCDBExImpl(const CouldntReadCDBExImpl& ex) :
			cdbErrTypeExImpl(const_cast<CouldntReadCDBExImpl&>(ex).getErrorTrace()) {}
		
	CouldntReadCDBExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CouldntReadCDBExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CouldntReadCDBExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CouldntReadCDBExImpl (const cdbErrType::CouldntReadCDBEx & ex) : 
			cdbErrTypeExImpl(ex.errorTrace) {}
			
	cdbErrType::CouldntReadCDBEx getCouldntReadCDBEx () { return cdbErrType::CouldntReadCDBEx (getErrorTrace()); }
	
	template <class T >
	CouldntReadCDBExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class CouldntWriteCDBExImpl: public cdbErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::cdbErrType;
	static const ACSErr::ErrorCode m_code = CouldntWriteCDB;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CouldntWriteCDBExImpl(const CouldntWriteCDBExImpl& ex) :
			cdbErrTypeExImpl(const_cast<CouldntWriteCDBExImpl&>(ex).getErrorTrace()) {}
		
	CouldntWriteCDBExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CouldntWriteCDBExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CouldntWriteCDBExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CouldntWriteCDBExImpl (const cdbErrType::CouldntWriteCDBEx & ex) : 
			cdbErrTypeExImpl(ex.errorTrace) {}
			
	cdbErrType::CouldntWriteCDBEx getCouldntWriteCDBEx () { return cdbErrType::CouldntWriteCDBEx (getErrorTrace()); }
	
	template <class T >
	CouldntWriteCDBExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class CDBRecordIsReadOnlyExImpl: public cdbErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::cdbErrType;
	static const ACSErr::ErrorCode m_code = CDBRecordIsReadOnly;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CDBRecordIsReadOnlyExImpl(const CDBRecordIsReadOnlyExImpl& ex) :
			cdbErrTypeExImpl(const_cast<CDBRecordIsReadOnlyExImpl&>(ex).getErrorTrace()) {}
		
	CDBRecordIsReadOnlyExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CDBRecordIsReadOnlyExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CDBRecordIsReadOnlyExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CDBRecordIsReadOnlyExImpl (const cdbErrType::CDBRecordIsReadOnlyEx & ex) : 
			cdbErrTypeExImpl(ex.errorTrace) {}
			
	cdbErrType::CDBRecordIsReadOnlyEx getCDBRecordIsReadOnlyEx () { return cdbErrType::CDBRecordIsReadOnlyEx (getErrorTrace()); }
	
	template <class T >
	CDBRecordIsReadOnlyExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setCurl(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Curl", value); }            				
	ACE_CString getCurl (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Curl");  }

	
};

class CDBFieldIsReadOnlyExImpl: public cdbErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::cdbErrType;
	static const ACSErr::ErrorCode m_code = CDBFieldIsReadOnly;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CDBFieldIsReadOnlyExImpl(const CDBFieldIsReadOnlyExImpl& ex) :
			cdbErrTypeExImpl(const_cast<CDBFieldIsReadOnlyExImpl&>(ex).getErrorTrace()) {}
		
	CDBFieldIsReadOnlyExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CDBFieldIsReadOnlyExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CDBFieldIsReadOnlyExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CDBFieldIsReadOnlyExImpl (const cdbErrType::CDBFieldIsReadOnlyEx & ex) : 
			cdbErrTypeExImpl(ex.errorTrace) {}
			
	cdbErrType::CDBFieldIsReadOnlyEx getCDBFieldIsReadOnlyEx () { return cdbErrType::CDBFieldIsReadOnlyEx (getErrorTrace()); }
	
	template <class T >
	CDBFieldIsReadOnlyExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setFieldName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("FieldName", value); }            				
	ACE_CString getFieldName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("FieldName");  }

	
};

class CDBReadoOnlyDataExImpl: public cdbErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::cdbErrType;
	static const ACSErr::ErrorCode m_code = CDBReadoOnlyData;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CDBReadoOnlyDataExImpl(const CDBReadoOnlyDataExImpl& ex) :
			cdbErrTypeExImpl(const_cast<CDBReadoOnlyDataExImpl&>(ex).getErrorTrace()) {}
		
	CDBReadoOnlyDataExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CDBReadoOnlyDataExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CDBReadoOnlyDataExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CDBReadoOnlyDataExImpl (const cdbErrType::CDBReadoOnlyDataEx & ex) : 
			cdbErrTypeExImpl(ex.errorTrace) {}
			
	cdbErrType::CDBReadoOnlyDataEx getCDBReadoOnlyDataEx () { return cdbErrType::CDBReadoOnlyDataEx (getErrorTrace()); }
	
	template <class T >
	CDBReadoOnlyDataExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class WrongCDBDataTypeExImpl: public cdbErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::cdbErrType;
	static const ACSErr::ErrorCode m_code = WrongCDBDataType;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	WrongCDBDataTypeExImpl(const WrongCDBDataTypeExImpl& ex) :
			cdbErrTypeExImpl(const_cast<WrongCDBDataTypeExImpl&>(ex).getErrorTrace()) {}
		
	WrongCDBDataTypeExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	WrongCDBDataTypeExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	WrongCDBDataTypeExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	WrongCDBDataTypeExImpl (const cdbErrType::WrongCDBDataTypeEx & ex) : 
			cdbErrTypeExImpl(ex.errorTrace) {}
			
	cdbErrType::WrongCDBDataTypeEx getWrongCDBDataTypeEx () { return cdbErrType::WrongCDBDataTypeEx (getErrorTrace()); }
	
	template <class T >
	WrongCDBDataTypeExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setValue(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Value", value); }            				
	ACE_CString getValue (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Value");  }

		void setDataType(ACE_CString value){ getErrorTraceHelper()->setMemberValue("DataType", value); }            				
	ACE_CString getDataType (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("DataType");  }

	
};

class CDBRecordAlreadyExistsExImpl: public cdbErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::cdbErrType;
	static const ACSErr::ErrorCode m_code = CDBRecordAlreadyExists;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CDBRecordAlreadyExistsExImpl(const CDBRecordAlreadyExistsExImpl& ex) :
			cdbErrTypeExImpl(const_cast<CDBRecordAlreadyExistsExImpl&>(ex).getErrorTrace()) {}
		
	CDBRecordAlreadyExistsExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CDBRecordAlreadyExistsExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CDBRecordAlreadyExistsExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CDBRecordAlreadyExistsExImpl (const cdbErrType::CDBRecordAlreadyExistsEx & ex) : 
			cdbErrTypeExImpl(ex.errorTrace) {}
			
	cdbErrType::CDBRecordAlreadyExistsEx getCDBRecordAlreadyExistsEx () { return cdbErrType::CDBRecordAlreadyExistsEx (getErrorTrace()); }
	
	template <class T >
	CDBRecordAlreadyExistsExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setCurl(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Curl", value); }            				
	ACE_CString getCurl (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Curl");  }

	
};

class CDBExceptionExImpl: public cdbErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::cdbErrType;
	static const ACSErr::ErrorCode m_code = CDBException;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CDBExceptionExImpl(const CDBExceptionExImpl& ex) :
			cdbErrTypeExImpl(const_cast<CDBExceptionExImpl&>(ex).getErrorTrace()) {}
		
	CDBExceptionExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CDBExceptionExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CDBExceptionExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CDBExceptionExImpl (const cdbErrType::CDBExceptionEx & ex) : 
			cdbErrTypeExImpl(ex.errorTrace) {}
			
	cdbErrType::CDBExceptionEx getCDBExceptionEx () { return cdbErrType::CDBExceptionEx (getErrorTrace()); }
	
	template <class T >
	CDBExceptionExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class CDBFieldDoesNotExistExImpl: public cdbErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::cdbErrType;
	static const ACSErr::ErrorCode m_code = CDBFieldDoesNotExist;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CDBFieldDoesNotExistExImpl(const CDBFieldDoesNotExistExImpl& ex) :
			cdbErrTypeExImpl(const_cast<CDBFieldDoesNotExistExImpl&>(ex).getErrorTrace()) {}
		
	CDBFieldDoesNotExistExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CDBFieldDoesNotExistExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CDBFieldDoesNotExistExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CDBFieldDoesNotExistExImpl (const cdbErrType::CDBFieldDoesNotExistEx & ex) : 
			cdbErrTypeExImpl(ex.errorTrace) {}
			
	cdbErrType::CDBFieldDoesNotExistEx getCDBFieldDoesNotExistEx () { return cdbErrType::CDBFieldDoesNotExistEx (getErrorTrace()); }
	
	template <class T >
	CDBFieldDoesNotExistExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setFieldName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("FieldName", value); }            				
	ACE_CString getFieldName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("FieldName");  }

	
};

class CDBRecordDoesNotExistExImpl: public cdbErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::cdbErrType;
	static const ACSErr::ErrorCode m_code = CDBRecordDoesNotExist;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CDBRecordDoesNotExistExImpl(const CDBRecordDoesNotExistExImpl& ex) :
			cdbErrTypeExImpl(const_cast<CDBRecordDoesNotExistExImpl&>(ex).getErrorTrace()) {}
		
	CDBRecordDoesNotExistExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CDBRecordDoesNotExistExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CDBRecordDoesNotExistExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CDBRecordDoesNotExistExImpl (const cdbErrType::CDBRecordDoesNotExistEx & ex) : 
			cdbErrTypeExImpl(ex.errorTrace) {}
			
	cdbErrType::CDBRecordDoesNotExistEx getCDBRecordDoesNotExistEx () { return cdbErrType::CDBRecordDoesNotExistEx (getErrorTrace()); }
	
	template <class T >
	CDBRecordDoesNotExistExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setCurl(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Curl", value); }            				
	ACE_CString getCurl (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Curl");  }

	
};

class CDBXMLErrorExImpl: public cdbErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::cdbErrType;
	static const ACSErr::ErrorCode m_code = CDBXMLError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CDBXMLErrorExImpl(const CDBXMLErrorExImpl& ex) :
			cdbErrTypeExImpl(const_cast<CDBXMLErrorExImpl&>(ex).getErrorTrace()) {}
		
	CDBXMLErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CDBXMLErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CDBXMLErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CDBXMLErrorExImpl (const cdbErrType::CDBXMLErrorEx & ex) : 
			cdbErrTypeExImpl(ex.errorTrace) {}
			
	cdbErrType::CDBXMLErrorEx getCDBXMLErrorEx () { return cdbErrType::CDBXMLErrorEx (getErrorTrace()); }
	
	template <class T >
	CDBXMLErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			cdbErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setFilename(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Filename", value); }            				
	ACE_CString getFilename (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Filename");  }


		void setCurl(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Curl", value); }            				
	ACE_CString getCurl (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Curl");  }

		
		void setNodename(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Nodename", value); }            				
	ACE_CString getNodename (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Nodename");  }

				
		void setErrorString(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ErrorString", value); }            				
	ACE_CString getErrorString (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ErrorString");  }


	
};

}

#endif
