#ifndef _baciErrTypeProperty_H_
#define _baciErrTypeProperty_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "baciErrTypePropertyC.h"

#include "acserrExceptionManager.h"

namespace baciErrTypeProperty
{

class PropertyStaticDataCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::baciErrTypeProperty; // = 20
	static const ACSErr::ErrorCode m_code = PropertyStaticData;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return PropertyStaticDataCompletion::m_shortDescription; }
	PropertyStaticDataCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	PropertyStaticDataCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	PropertyStaticDataCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	PropertyStaticDataCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	PropertyStaticDataCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	PropertyStaticDataCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class PropertyCreationCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::baciErrTypeProperty; // = 20
	static const ACSErr::ErrorCode m_code = PropertyCreation;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return PropertyCreationCompletion::m_shortDescription; }
	PropertyCreationCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	PropertyCreationCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	PropertyCreationCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	PropertyCreationCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	PropertyCreationCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	PropertyCreationCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class PropertyActivationCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::baciErrTypeProperty; // = 20
	static const ACSErr::ErrorCode m_code = PropertyActivation;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return PropertyActivationCompletion::m_shortDescription; }
	PropertyActivationCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	PropertyActivationCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	PropertyActivationCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	PropertyActivationCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	PropertyActivationCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	PropertyActivationCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class PropertySetInitValueCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::baciErrTypeProperty; // = 20
	static const ACSErr::ErrorCode m_code = PropertySetInitValue;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return PropertySetInitValueCompletion::m_shortDescription; }
	PropertySetInitValueCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	PropertySetInitValueCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	PropertySetInitValueCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	PropertySetInitValueCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	PropertySetInitValueCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	PropertySetInitValueCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class CanNotSetValueCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::baciErrTypeProperty; // = 20
	static const ACSErr::ErrorCode m_code = CanNotSetValue;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CanNotSetValueCompletion::m_shortDescription; }
	CanNotSetValueCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CanNotSetValueCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CanNotSetValueCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CanNotSetValueCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CanNotSetValueCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CanNotSetValueCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

           void setProperty(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Property", value); }            				
	ACE_CString getProperty (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Property");  }


};

class CanNotGetValueCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::baciErrTypeProperty; // = 20
	static const ACSErr::ErrorCode m_code = CanNotGetValue;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CanNotGetValueCompletion::m_shortDescription; }
	CanNotGetValueCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CanNotGetValueCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CanNotGetValueCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CanNotGetValueCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CanNotGetValueCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CanNotGetValueCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

	   void setProperty(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Property", value); }            				
	ACE_CString getProperty (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Property");  }


};

class InvokeActionErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::baciErrTypeProperty; // = 20
	static const ACSErr::ErrorCode m_code = InvokeActionError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return InvokeActionErrorCompletion::m_shortDescription; }
	InvokeActionErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	InvokeActionErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	InvokeActionErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	InvokeActionErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	InvokeActionErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	InvokeActionErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class IncrementErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::baciErrTypeProperty; // = 20
	static const ACSErr::ErrorCode m_code = IncrementError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return IncrementErrorCompletion::m_shortDescription; }
	IncrementErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	IncrementErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	IncrementErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	IncrementErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	IncrementErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	IncrementErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class DecrementErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::baciErrTypeProperty; // = 20
	static const ACSErr::ErrorCode m_code = DecrementError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return DecrementErrorCompletion::m_shortDescription; }
	DecrementErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	DecrementErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	DecrementErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	DecrementErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	DecrementErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	DecrementErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class ArchiveMonitorProblemCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::baciErrTypeProperty; // = 20
	static const ACSErr::ErrorCode m_code = ArchiveMonitorProblem;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return ArchiveMonitorProblemCompletion::m_shortDescription; }
	ArchiveMonitorProblemCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	ArchiveMonitorProblemCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ArchiveMonitorProblemCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ArchiveMonitorProblemCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ArchiveMonitorProblemCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	ArchiveMonitorProblemCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class baciErrTypePropertyExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	baciErrTypePropertyExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	baciErrTypePropertyExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	baciErrTypePropertyExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	baciErrTypePropertyExImpl (baciErrTypeProperty::baciErrTypePropertyEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	baciErrTypeProperty::baciErrTypePropertyEx getbaciErrTypePropertyEx () { return baciErrTypeProperty::baciErrTypePropertyEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class PropertyStaticDataExImpl: public baciErrTypePropertyExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::baciErrTypeProperty;
	static const ACSErr::ErrorCode m_code = PropertyStaticData;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	PropertyStaticDataExImpl(const PropertyStaticDataExImpl& ex) :
			baciErrTypePropertyExImpl(const_cast<PropertyStaticDataExImpl&>(ex).getErrorTrace()) {}
		
	PropertyStaticDataExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	PropertyStaticDataExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	PropertyStaticDataExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	PropertyStaticDataExImpl (const baciErrTypeProperty::PropertyStaticDataEx & ex) : 
			baciErrTypePropertyExImpl(ex.errorTrace) {}
			
	baciErrTypeProperty::PropertyStaticDataEx getPropertyStaticDataEx () { return baciErrTypeProperty::PropertyStaticDataEx (getErrorTrace()); }
	
	template <class T >
	PropertyStaticDataExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class PropertyCreationExImpl: public baciErrTypePropertyExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::baciErrTypeProperty;
	static const ACSErr::ErrorCode m_code = PropertyCreation;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	PropertyCreationExImpl(const PropertyCreationExImpl& ex) :
			baciErrTypePropertyExImpl(const_cast<PropertyCreationExImpl&>(ex).getErrorTrace()) {}
		
	PropertyCreationExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	PropertyCreationExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	PropertyCreationExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	PropertyCreationExImpl (const baciErrTypeProperty::PropertyCreationEx & ex) : 
			baciErrTypePropertyExImpl(ex.errorTrace) {}
			
	baciErrTypeProperty::PropertyCreationEx getPropertyCreationEx () { return baciErrTypeProperty::PropertyCreationEx (getErrorTrace()); }
	
	template <class T >
	PropertyCreationExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class PropertyActivationExImpl: public baciErrTypePropertyExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::baciErrTypeProperty;
	static const ACSErr::ErrorCode m_code = PropertyActivation;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	PropertyActivationExImpl(const PropertyActivationExImpl& ex) :
			baciErrTypePropertyExImpl(const_cast<PropertyActivationExImpl&>(ex).getErrorTrace()) {}
		
	PropertyActivationExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	PropertyActivationExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	PropertyActivationExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	PropertyActivationExImpl (const baciErrTypeProperty::PropertyActivationEx & ex) : 
			baciErrTypePropertyExImpl(ex.errorTrace) {}
			
	baciErrTypeProperty::PropertyActivationEx getPropertyActivationEx () { return baciErrTypeProperty::PropertyActivationEx (getErrorTrace()); }
	
	template <class T >
	PropertyActivationExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class PropertySetInitValueExImpl: public baciErrTypePropertyExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::baciErrTypeProperty;
	static const ACSErr::ErrorCode m_code = PropertySetInitValue;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	PropertySetInitValueExImpl(const PropertySetInitValueExImpl& ex) :
			baciErrTypePropertyExImpl(const_cast<PropertySetInitValueExImpl&>(ex).getErrorTrace()) {}
		
	PropertySetInitValueExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	PropertySetInitValueExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	PropertySetInitValueExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	PropertySetInitValueExImpl (const baciErrTypeProperty::PropertySetInitValueEx & ex) : 
			baciErrTypePropertyExImpl(ex.errorTrace) {}
			
	baciErrTypeProperty::PropertySetInitValueEx getPropertySetInitValueEx () { return baciErrTypeProperty::PropertySetInitValueEx (getErrorTrace()); }
	
	template <class T >
	PropertySetInitValueExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class CanNotSetValueExImpl: public baciErrTypePropertyExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::baciErrTypeProperty;
	static const ACSErr::ErrorCode m_code = CanNotSetValue;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CanNotSetValueExImpl(const CanNotSetValueExImpl& ex) :
			baciErrTypePropertyExImpl(const_cast<CanNotSetValueExImpl&>(ex).getErrorTrace()) {}
		
	CanNotSetValueExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CanNotSetValueExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CanNotSetValueExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CanNotSetValueExImpl (const baciErrTypeProperty::CanNotSetValueEx & ex) : 
			baciErrTypePropertyExImpl(ex.errorTrace) {}
			
	baciErrTypeProperty::CanNotSetValueEx getCanNotSetValueEx () { return baciErrTypeProperty::CanNotSetValueEx (getErrorTrace()); }
	
	template <class T >
	CanNotSetValueExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


           void setProperty(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Property", value); }            				
	ACE_CString getProperty (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Property");  }


};

class CanNotGetValueExImpl: public baciErrTypePropertyExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::baciErrTypeProperty;
	static const ACSErr::ErrorCode m_code = CanNotGetValue;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CanNotGetValueExImpl(const CanNotGetValueExImpl& ex) :
			baciErrTypePropertyExImpl(const_cast<CanNotGetValueExImpl&>(ex).getErrorTrace()) {}
		
	CanNotGetValueExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CanNotGetValueExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CanNotGetValueExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CanNotGetValueExImpl (const baciErrTypeProperty::CanNotGetValueEx & ex) : 
			baciErrTypePropertyExImpl(ex.errorTrace) {}
			
	baciErrTypeProperty::CanNotGetValueEx getCanNotGetValueEx () { return baciErrTypeProperty::CanNotGetValueEx (getErrorTrace()); }
	
	template <class T >
	CanNotGetValueExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


	   void setProperty(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Property", value); }            				
	ACE_CString getProperty (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Property");  }


};

class InvokeActionErrorExImpl: public baciErrTypePropertyExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::baciErrTypeProperty;
	static const ACSErr::ErrorCode m_code = InvokeActionError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	InvokeActionErrorExImpl(const InvokeActionErrorExImpl& ex) :
			baciErrTypePropertyExImpl(const_cast<InvokeActionErrorExImpl&>(ex).getErrorTrace()) {}
		
	InvokeActionErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	InvokeActionErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	InvokeActionErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	InvokeActionErrorExImpl (const baciErrTypeProperty::InvokeActionErrorEx & ex) : 
			baciErrTypePropertyExImpl(ex.errorTrace) {}
			
	baciErrTypeProperty::InvokeActionErrorEx getInvokeActionErrorEx () { return baciErrTypeProperty::InvokeActionErrorEx (getErrorTrace()); }
	
	template <class T >
	InvokeActionErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class IncrementErrorExImpl: public baciErrTypePropertyExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::baciErrTypeProperty;
	static const ACSErr::ErrorCode m_code = IncrementError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	IncrementErrorExImpl(const IncrementErrorExImpl& ex) :
			baciErrTypePropertyExImpl(const_cast<IncrementErrorExImpl&>(ex).getErrorTrace()) {}
		
	IncrementErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	IncrementErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	IncrementErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	IncrementErrorExImpl (const baciErrTypeProperty::IncrementErrorEx & ex) : 
			baciErrTypePropertyExImpl(ex.errorTrace) {}
			
	baciErrTypeProperty::IncrementErrorEx getIncrementErrorEx () { return baciErrTypeProperty::IncrementErrorEx (getErrorTrace()); }
	
	template <class T >
	IncrementErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class DecrementErrorExImpl: public baciErrTypePropertyExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::baciErrTypeProperty;
	static const ACSErr::ErrorCode m_code = DecrementError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	DecrementErrorExImpl(const DecrementErrorExImpl& ex) :
			baciErrTypePropertyExImpl(const_cast<DecrementErrorExImpl&>(ex).getErrorTrace()) {}
		
	DecrementErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	DecrementErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	DecrementErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	DecrementErrorExImpl (const baciErrTypeProperty::DecrementErrorEx & ex) : 
			baciErrTypePropertyExImpl(ex.errorTrace) {}
			
	baciErrTypeProperty::DecrementErrorEx getDecrementErrorEx () { return baciErrTypeProperty::DecrementErrorEx (getErrorTrace()); }
	
	template <class T >
	DecrementErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class ArchiveMonitorProblemExImpl: public baciErrTypePropertyExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::baciErrTypeProperty;
	static const ACSErr::ErrorCode m_code = ArchiveMonitorProblem;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	ArchiveMonitorProblemExImpl(const ArchiveMonitorProblemExImpl& ex) :
			baciErrTypePropertyExImpl(const_cast<ArchiveMonitorProblemExImpl&>(ex).getErrorTrace()) {}
		
	ArchiveMonitorProblemExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	ArchiveMonitorProblemExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ArchiveMonitorProblemExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ArchiveMonitorProblemExImpl (const baciErrTypeProperty::ArchiveMonitorProblemEx & ex) : 
			baciErrTypePropertyExImpl(ex.errorTrace) {}
			
	baciErrTypeProperty::ArchiveMonitorProblemEx getArchiveMonitorProblemEx () { return baciErrTypeProperty::ArchiveMonitorProblemEx (getErrorTrace()); }
	
	template <class T >
	ArchiveMonitorProblemExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			baciErrTypePropertyExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

}

#endif
