#ifndef _ARCHIVE_BULK_SENDER_IMPL_H
#define _ARCHIVE_BULK_SENDER_IMPL_H
/*******************************************************************************
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration)
 *    and Cosylab 2002, All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 *
 * "@(#)"
 *
 * who       when      what
 * --------  --------  ----------------------------------------------
 * oat       28/01/05  created 
 */

/************************************************************************
 *
 *----------------------------------------------------------------------
 */

#include "archiveBulkSenderS.h"
#include "bulkDataSenderImpl.h"
#include "bulkDataSenderDefaultCb.h"

#include "EventComponentS.h"
#include "acsncSimpleSupplier.h"
#include "acsContainerServices.h"
#include "ACSBulkDataError.h"

#include <baci.h>
#include <archive_xmlstore_ifC.h>
#include <acscomponentC.h>

extern "C" {
# include "ngams.h"
}

//#include "bulkDataSenderEx1.h"
//#include "bulkDataReceiverEx2C.h"

//using namespace baci;
using namespace maci;
using namespace std;
using namespace ACSBulkDataError;

//template<class TSenderCallback>
class ArchiveBulkSenderImpl : public virtual BulkDataSenderDefaultImpl,
			      public virtual POA_archive::ArchiveBulkSender
{    
 public:
  /**
   * Constructor
   * @param poa poa which will activate this and also all other components 
   * @param name component name
   */
    ArchiveBulkSenderImpl(const ACE_CString& name,ContainerServices* containerServices);
  
  /**
   * Destructor
   */
   virtual ~ArchiveBulkSenderImpl();
  
    void ArchiveBulkSenderImpl::initialize() throw (ACSErr::ACSbaseExImpl);
      
  virtual void startSend()
    throw (CORBA::SystemException, AVStartSendErrorEx);

  virtual void stopSend()
    throw (CORBA::SystemException, AVStopSendErrorEx);


    virtual void paceData ()
        throw (CORBA::SystemException, AVPaceDataErrorEx);

    virtual void getBulkData(const char* uid)
      throw (CORBA::SystemException);
      
virtual bool ArchiveBulkSenderImpl::ping() throw (CORBA::SystemException);

  private : 
    // the uid to fetch, passed and set in getBulkData
    char *m_uid;// char m_uid[33];
    // the uid to fetch, passed and set in getBulkData, modified there to accomodate NGAS filenames
    char *fetchUID;// char fetchUID[33];
    // do we use the local file system (useNGAS=0) or NGAS (useNGAS=1), BULKSTORE_MODE the same;
    int useNGAS, BULKSTORE_MODE;
    // if local file system is used
    FILE * fp;
    // did a failure occur? 
    archive::ArchiveBulkSender::resultType sendResult;

  // if not using NGAS, name of dir where bulkdata is written to:
  string BULKSTORE_DIR;
  
// name of host where NGAMS is running
    ACE_CString NGAMS_HOST;  
// port where NGAMS is running
    int NGAMS_PORT;   
// identification of this client for NGAMS
    ACE_CString CLIENT_NAME;   
// Name of ArchiveConnection component
    ACE_CString archiveConnName;   
// Name of bulkdata schema
    ACE_CString bulkDataSchemaName;   
// version of bulkdata schema
    ACE_CString bulkDataSchemaVersion;   


// refernce to Archive connection, initialized in constructor
    xmlstore::ArchiveConnection_var archConn;
// references to XMLstore Admin, initialized in constructo:
	  xmlstore::Administrative *admin;

    ngamsHTTP_DATA repDataRef;
    ngamsDATA_LEN repDataLen;

    // set to 1, if data send is in progress. During this time, all calls are delayed until
    // dataSending is again 0;
    static int dataSending;

	// for sending out events:
	nc::SimpleSupplier *m_eventSupplier;
};

#endif
