#ifndef _acsthreadErrType_H_
#define _acsthreadErrType_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "acsthreadErrTypeC.h"

#include "acserrExceptionManager.h"

namespace acsthreadErrType
{

class CanNotSpawnThreadCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsthreadErrType; // = 37
	static const ACSErr::ErrorCode m_code = CanNotSpawnThread;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CanNotSpawnThreadCompletion::m_shortDescription; }
	CanNotSpawnThreadCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CanNotSpawnThreadCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CanNotSpawnThreadCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CanNotSpawnThreadCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CanNotSpawnThreadCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CanNotSpawnThreadCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

	void setThreadName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ThreadName", value); }            				
	ACE_CString getThreadName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ThreadName");  }
	
  
};

class CanNotCreateThreadCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsthreadErrType; // = 37
	static const ACSErr::ErrorCode m_code = CanNotCreateThread;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CanNotCreateThreadCompletion::m_shortDescription; }
	CanNotCreateThreadCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CanNotCreateThreadCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CanNotCreateThreadCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CanNotCreateThreadCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CanNotCreateThreadCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CanNotCreateThreadCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class ThreadAlreadyExistCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsthreadErrType; // = 37
	static const ACSErr::ErrorCode m_code = ThreadAlreadyExist;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return ThreadAlreadyExistCompletion::m_shortDescription; }
	ThreadAlreadyExistCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	ThreadAlreadyExistCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ThreadAlreadyExistCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ThreadAlreadyExistCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ThreadAlreadyExistCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	ThreadAlreadyExistCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

	void setThreadName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ThreadName", value); }            				
	ACE_CString getThreadName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ThreadName");  }
	
 
};

class CanNotStartThreadCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsthreadErrType; // = 37
	static const ACSErr::ErrorCode m_code = CanNotStartThread;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CanNotStartThreadCompletion::m_shortDescription; }
	CanNotStartThreadCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CanNotStartThreadCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CanNotStartThreadCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CanNotStartThreadCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CanNotStartThreadCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CanNotStartThreadCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

           void setThreadName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ThreadName", value); }            				
	ACE_CString getThreadName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ThreadName");  }


};

class CanNotSuspendThreadCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsthreadErrType; // = 37
	static const ACSErr::ErrorCode m_code = CanNotSuspendThread;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CanNotSuspendThreadCompletion::m_shortDescription; }
	CanNotSuspendThreadCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CanNotSuspendThreadCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CanNotSuspendThreadCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CanNotSuspendThreadCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CanNotSuspendThreadCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CanNotSuspendThreadCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

           void setThreadName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ThreadName", value); }            				
	ACE_CString getThreadName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ThreadName");  }


};

class CanNotResumeThreadCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsthreadErrType; // = 37
	static const ACSErr::ErrorCode m_code = CanNotResumeThread;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CanNotResumeThreadCompletion::m_shortDescription; }
	CanNotResumeThreadCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CanNotResumeThreadCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CanNotResumeThreadCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CanNotResumeThreadCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CanNotResumeThreadCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CanNotResumeThreadCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

           void setThreadName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ThreadName", value); }            				
	ACE_CString getThreadName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ThreadName");  }


};

class ExceptionInOnStartCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsthreadErrType; // = 37
	static const ACSErr::ErrorCode m_code = ExceptionInOnStart;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return ExceptionInOnStartCompletion::m_shortDescription; }
	ExceptionInOnStartCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	ExceptionInOnStartCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ExceptionInOnStartCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ExceptionInOnStartCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ExceptionInOnStartCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	ExceptionInOnStartCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

           void setThreadName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ThreadName", value); }            				
	ACE_CString getThreadName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ThreadName");  }


};

class ExceptionInOnStopCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsthreadErrType; // = 37
	static const ACSErr::ErrorCode m_code = ExceptionInOnStop;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return ExceptionInOnStopCompletion::m_shortDescription; }
	ExceptionInOnStopCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	ExceptionInOnStopCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ExceptionInOnStopCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ExceptionInOnStopCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ExceptionInOnStopCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	ExceptionInOnStopCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

           void setThreadName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ThreadName", value); }            				
	ACE_CString getThreadName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ThreadName");  }


};

class ExceptionInRunLoopCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsthreadErrType; // = 37
	static const ACSErr::ErrorCode m_code = ExceptionInRunLoop;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return ExceptionInRunLoopCompletion::m_shortDescription; }
	ExceptionInRunLoopCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	ExceptionInRunLoopCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ExceptionInRunLoopCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ExceptionInRunLoopCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ExceptionInRunLoopCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	ExceptionInRunLoopCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

           void setThreadName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ThreadName", value); }            				
	ACE_CString getThreadName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ThreadName");  }


};

class ThreadExecutionProblemCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsthreadErrType; // = 37
	static const ACSErr::ErrorCode m_code = ThreadExecutionProblem;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return ThreadExecutionProblemCompletion::m_shortDescription; }
	ThreadExecutionProblemCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	ThreadExecutionProblemCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ThreadExecutionProblemCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ThreadExecutionProblemCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ThreadExecutionProblemCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	ThreadExecutionProblemCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

           void setThreadName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ThreadName", value); }            				
	ACE_CString getThreadName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ThreadName");  }


};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class acsthreadErrTypeExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	acsthreadErrTypeExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	acsthreadErrTypeExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	acsthreadErrTypeExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	acsthreadErrTypeExImpl (acsthreadErrType::acsthreadErrTypeEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	acsthreadErrType::acsthreadErrTypeEx getacsthreadErrTypeEx () { return acsthreadErrType::acsthreadErrTypeEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class CanNotSpawnThreadExImpl: public acsthreadErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsthreadErrType;
	static const ACSErr::ErrorCode m_code = CanNotSpawnThread;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CanNotSpawnThreadExImpl(const CanNotSpawnThreadExImpl& ex) :
			acsthreadErrTypeExImpl(const_cast<CanNotSpawnThreadExImpl&>(ex).getErrorTrace()) {}
		
	CanNotSpawnThreadExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CanNotSpawnThreadExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CanNotSpawnThreadExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CanNotSpawnThreadExImpl (const acsthreadErrType::CanNotSpawnThreadEx & ex) : 
			acsthreadErrTypeExImpl(ex.errorTrace) {}
			
	acsthreadErrType::CanNotSpawnThreadEx getCanNotSpawnThreadEx () { return acsthreadErrType::CanNotSpawnThreadEx (getErrorTrace()); }
	
	template <class T >
	CanNotSpawnThreadExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


	void setThreadName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ThreadName", value); }            				
	ACE_CString getThreadName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ThreadName");  }
	
  
};

class CanNotCreateThreadExImpl: public acsthreadErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsthreadErrType;
	static const ACSErr::ErrorCode m_code = CanNotCreateThread;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CanNotCreateThreadExImpl(const CanNotCreateThreadExImpl& ex) :
			acsthreadErrTypeExImpl(const_cast<CanNotCreateThreadExImpl&>(ex).getErrorTrace()) {}
		
	CanNotCreateThreadExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CanNotCreateThreadExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CanNotCreateThreadExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CanNotCreateThreadExImpl (const acsthreadErrType::CanNotCreateThreadEx & ex) : 
			acsthreadErrTypeExImpl(ex.errorTrace) {}
			
	acsthreadErrType::CanNotCreateThreadEx getCanNotCreateThreadEx () { return acsthreadErrType::CanNotCreateThreadEx (getErrorTrace()); }
	
	template <class T >
	CanNotCreateThreadExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class ThreadAlreadyExistExImpl: public acsthreadErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsthreadErrType;
	static const ACSErr::ErrorCode m_code = ThreadAlreadyExist;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	ThreadAlreadyExistExImpl(const ThreadAlreadyExistExImpl& ex) :
			acsthreadErrTypeExImpl(const_cast<ThreadAlreadyExistExImpl&>(ex).getErrorTrace()) {}
		
	ThreadAlreadyExistExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	ThreadAlreadyExistExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ThreadAlreadyExistExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ThreadAlreadyExistExImpl (const acsthreadErrType::ThreadAlreadyExistEx & ex) : 
			acsthreadErrTypeExImpl(ex.errorTrace) {}
			
	acsthreadErrType::ThreadAlreadyExistEx getThreadAlreadyExistEx () { return acsthreadErrType::ThreadAlreadyExistEx (getErrorTrace()); }
	
	template <class T >
	ThreadAlreadyExistExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


	void setThreadName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ThreadName", value); }            				
	ACE_CString getThreadName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ThreadName");  }
	
 
};

class CanNotStartThreadExImpl: public acsthreadErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsthreadErrType;
	static const ACSErr::ErrorCode m_code = CanNotStartThread;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CanNotStartThreadExImpl(const CanNotStartThreadExImpl& ex) :
			acsthreadErrTypeExImpl(const_cast<CanNotStartThreadExImpl&>(ex).getErrorTrace()) {}
		
	CanNotStartThreadExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CanNotStartThreadExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CanNotStartThreadExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CanNotStartThreadExImpl (const acsthreadErrType::CanNotStartThreadEx & ex) : 
			acsthreadErrTypeExImpl(ex.errorTrace) {}
			
	acsthreadErrType::CanNotStartThreadEx getCanNotStartThreadEx () { return acsthreadErrType::CanNotStartThreadEx (getErrorTrace()); }
	
	template <class T >
	CanNotStartThreadExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


           void setThreadName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ThreadName", value); }            				
	ACE_CString getThreadName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ThreadName");  }


};

class CanNotSuspendThreadExImpl: public acsthreadErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsthreadErrType;
	static const ACSErr::ErrorCode m_code = CanNotSuspendThread;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CanNotSuspendThreadExImpl(const CanNotSuspendThreadExImpl& ex) :
			acsthreadErrTypeExImpl(const_cast<CanNotSuspendThreadExImpl&>(ex).getErrorTrace()) {}
		
	CanNotSuspendThreadExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CanNotSuspendThreadExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CanNotSuspendThreadExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CanNotSuspendThreadExImpl (const acsthreadErrType::CanNotSuspendThreadEx & ex) : 
			acsthreadErrTypeExImpl(ex.errorTrace) {}
			
	acsthreadErrType::CanNotSuspendThreadEx getCanNotSuspendThreadEx () { return acsthreadErrType::CanNotSuspendThreadEx (getErrorTrace()); }
	
	template <class T >
	CanNotSuspendThreadExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


           void setThreadName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ThreadName", value); }            				
	ACE_CString getThreadName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ThreadName");  }


};

class CanNotResumeThreadExImpl: public acsthreadErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsthreadErrType;
	static const ACSErr::ErrorCode m_code = CanNotResumeThread;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CanNotResumeThreadExImpl(const CanNotResumeThreadExImpl& ex) :
			acsthreadErrTypeExImpl(const_cast<CanNotResumeThreadExImpl&>(ex).getErrorTrace()) {}
		
	CanNotResumeThreadExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CanNotResumeThreadExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CanNotResumeThreadExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CanNotResumeThreadExImpl (const acsthreadErrType::CanNotResumeThreadEx & ex) : 
			acsthreadErrTypeExImpl(ex.errorTrace) {}
			
	acsthreadErrType::CanNotResumeThreadEx getCanNotResumeThreadEx () { return acsthreadErrType::CanNotResumeThreadEx (getErrorTrace()); }
	
	template <class T >
	CanNotResumeThreadExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


           void setThreadName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ThreadName", value); }            				
	ACE_CString getThreadName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ThreadName");  }


};

class ExceptionInOnStartExImpl: public acsthreadErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsthreadErrType;
	static const ACSErr::ErrorCode m_code = ExceptionInOnStart;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	ExceptionInOnStartExImpl(const ExceptionInOnStartExImpl& ex) :
			acsthreadErrTypeExImpl(const_cast<ExceptionInOnStartExImpl&>(ex).getErrorTrace()) {}
		
	ExceptionInOnStartExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	ExceptionInOnStartExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ExceptionInOnStartExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ExceptionInOnStartExImpl (const acsthreadErrType::ExceptionInOnStartEx & ex) : 
			acsthreadErrTypeExImpl(ex.errorTrace) {}
			
	acsthreadErrType::ExceptionInOnStartEx getExceptionInOnStartEx () { return acsthreadErrType::ExceptionInOnStartEx (getErrorTrace()); }
	
	template <class T >
	ExceptionInOnStartExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


           void setThreadName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ThreadName", value); }            				
	ACE_CString getThreadName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ThreadName");  }


};

class ExceptionInOnStopExImpl: public acsthreadErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsthreadErrType;
	static const ACSErr::ErrorCode m_code = ExceptionInOnStop;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	ExceptionInOnStopExImpl(const ExceptionInOnStopExImpl& ex) :
			acsthreadErrTypeExImpl(const_cast<ExceptionInOnStopExImpl&>(ex).getErrorTrace()) {}
		
	ExceptionInOnStopExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	ExceptionInOnStopExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ExceptionInOnStopExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ExceptionInOnStopExImpl (const acsthreadErrType::ExceptionInOnStopEx & ex) : 
			acsthreadErrTypeExImpl(ex.errorTrace) {}
			
	acsthreadErrType::ExceptionInOnStopEx getExceptionInOnStopEx () { return acsthreadErrType::ExceptionInOnStopEx (getErrorTrace()); }
	
	template <class T >
	ExceptionInOnStopExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


           void setThreadName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ThreadName", value); }            				
	ACE_CString getThreadName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ThreadName");  }


};

class ExceptionInRunLoopExImpl: public acsthreadErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsthreadErrType;
	static const ACSErr::ErrorCode m_code = ExceptionInRunLoop;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	ExceptionInRunLoopExImpl(const ExceptionInRunLoopExImpl& ex) :
			acsthreadErrTypeExImpl(const_cast<ExceptionInRunLoopExImpl&>(ex).getErrorTrace()) {}
		
	ExceptionInRunLoopExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	ExceptionInRunLoopExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ExceptionInRunLoopExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ExceptionInRunLoopExImpl (const acsthreadErrType::ExceptionInRunLoopEx & ex) : 
			acsthreadErrTypeExImpl(ex.errorTrace) {}
			
	acsthreadErrType::ExceptionInRunLoopEx getExceptionInRunLoopEx () { return acsthreadErrType::ExceptionInRunLoopEx (getErrorTrace()); }
	
	template <class T >
	ExceptionInRunLoopExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


           void setThreadName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ThreadName", value); }            				
	ACE_CString getThreadName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ThreadName");  }


};

class ThreadExecutionProblemExImpl: public acsthreadErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsthreadErrType;
	static const ACSErr::ErrorCode m_code = ThreadExecutionProblem;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	ThreadExecutionProblemExImpl(const ThreadExecutionProblemExImpl& ex) :
			acsthreadErrTypeExImpl(const_cast<ThreadExecutionProblemExImpl&>(ex).getErrorTrace()) {}
		
	ThreadExecutionProblemExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	ThreadExecutionProblemExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ThreadExecutionProblemExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ThreadExecutionProblemExImpl (const acsthreadErrType::ThreadExecutionProblemEx & ex) : 
			acsthreadErrTypeExImpl(ex.errorTrace) {}
			
	acsthreadErrType::ThreadExecutionProblemEx getThreadExecutionProblemEx () { return acsthreadErrType::ThreadExecutionProblemEx (getErrorTrace()); }
	
	template <class T >
	ThreadExecutionProblemExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsthreadErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


           void setThreadName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ThreadName", value); }            				
	ACE_CString getThreadName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ThreadName");  }


};

}

#endif
