#ifndef _acserrHandlersErr_H_
#define _acserrHandlersErr_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "acserrHandlersErrC.h"

#include "acserrExceptionManager.h"

namespace acserrHandlersErr
{

class UnspecifiedACSBasedExceptionCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acserrHandlersErr; // = 6
	static const ACSErr::ErrorCode m_code = UnspecifiedACSBasedException;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return UnspecifiedACSBasedExceptionCompletion::m_shortDescription; }
	UnspecifiedACSBasedExceptionCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	UnspecifiedACSBasedExceptionCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnspecifiedACSBasedExceptionCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnspecifiedACSBasedExceptionCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnspecifiedACSBasedExceptionCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	UnspecifiedACSBasedExceptionCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class UnspecifiedCORBAExceptionCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acserrHandlersErr; // = 6
	static const ACSErr::ErrorCode m_code = UnspecifiedCORBAException;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return UnspecifiedCORBAExceptionCompletion::m_shortDescription; }
	UnspecifiedCORBAExceptionCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	UnspecifiedCORBAExceptionCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnspecifiedCORBAExceptionCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnspecifiedCORBAExceptionCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnspecifiedCORBAExceptionCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	UnspecifiedCORBAExceptionCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

	void setCORBAExName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CORBAExName", value); }            				
	ACE_CString getCORBAExName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CORBAExName");  }


};

class UnspecifiedSTDExceptionCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acserrHandlersErr; // = 6
	static const ACSErr::ErrorCode m_code = UnspecifiedSTDException;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return UnspecifiedSTDExceptionCompletion::m_shortDescription; }
	UnspecifiedSTDExceptionCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	UnspecifiedSTDExceptionCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnspecifiedSTDExceptionCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnspecifiedSTDExceptionCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnspecifiedSTDExceptionCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	UnspecifiedSTDExceptionCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

	void setWhat(ACE_CString value){ getErrorTraceHelper()->setMemberValue("What", value); }            				
	ACE_CString getWhat (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("What");  }


};

class UnspecifiedUnknownExceptionCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acserrHandlersErr; // = 6
	static const ACSErr::ErrorCode m_code = UnspecifiedUnknownException;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return UnspecifiedUnknownExceptionCompletion::m_shortDescription; }
	UnspecifiedUnknownExceptionCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	UnspecifiedUnknownExceptionCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnspecifiedUnknownExceptionCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnspecifiedUnknownExceptionCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnspecifiedUnknownExceptionCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	UnspecifiedUnknownExceptionCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class UncaughtACSBasedExceptionCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acserrHandlersErr; // = 6
	static const ACSErr::ErrorCode m_code = UncaughtACSBasedException;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return UncaughtACSBasedExceptionCompletion::m_shortDescription; }
	UncaughtACSBasedExceptionCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	UncaughtACSBasedExceptionCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UncaughtACSBasedExceptionCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UncaughtACSBasedExceptionCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UncaughtACSBasedExceptionCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	UncaughtACSBasedExceptionCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class UncaughtCORBAExceptionCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acserrHandlersErr; // = 6
	static const ACSErr::ErrorCode m_code = UncaughtCORBAException;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return UncaughtCORBAExceptionCompletion::m_shortDescription; }
	UncaughtCORBAExceptionCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	UncaughtCORBAExceptionCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UncaughtCORBAExceptionCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UncaughtCORBAExceptionCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UncaughtCORBAExceptionCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	UncaughtCORBAExceptionCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

	void setCORBAExName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CORBAExName", value); }            				
	ACE_CString getCORBAExName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CORBAExName");  }


};

class UncaughtSTDExceptionCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acserrHandlersErr; // = 6
	static const ACSErr::ErrorCode m_code = UncaughtSTDException;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return UncaughtSTDExceptionCompletion::m_shortDescription; }
	UncaughtSTDExceptionCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	UncaughtSTDExceptionCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UncaughtSTDExceptionCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UncaughtSTDExceptionCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UncaughtSTDExceptionCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	UncaughtSTDExceptionCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

	void setWhat(ACE_CString value){ getErrorTraceHelper()->setMemberValue("What", value); }            				
	ACE_CString getWhat (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("What");  }


};

class UncaughtUnknownExceptionCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acserrHandlersErr; // = 6
	static const ACSErr::ErrorCode m_code = UncaughtUnknownException;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return UncaughtUnknownExceptionCompletion::m_shortDescription; }
	UncaughtUnknownExceptionCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	UncaughtUnknownExceptionCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UncaughtUnknownExceptionCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UncaughtUnknownExceptionCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UncaughtUnknownExceptionCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	UncaughtUnknownExceptionCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class UncaughtUnspecifiedExceptionCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acserrHandlersErr; // = 6
	static const ACSErr::ErrorCode m_code = UncaughtUnspecifiedException;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return UncaughtUnspecifiedExceptionCompletion::m_shortDescription; }
	UncaughtUnspecifiedExceptionCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	UncaughtUnspecifiedExceptionCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UncaughtUnspecifiedExceptionCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UncaughtUnspecifiedExceptionCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UncaughtUnspecifiedExceptionCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	UncaughtUnspecifiedExceptionCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class acserrHandlersErrExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	acserrHandlersErrExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	acserrHandlersErrExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	acserrHandlersErrExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	acserrHandlersErrExImpl (acserrHandlersErr::acserrHandlersErrEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	acserrHandlersErr::acserrHandlersErrEx getacserrHandlersErrEx () { return acserrHandlersErr::acserrHandlersErrEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class UnspecifiedACSBasedExceptionExImpl: public acserrHandlersErrExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acserrHandlersErr;
	static const ACSErr::ErrorCode m_code = UnspecifiedACSBasedException;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	UnspecifiedACSBasedExceptionExImpl(const UnspecifiedACSBasedExceptionExImpl& ex) :
			acserrHandlersErrExImpl(const_cast<UnspecifiedACSBasedExceptionExImpl&>(ex).getErrorTrace()) {}
		
	UnspecifiedACSBasedExceptionExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	UnspecifiedACSBasedExceptionExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UnspecifiedACSBasedExceptionExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UnspecifiedACSBasedExceptionExImpl (const acserrHandlersErr::UnspecifiedACSBasedExceptionEx & ex) : 
			acserrHandlersErrExImpl(ex.errorTrace) {}
			
	acserrHandlersErr::UnspecifiedACSBasedExceptionEx getUnspecifiedACSBasedExceptionEx () { return acserrHandlersErr::UnspecifiedACSBasedExceptionEx (getErrorTrace()); }
	
	template <class T >
	UnspecifiedACSBasedExceptionExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class UnspecifiedCORBAExceptionExImpl: public acserrHandlersErrExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acserrHandlersErr;
	static const ACSErr::ErrorCode m_code = UnspecifiedCORBAException;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	UnspecifiedCORBAExceptionExImpl(const UnspecifiedCORBAExceptionExImpl& ex) :
			acserrHandlersErrExImpl(const_cast<UnspecifiedCORBAExceptionExImpl&>(ex).getErrorTrace()) {}
		
	UnspecifiedCORBAExceptionExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	UnspecifiedCORBAExceptionExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UnspecifiedCORBAExceptionExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UnspecifiedCORBAExceptionExImpl (const acserrHandlersErr::UnspecifiedCORBAExceptionEx & ex) : 
			acserrHandlersErrExImpl(ex.errorTrace) {}
			
	acserrHandlersErr::UnspecifiedCORBAExceptionEx getUnspecifiedCORBAExceptionEx () { return acserrHandlersErr::UnspecifiedCORBAExceptionEx (getErrorTrace()); }
	
	template <class T >
	UnspecifiedCORBAExceptionExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


	void setCORBAExName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CORBAExName", value); }            				
	ACE_CString getCORBAExName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CORBAExName");  }


};

class UnspecifiedSTDExceptionExImpl: public acserrHandlersErrExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acserrHandlersErr;
	static const ACSErr::ErrorCode m_code = UnspecifiedSTDException;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	UnspecifiedSTDExceptionExImpl(const UnspecifiedSTDExceptionExImpl& ex) :
			acserrHandlersErrExImpl(const_cast<UnspecifiedSTDExceptionExImpl&>(ex).getErrorTrace()) {}
		
	UnspecifiedSTDExceptionExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	UnspecifiedSTDExceptionExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UnspecifiedSTDExceptionExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UnspecifiedSTDExceptionExImpl (const acserrHandlersErr::UnspecifiedSTDExceptionEx & ex) : 
			acserrHandlersErrExImpl(ex.errorTrace) {}
			
	acserrHandlersErr::UnspecifiedSTDExceptionEx getUnspecifiedSTDExceptionEx () { return acserrHandlersErr::UnspecifiedSTDExceptionEx (getErrorTrace()); }
	
	template <class T >
	UnspecifiedSTDExceptionExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


	void setWhat(ACE_CString value){ getErrorTraceHelper()->setMemberValue("What", value); }            				
	ACE_CString getWhat (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("What");  }


};

class UnspecifiedUnknownExceptionExImpl: public acserrHandlersErrExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acserrHandlersErr;
	static const ACSErr::ErrorCode m_code = UnspecifiedUnknownException;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	UnspecifiedUnknownExceptionExImpl(const UnspecifiedUnknownExceptionExImpl& ex) :
			acserrHandlersErrExImpl(const_cast<UnspecifiedUnknownExceptionExImpl&>(ex).getErrorTrace()) {}
		
	UnspecifiedUnknownExceptionExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	UnspecifiedUnknownExceptionExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UnspecifiedUnknownExceptionExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UnspecifiedUnknownExceptionExImpl (const acserrHandlersErr::UnspecifiedUnknownExceptionEx & ex) : 
			acserrHandlersErrExImpl(ex.errorTrace) {}
			
	acserrHandlersErr::UnspecifiedUnknownExceptionEx getUnspecifiedUnknownExceptionEx () { return acserrHandlersErr::UnspecifiedUnknownExceptionEx (getErrorTrace()); }
	
	template <class T >
	UnspecifiedUnknownExceptionExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class UncaughtACSBasedExceptionExImpl: public acserrHandlersErrExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acserrHandlersErr;
	static const ACSErr::ErrorCode m_code = UncaughtACSBasedException;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	UncaughtACSBasedExceptionExImpl(const UncaughtACSBasedExceptionExImpl& ex) :
			acserrHandlersErrExImpl(const_cast<UncaughtACSBasedExceptionExImpl&>(ex).getErrorTrace()) {}
		
	UncaughtACSBasedExceptionExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	UncaughtACSBasedExceptionExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UncaughtACSBasedExceptionExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UncaughtACSBasedExceptionExImpl (const acserrHandlersErr::UncaughtACSBasedExceptionEx & ex) : 
			acserrHandlersErrExImpl(ex.errorTrace) {}
			
	acserrHandlersErr::UncaughtACSBasedExceptionEx getUncaughtACSBasedExceptionEx () { return acserrHandlersErr::UncaughtACSBasedExceptionEx (getErrorTrace()); }
	
	template <class T >
	UncaughtACSBasedExceptionExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class UncaughtCORBAExceptionExImpl: public acserrHandlersErrExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acserrHandlersErr;
	static const ACSErr::ErrorCode m_code = UncaughtCORBAException;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	UncaughtCORBAExceptionExImpl(const UncaughtCORBAExceptionExImpl& ex) :
			acserrHandlersErrExImpl(const_cast<UncaughtCORBAExceptionExImpl&>(ex).getErrorTrace()) {}
		
	UncaughtCORBAExceptionExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	UncaughtCORBAExceptionExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UncaughtCORBAExceptionExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UncaughtCORBAExceptionExImpl (const acserrHandlersErr::UncaughtCORBAExceptionEx & ex) : 
			acserrHandlersErrExImpl(ex.errorTrace) {}
			
	acserrHandlersErr::UncaughtCORBAExceptionEx getUncaughtCORBAExceptionEx () { return acserrHandlersErr::UncaughtCORBAExceptionEx (getErrorTrace()); }
	
	template <class T >
	UncaughtCORBAExceptionExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


	void setCORBAExName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CORBAExName", value); }            				
	ACE_CString getCORBAExName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CORBAExName");  }


};

class UncaughtSTDExceptionExImpl: public acserrHandlersErrExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acserrHandlersErr;
	static const ACSErr::ErrorCode m_code = UncaughtSTDException;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	UncaughtSTDExceptionExImpl(const UncaughtSTDExceptionExImpl& ex) :
			acserrHandlersErrExImpl(const_cast<UncaughtSTDExceptionExImpl&>(ex).getErrorTrace()) {}
		
	UncaughtSTDExceptionExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	UncaughtSTDExceptionExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UncaughtSTDExceptionExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UncaughtSTDExceptionExImpl (const acserrHandlersErr::UncaughtSTDExceptionEx & ex) : 
			acserrHandlersErrExImpl(ex.errorTrace) {}
			
	acserrHandlersErr::UncaughtSTDExceptionEx getUncaughtSTDExceptionEx () { return acserrHandlersErr::UncaughtSTDExceptionEx (getErrorTrace()); }
	
	template <class T >
	UncaughtSTDExceptionExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


	void setWhat(ACE_CString value){ getErrorTraceHelper()->setMemberValue("What", value); }            				
	ACE_CString getWhat (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("What");  }


};

class UncaughtUnknownExceptionExImpl: public acserrHandlersErrExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acserrHandlersErr;
	static const ACSErr::ErrorCode m_code = UncaughtUnknownException;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	UncaughtUnknownExceptionExImpl(const UncaughtUnknownExceptionExImpl& ex) :
			acserrHandlersErrExImpl(const_cast<UncaughtUnknownExceptionExImpl&>(ex).getErrorTrace()) {}
		
	UncaughtUnknownExceptionExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	UncaughtUnknownExceptionExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UncaughtUnknownExceptionExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UncaughtUnknownExceptionExImpl (const acserrHandlersErr::UncaughtUnknownExceptionEx & ex) : 
			acserrHandlersErrExImpl(ex.errorTrace) {}
			
	acserrHandlersErr::UncaughtUnknownExceptionEx getUncaughtUnknownExceptionEx () { return acserrHandlersErr::UncaughtUnknownExceptionEx (getErrorTrace()); }
	
	template <class T >
	UncaughtUnknownExceptionExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class UncaughtUnspecifiedExceptionExImpl: public acserrHandlersErrExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acserrHandlersErr;
	static const ACSErr::ErrorCode m_code = UncaughtUnspecifiedException;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	UncaughtUnspecifiedExceptionExImpl(const UncaughtUnspecifiedExceptionExImpl& ex) :
			acserrHandlersErrExImpl(const_cast<UncaughtUnspecifiedExceptionExImpl&>(ex).getErrorTrace()) {}
		
	UncaughtUnspecifiedExceptionExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	UncaughtUnspecifiedExceptionExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UncaughtUnspecifiedExceptionExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UncaughtUnspecifiedExceptionExImpl (const acserrHandlersErr::UncaughtUnspecifiedExceptionEx & ex) : 
			acserrHandlersErrExImpl(ex.errorTrace) {}
			
	acserrHandlersErr::UncaughtUnspecifiedExceptionEx getUncaughtUnspecifiedExceptionEx () { return acserrHandlersErr::UncaughtUnspecifiedExceptionEx (getErrorTrace()); }
	
	template <class T >
	UncaughtUnspecifiedExceptionExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acserrHandlersErrExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

}

#endif
