#ifndef _acsErrTypeLifeCycle_H_
#define _acsErrTypeLifeCycle_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "acsErrTypeLifeCycleC.h"

#include "acserrExceptionManager.h"

namespace acsErrTypeLifeCycle
{

class LifeCycleCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsErrTypeLifeCycle; // = 28
	static const ACSErr::ErrorCode m_code = LifeCycle;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return LifeCycleCompletion::m_shortDescription; }
	LifeCycleCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	LifeCycleCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	LifeCycleCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	LifeCycleCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	LifeCycleCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	LifeCycleCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class StartingThreadsFailureCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsErrTypeLifeCycle; // = 28
	static const ACSErr::ErrorCode m_code = StartingThreadsFailure;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return StartingThreadsFailureCompletion::m_shortDescription; }
	StartingThreadsFailureCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	StartingThreadsFailureCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	StartingThreadsFailureCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	StartingThreadsFailureCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	StartingThreadsFailureCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	StartingThreadsFailureCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class StoppingThreadsFailureCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsErrTypeLifeCycle; // = 28
	static const ACSErr::ErrorCode m_code = StoppingThreadsFailure;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return StoppingThreadsFailureCompletion::m_shortDescription; }
	StoppingThreadsFailureCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	StoppingThreadsFailureCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	StoppingThreadsFailureCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	StoppingThreadsFailureCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	StoppingThreadsFailureCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	StoppingThreadsFailureCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class WrongInitialStateCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsErrTypeLifeCycle; // = 28
	static const ACSErr::ErrorCode m_code = WrongInitialState;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return WrongInitialStateCompletion::m_shortDescription; }
	WrongInitialStateCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	WrongInitialStateCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	WrongInitialStateCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	WrongInitialStateCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	WrongInitialStateCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	WrongInitialStateCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setComponentName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ComponentName", value); }            				
	ACE_CString getComponentName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ComponentName");  }
	
	
};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class acsErrTypeLifeCycleExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	acsErrTypeLifeCycleExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	acsErrTypeLifeCycleExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	acsErrTypeLifeCycleExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	acsErrTypeLifeCycleExImpl (acsErrTypeLifeCycle::acsErrTypeLifeCycleEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	acsErrTypeLifeCycle::acsErrTypeLifeCycleEx getacsErrTypeLifeCycleEx () { return acsErrTypeLifeCycle::acsErrTypeLifeCycleEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class LifeCycleExImpl: public acsErrTypeLifeCycleExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsErrTypeLifeCycle;
	static const ACSErr::ErrorCode m_code = LifeCycle;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	LifeCycleExImpl(const LifeCycleExImpl& ex) :
			acsErrTypeLifeCycleExImpl(const_cast<LifeCycleExImpl&>(ex).getErrorTrace()) {}
		
	LifeCycleExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsErrTypeLifeCycleExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	LifeCycleExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsErrTypeLifeCycleExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	LifeCycleExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsErrTypeLifeCycleExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	LifeCycleExImpl (const acsErrTypeLifeCycle::LifeCycleEx & ex) : 
			acsErrTypeLifeCycleExImpl(ex.errorTrace) {}
			
	acsErrTypeLifeCycle::LifeCycleEx getLifeCycleEx () { return acsErrTypeLifeCycle::LifeCycleEx (getErrorTrace()); }
	
	template <class T >
	LifeCycleExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsErrTypeLifeCycleExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class StartingThreadsFailureExImpl: public acsErrTypeLifeCycleExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsErrTypeLifeCycle;
	static const ACSErr::ErrorCode m_code = StartingThreadsFailure;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	StartingThreadsFailureExImpl(const StartingThreadsFailureExImpl& ex) :
			acsErrTypeLifeCycleExImpl(const_cast<StartingThreadsFailureExImpl&>(ex).getErrorTrace()) {}
		
	StartingThreadsFailureExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsErrTypeLifeCycleExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	StartingThreadsFailureExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsErrTypeLifeCycleExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	StartingThreadsFailureExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsErrTypeLifeCycleExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	StartingThreadsFailureExImpl (const acsErrTypeLifeCycle::StartingThreadsFailureEx & ex) : 
			acsErrTypeLifeCycleExImpl(ex.errorTrace) {}
			
	acsErrTypeLifeCycle::StartingThreadsFailureEx getStartingThreadsFailureEx () { return acsErrTypeLifeCycle::StartingThreadsFailureEx (getErrorTrace()); }
	
	template <class T >
	StartingThreadsFailureExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsErrTypeLifeCycleExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class StoppingThreadsFailureExImpl: public acsErrTypeLifeCycleExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsErrTypeLifeCycle;
	static const ACSErr::ErrorCode m_code = StoppingThreadsFailure;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	StoppingThreadsFailureExImpl(const StoppingThreadsFailureExImpl& ex) :
			acsErrTypeLifeCycleExImpl(const_cast<StoppingThreadsFailureExImpl&>(ex).getErrorTrace()) {}
		
	StoppingThreadsFailureExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsErrTypeLifeCycleExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	StoppingThreadsFailureExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsErrTypeLifeCycleExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	StoppingThreadsFailureExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsErrTypeLifeCycleExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	StoppingThreadsFailureExImpl (const acsErrTypeLifeCycle::StoppingThreadsFailureEx & ex) : 
			acsErrTypeLifeCycleExImpl(ex.errorTrace) {}
			
	acsErrTypeLifeCycle::StoppingThreadsFailureEx getStoppingThreadsFailureEx () { return acsErrTypeLifeCycle::StoppingThreadsFailureEx (getErrorTrace()); }
	
	template <class T >
	StoppingThreadsFailureExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsErrTypeLifeCycleExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class WrongInitialStateExImpl: public acsErrTypeLifeCycleExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsErrTypeLifeCycle;
	static const ACSErr::ErrorCode m_code = WrongInitialState;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	WrongInitialStateExImpl(const WrongInitialStateExImpl& ex) :
			acsErrTypeLifeCycleExImpl(const_cast<WrongInitialStateExImpl&>(ex).getErrorTrace()) {}
		
	WrongInitialStateExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsErrTypeLifeCycleExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	WrongInitialStateExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsErrTypeLifeCycleExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	WrongInitialStateExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsErrTypeLifeCycleExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	WrongInitialStateExImpl (const acsErrTypeLifeCycle::WrongInitialStateEx & ex) : 
			acsErrTypeLifeCycleExImpl(ex.errorTrace) {}
			
	acsErrTypeLifeCycle::WrongInitialStateEx getWrongInitialStateEx () { return acsErrTypeLifeCycle::WrongInitialStateEx (getErrorTrace()); }
	
	template <class T >
	WrongInitialStateExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsErrTypeLifeCycleExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setComponentName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ComponentName", value); }            				
	ACE_CString getComponentName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ComponentName");  }
	
	
};

}

#endif
