#ifndef _UserRepositoryError_H_
#define _UserRepositoryError_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "UserRepositoryErrorC.h"

#include "acserrExceptionManager.h"

namespace UserRepositoryError
{

class CommunicationErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::UserRepositoryError; // = 61000
	static const ACSErr::ErrorCode m_code = CommunicationError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CommunicationErrorCompletion::m_shortDescription; }
	CommunicationErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CommunicationErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CommunicationErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CommunicationErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CommunicationErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CommunicationErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class DuplicateObjectErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::UserRepositoryError; // = 61000
	static const ACSErr::ErrorCode m_code = DuplicateObjectError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return DuplicateObjectErrorCompletion::m_shortDescription; }
	DuplicateObjectErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	DuplicateObjectErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	DuplicateObjectErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	DuplicateObjectErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	DuplicateObjectErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	DuplicateObjectErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class InvalidAttributeErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::UserRepositoryError; // = 61000
	static const ACSErr::ErrorCode m_code = InvalidAttributeError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return InvalidAttributeErrorCompletion::m_shortDescription; }
	InvalidAttributeErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	InvalidAttributeErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	InvalidAttributeErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	InvalidAttributeErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	InvalidAttributeErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	InvalidAttributeErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class InvalidOperationErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::UserRepositoryError; // = 61000
	static const ACSErr::ErrorCode m_code = InvalidOperationError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return InvalidOperationErrorCompletion::m_shortDescription; }
	InvalidOperationErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	InvalidOperationErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	InvalidOperationErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	InvalidOperationErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	InvalidOperationErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	InvalidOperationErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class ObjectNotFoundErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::UserRepositoryError; // = 61000
	static const ACSErr::ErrorCode m_code = ObjectNotFoundError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return ObjectNotFoundErrorCompletion::m_shortDescription; }
	ObjectNotFoundErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	ObjectNotFoundErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ObjectNotFoundErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ObjectNotFoundErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ObjectNotFoundErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	ObjectNotFoundErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class PermissionErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::UserRepositoryError; // = 61000
	static const ACSErr::ErrorCode m_code = PermissionError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return PermissionErrorCompletion::m_shortDescription; }
	PermissionErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	PermissionErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	PermissionErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	PermissionErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	PermissionErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	PermissionErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class InvalidSearchFilterErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::UserRepositoryError; // = 61000
	static const ACSErr::ErrorCode m_code = InvalidSearchFilterError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return InvalidSearchFilterErrorCompletion::m_shortDescription; }
	InvalidSearchFilterErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	InvalidSearchFilterErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	InvalidSearchFilterErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	InvalidSearchFilterErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	InvalidSearchFilterErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	InvalidSearchFilterErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class DataExpiredErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::UserRepositoryError; // = 61000
	static const ACSErr::ErrorCode m_code = DataExpiredError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return DataExpiredErrorCompletion::m_shortDescription; }
	DataExpiredErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	DataExpiredErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	DataExpiredErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	DataExpiredErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	DataExpiredErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	DataExpiredErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class UnknownCauseCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::UserRepositoryError; // = 61000
	static const ACSErr::ErrorCode m_code = UnknownCause;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return UnknownCauseCompletion::m_shortDescription; }
	UnknownCauseCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	UnknownCauseCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnknownCauseCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnknownCauseCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnknownCauseCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	UnknownCauseCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class UserRepositoryErrorExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	UserRepositoryErrorExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	UserRepositoryErrorExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	UserRepositoryErrorExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	UserRepositoryErrorExImpl (UserRepositoryError::UserRepositoryErrorEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	UserRepositoryError::UserRepositoryErrorEx getUserRepositoryErrorEx () { return UserRepositoryError::UserRepositoryErrorEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class CommunicationErrorExImpl: public UserRepositoryErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::UserRepositoryError;
	static const ACSErr::ErrorCode m_code = CommunicationError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CommunicationErrorExImpl(const CommunicationErrorExImpl& ex) :
			UserRepositoryErrorExImpl(const_cast<CommunicationErrorExImpl&>(ex).getErrorTrace()) {}
		
	CommunicationErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CommunicationErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CommunicationErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CommunicationErrorExImpl (const UserRepositoryError::CommunicationErrorEx & ex) : 
			UserRepositoryErrorExImpl(ex.errorTrace) {}
			
	UserRepositoryError::CommunicationErrorEx getCommunicationErrorEx () { return UserRepositoryError::CommunicationErrorEx (getErrorTrace()); }
	
	template <class T >
	CommunicationErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class DuplicateObjectErrorExImpl: public UserRepositoryErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::UserRepositoryError;
	static const ACSErr::ErrorCode m_code = DuplicateObjectError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	DuplicateObjectErrorExImpl(const DuplicateObjectErrorExImpl& ex) :
			UserRepositoryErrorExImpl(const_cast<DuplicateObjectErrorExImpl&>(ex).getErrorTrace()) {}
		
	DuplicateObjectErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	DuplicateObjectErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	DuplicateObjectErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	DuplicateObjectErrorExImpl (const UserRepositoryError::DuplicateObjectErrorEx & ex) : 
			UserRepositoryErrorExImpl(ex.errorTrace) {}
			
	UserRepositoryError::DuplicateObjectErrorEx getDuplicateObjectErrorEx () { return UserRepositoryError::DuplicateObjectErrorEx (getErrorTrace()); }
	
	template <class T >
	DuplicateObjectErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class InvalidAttributeErrorExImpl: public UserRepositoryErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::UserRepositoryError;
	static const ACSErr::ErrorCode m_code = InvalidAttributeError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	InvalidAttributeErrorExImpl(const InvalidAttributeErrorExImpl& ex) :
			UserRepositoryErrorExImpl(const_cast<InvalidAttributeErrorExImpl&>(ex).getErrorTrace()) {}
		
	InvalidAttributeErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	InvalidAttributeErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	InvalidAttributeErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	InvalidAttributeErrorExImpl (const UserRepositoryError::InvalidAttributeErrorEx & ex) : 
			UserRepositoryErrorExImpl(ex.errorTrace) {}
			
	UserRepositoryError::InvalidAttributeErrorEx getInvalidAttributeErrorEx () { return UserRepositoryError::InvalidAttributeErrorEx (getErrorTrace()); }
	
	template <class T >
	InvalidAttributeErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class InvalidOperationErrorExImpl: public UserRepositoryErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::UserRepositoryError;
	static const ACSErr::ErrorCode m_code = InvalidOperationError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	InvalidOperationErrorExImpl(const InvalidOperationErrorExImpl& ex) :
			UserRepositoryErrorExImpl(const_cast<InvalidOperationErrorExImpl&>(ex).getErrorTrace()) {}
		
	InvalidOperationErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	InvalidOperationErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	InvalidOperationErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	InvalidOperationErrorExImpl (const UserRepositoryError::InvalidOperationErrorEx & ex) : 
			UserRepositoryErrorExImpl(ex.errorTrace) {}
			
	UserRepositoryError::InvalidOperationErrorEx getInvalidOperationErrorEx () { return UserRepositoryError::InvalidOperationErrorEx (getErrorTrace()); }
	
	template <class T >
	InvalidOperationErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class ObjectNotFoundErrorExImpl: public UserRepositoryErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::UserRepositoryError;
	static const ACSErr::ErrorCode m_code = ObjectNotFoundError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	ObjectNotFoundErrorExImpl(const ObjectNotFoundErrorExImpl& ex) :
			UserRepositoryErrorExImpl(const_cast<ObjectNotFoundErrorExImpl&>(ex).getErrorTrace()) {}
		
	ObjectNotFoundErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	ObjectNotFoundErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ObjectNotFoundErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ObjectNotFoundErrorExImpl (const UserRepositoryError::ObjectNotFoundErrorEx & ex) : 
			UserRepositoryErrorExImpl(ex.errorTrace) {}
			
	UserRepositoryError::ObjectNotFoundErrorEx getObjectNotFoundErrorEx () { return UserRepositoryError::ObjectNotFoundErrorEx (getErrorTrace()); }
	
	template <class T >
	ObjectNotFoundErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class PermissionErrorExImpl: public UserRepositoryErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::UserRepositoryError;
	static const ACSErr::ErrorCode m_code = PermissionError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	PermissionErrorExImpl(const PermissionErrorExImpl& ex) :
			UserRepositoryErrorExImpl(const_cast<PermissionErrorExImpl&>(ex).getErrorTrace()) {}
		
	PermissionErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	PermissionErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	PermissionErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	PermissionErrorExImpl (const UserRepositoryError::PermissionErrorEx & ex) : 
			UserRepositoryErrorExImpl(ex.errorTrace) {}
			
	UserRepositoryError::PermissionErrorEx getPermissionErrorEx () { return UserRepositoryError::PermissionErrorEx (getErrorTrace()); }
	
	template <class T >
	PermissionErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class InvalidSearchFilterErrorExImpl: public UserRepositoryErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::UserRepositoryError;
	static const ACSErr::ErrorCode m_code = InvalidSearchFilterError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	InvalidSearchFilterErrorExImpl(const InvalidSearchFilterErrorExImpl& ex) :
			UserRepositoryErrorExImpl(const_cast<InvalidSearchFilterErrorExImpl&>(ex).getErrorTrace()) {}
		
	InvalidSearchFilterErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	InvalidSearchFilterErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	InvalidSearchFilterErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	InvalidSearchFilterErrorExImpl (const UserRepositoryError::InvalidSearchFilterErrorEx & ex) : 
			UserRepositoryErrorExImpl(ex.errorTrace) {}
			
	UserRepositoryError::InvalidSearchFilterErrorEx getInvalidSearchFilterErrorEx () { return UserRepositoryError::InvalidSearchFilterErrorEx (getErrorTrace()); }
	
	template <class T >
	InvalidSearchFilterErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class DataExpiredErrorExImpl: public UserRepositoryErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::UserRepositoryError;
	static const ACSErr::ErrorCode m_code = DataExpiredError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	DataExpiredErrorExImpl(const DataExpiredErrorExImpl& ex) :
			UserRepositoryErrorExImpl(const_cast<DataExpiredErrorExImpl&>(ex).getErrorTrace()) {}
		
	DataExpiredErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	DataExpiredErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	DataExpiredErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	DataExpiredErrorExImpl (const UserRepositoryError::DataExpiredErrorEx & ex) : 
			UserRepositoryErrorExImpl(ex.errorTrace) {}
			
	UserRepositoryError::DataExpiredErrorEx getDataExpiredErrorEx () { return UserRepositoryError::DataExpiredErrorEx (getErrorTrace()); }
	
	template <class T >
	DataExpiredErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class UnknownCauseExImpl: public UserRepositoryErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::UserRepositoryError;
	static const ACSErr::ErrorCode m_code = UnknownCause;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	UnknownCauseExImpl(const UnknownCauseExImpl& ex) :
			UserRepositoryErrorExImpl(const_cast<UnknownCauseExImpl&>(ex).getErrorTrace()) {}
		
	UnknownCauseExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	UnknownCauseExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UnknownCauseExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UnknownCauseExImpl (const UserRepositoryError::UnknownCauseEx & ex) : 
			UserRepositoryErrorExImpl(ex.errorTrace) {}
			
	UserRepositoryError::UnknownCauseEx getUnknownCauseEx () { return UserRepositoryError::UnknownCauseEx (getErrorTrace()); }
	
	template <class T >
	UnknownCauseExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			UserRepositoryErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

}

#endif
