#ifndef UIDLibrary_H
#define UIDLibrary_H
/*
 * 	  Created on 08-02-2006
 * 
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 */

#include <string.h>
#include <map>
#include <acscomponentImpl.h> 
#include <archive_xmlstore_ifC.h>
//#include <maciContainerImpl.h>
#include "Range.h"
#include "ArchiveIdentifierError.h"

// using std::string;
typedef std::map<std::string, Range> RangeMap;

class UIDLibrary
{
  private:
    xmlstore::Identifier* idConn;
    Range *defaultRange;
	
    RangeMap idRanges;
    RangeMap refRanges;

//    static UIDLibrary * _instance;

  public:	
    /* constructor */
    UIDLibrary(xmlstore::Identifier *ident ) ;

//    static UIDLibrary * instance(xmlstore::Identifier *ident ) ;

    /* destructor */
    virtual ~UIDLibrary() ;

    /**
     * Assigns a uid to the EntityT from the default range.
     * @param entity
     * @throws ArchiveIdentifierError::NoDefaultRange
    */
    void assignUniqueEntityId(xmlentity::EntityT& entity) 
	throw (xmlstore::Identifier::NotAvailable, 
               ArchiveIdentifierError::RangeLockedExImpl, 
               ArchiveIdentifierError::RangeExhaustedExImpl);

    /**
     * Fetch a new restricted range, this will return a URI allowing access to
     * the new Range. The range is automatically stored in the archive. 
     * @return
     */
    xmlstore::URI getNewRestrictedRange(int size, char* user)
	throw (xmlstore::Identifier::NotAvailable, ArchiveIdentifierError::UidAlreadyExistsExImpl);
	
    /**
     * Assign a uid to the EntityT from the specified range, not permitted with
     * deserialised Ranges
     * @param entity
     * @param uri
     * @throws ArchiveIdentifierError::RangeUnavailable
     */
    void assignUniqueEntityId(xmlentity::EntityT& entity, xmlstore::URI uri) 
	throw (ArchiveIdentifierError::RangeUnavailableExImpl,
               ArchiveIdentifierError::RangeLockedExImpl, 
               ArchiveIdentifierError::RangeExhaustedExImpl);
	
    /**
     * Fetch an existing range from the archive and deserialise, only certain
     * operations will be permitted.
     * @param uri
     * @throws ArchiveIdentifierError::RangeUnavailable
     */
    void fetchRange(xmlstore::URI uri, char* user) 
	throw (xmlstore::Identifier::NotFound, ArchiveIdentifierError::RangeUnavailableExImpl);
	
    /**
     * Assign a reference id, this operation is only permitted with deserialised
     * ranges.
     * @param ref
     * @param uri
     * @throws UIDLibraryException
     */
    void assignUniqueEntityRef(xmlentity::EntityRefT& ref, xmlstore::URI uri) 
	throw (ArchiveIdentifierError::RangeUnavailableExImpl,
               ArchiveIdentifierError::RangeUnlockedExImpl,
               ArchiveIdentifierError::RangeExhaustedExImpl);

} ;
#endif
