#ifndef _TmcdbErrType_H_
#define _TmcdbErrType_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "TmcdbErrTypeC.h"

#include "acserrExceptionManager.h"

namespace TmcdbErrType
{

class TmcdbErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbErrType; // = 100000
	static const ACSErr::ErrorCode m_code = TmcdbError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return TmcdbErrorCompletion::m_shortDescription; }
	TmcdbErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	TmcdbErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	TmcdbErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class TmcdbNoSuchRowCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbErrType; // = 100000
	static const ACSErr::ErrorCode m_code = TmcdbNoSuchRow;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return TmcdbNoSuchRowCompletion::m_shortDescription; }
	TmcdbNoSuchRowCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	TmcdbNoSuchRowCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbNoSuchRowCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbNoSuchRowCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbNoSuchRowCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	TmcdbNoSuchRowCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class TmcdbRowAlreadyExistsCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbErrType; // = 100000
	static const ACSErr::ErrorCode m_code = TmcdbRowAlreadyExists;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return TmcdbRowAlreadyExistsCompletion::m_shortDescription; }
	TmcdbRowAlreadyExistsCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	TmcdbRowAlreadyExistsCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbRowAlreadyExistsCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbRowAlreadyExistsCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbRowAlreadyExistsCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	TmcdbRowAlreadyExistsCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class TmcdbConnectionFailureCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbErrType; // = 100000
	static const ACSErr::ErrorCode m_code = TmcdbConnectionFailure;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return TmcdbConnectionFailureCompletion::m_shortDescription; }
	TmcdbConnectionFailureCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	TmcdbConnectionFailureCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbConnectionFailureCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbConnectionFailureCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbConnectionFailureCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	TmcdbConnectionFailureCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class TmcdbInitializationFailureCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbErrType; // = 100000
	static const ACSErr::ErrorCode m_code = TmcdbInitializationFailure;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return TmcdbInitializationFailureCompletion::m_shortDescription; }
	TmcdbInitializationFailureCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	TmcdbInitializationFailureCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbInitializationFailureCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbInitializationFailureCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbInitializationFailureCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	TmcdbInitializationFailureCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class TmcdbDuplicateKeyCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbErrType; // = 100000
	static const ACSErr::ErrorCode m_code = TmcdbDuplicateKey;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return TmcdbDuplicateKeyCompletion::m_shortDescription; }
	TmcdbDuplicateKeyCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	TmcdbDuplicateKeyCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbDuplicateKeyCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbDuplicateKeyCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbDuplicateKeyCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	TmcdbDuplicateKeyCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class TmcdbSqlCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbErrType; // = 100000
	static const ACSErr::ErrorCode m_code = TmcdbSql;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return TmcdbSqlCompletion::m_shortDescription; }
	TmcdbSqlCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	TmcdbSqlCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbSqlCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbSqlCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbSqlCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	TmcdbSqlCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class TmcdbKeyUpdateCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbErrType; // = 100000
	static const ACSErr::ErrorCode m_code = TmcdbKeyUpdate;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return TmcdbKeyUpdateCompletion::m_shortDescription; }
	TmcdbKeyUpdateCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	TmcdbKeyUpdateCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbKeyUpdateCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbKeyUpdateCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbKeyUpdateCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	TmcdbKeyUpdateCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class TmcdbDuplicateRowCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbErrType; // = 100000
	static const ACSErr::ErrorCode m_code = TmcdbDuplicateRow;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return TmcdbDuplicateRowCompletion::m_shortDescription; }
	TmcdbDuplicateRowCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	TmcdbDuplicateRowCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbDuplicateRowCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbDuplicateRowCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbDuplicateRowCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	TmcdbDuplicateRowCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class TmcdbInvalidDataTypeCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbErrType; // = 100000
	static const ACSErr::ErrorCode m_code = TmcdbInvalidDataType;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return TmcdbInvalidDataTypeCompletion::m_shortDescription; }
	TmcdbInvalidDataTypeCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	TmcdbInvalidDataTypeCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbInvalidDataTypeCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbInvalidDataTypeCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	TmcdbInvalidDataTypeCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	TmcdbInvalidDataTypeCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class TmcdbErrTypeExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	TmcdbErrTypeExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	TmcdbErrTypeExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	TmcdbErrTypeExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	TmcdbErrTypeExImpl (TmcdbErrType::TmcdbErrTypeEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	TmcdbErrType::TmcdbErrTypeEx getTmcdbErrTypeEx () { return TmcdbErrType::TmcdbErrTypeEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class TmcdbErrorExImpl: public TmcdbErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbErrType;
	static const ACSErr::ErrorCode m_code = TmcdbError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	TmcdbErrorExImpl(const TmcdbErrorExImpl& ex) :
			TmcdbErrTypeExImpl(const_cast<TmcdbErrorExImpl&>(ex).getErrorTrace()) {}
		
	TmcdbErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	TmcdbErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbErrorExImpl (const TmcdbErrType::TmcdbErrorEx & ex) : 
			TmcdbErrTypeExImpl(ex.errorTrace) {}
			
	TmcdbErrType::TmcdbErrorEx getTmcdbErrorEx () { return TmcdbErrType::TmcdbErrorEx (getErrorTrace()); }
	
	template <class T >
	TmcdbErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class TmcdbNoSuchRowExImpl: public TmcdbErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbErrType;
	static const ACSErr::ErrorCode m_code = TmcdbNoSuchRow;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	TmcdbNoSuchRowExImpl(const TmcdbNoSuchRowExImpl& ex) :
			TmcdbErrTypeExImpl(const_cast<TmcdbNoSuchRowExImpl&>(ex).getErrorTrace()) {}
		
	TmcdbNoSuchRowExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	TmcdbNoSuchRowExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbNoSuchRowExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbNoSuchRowExImpl (const TmcdbErrType::TmcdbNoSuchRowEx & ex) : 
			TmcdbErrTypeExImpl(ex.errorTrace) {}
			
	TmcdbErrType::TmcdbNoSuchRowEx getTmcdbNoSuchRowEx () { return TmcdbErrType::TmcdbNoSuchRowEx (getErrorTrace()); }
	
	template <class T >
	TmcdbNoSuchRowExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class TmcdbRowAlreadyExistsExImpl: public TmcdbErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbErrType;
	static const ACSErr::ErrorCode m_code = TmcdbRowAlreadyExists;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	TmcdbRowAlreadyExistsExImpl(const TmcdbRowAlreadyExistsExImpl& ex) :
			TmcdbErrTypeExImpl(const_cast<TmcdbRowAlreadyExistsExImpl&>(ex).getErrorTrace()) {}
		
	TmcdbRowAlreadyExistsExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	TmcdbRowAlreadyExistsExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbRowAlreadyExistsExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbRowAlreadyExistsExImpl (const TmcdbErrType::TmcdbRowAlreadyExistsEx & ex) : 
			TmcdbErrTypeExImpl(ex.errorTrace) {}
			
	TmcdbErrType::TmcdbRowAlreadyExistsEx getTmcdbRowAlreadyExistsEx () { return TmcdbErrType::TmcdbRowAlreadyExistsEx (getErrorTrace()); }
	
	template <class T >
	TmcdbRowAlreadyExistsExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class TmcdbConnectionFailureExImpl: public TmcdbErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbErrType;
	static const ACSErr::ErrorCode m_code = TmcdbConnectionFailure;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	TmcdbConnectionFailureExImpl(const TmcdbConnectionFailureExImpl& ex) :
			TmcdbErrTypeExImpl(const_cast<TmcdbConnectionFailureExImpl&>(ex).getErrorTrace()) {}
		
	TmcdbConnectionFailureExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	TmcdbConnectionFailureExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbConnectionFailureExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbConnectionFailureExImpl (const TmcdbErrType::TmcdbConnectionFailureEx & ex) : 
			TmcdbErrTypeExImpl(ex.errorTrace) {}
			
	TmcdbErrType::TmcdbConnectionFailureEx getTmcdbConnectionFailureEx () { return TmcdbErrType::TmcdbConnectionFailureEx (getErrorTrace()); }
	
	template <class T >
	TmcdbConnectionFailureExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class TmcdbInitializationFailureExImpl: public TmcdbErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbErrType;
	static const ACSErr::ErrorCode m_code = TmcdbInitializationFailure;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	TmcdbInitializationFailureExImpl(const TmcdbInitializationFailureExImpl& ex) :
			TmcdbErrTypeExImpl(const_cast<TmcdbInitializationFailureExImpl&>(ex).getErrorTrace()) {}
		
	TmcdbInitializationFailureExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	TmcdbInitializationFailureExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbInitializationFailureExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbInitializationFailureExImpl (const TmcdbErrType::TmcdbInitializationFailureEx & ex) : 
			TmcdbErrTypeExImpl(ex.errorTrace) {}
			
	TmcdbErrType::TmcdbInitializationFailureEx getTmcdbInitializationFailureEx () { return TmcdbErrType::TmcdbInitializationFailureEx (getErrorTrace()); }
	
	template <class T >
	TmcdbInitializationFailureExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class TmcdbDuplicateKeyExImpl: public TmcdbErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbErrType;
	static const ACSErr::ErrorCode m_code = TmcdbDuplicateKey;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	TmcdbDuplicateKeyExImpl(const TmcdbDuplicateKeyExImpl& ex) :
			TmcdbErrTypeExImpl(const_cast<TmcdbDuplicateKeyExImpl&>(ex).getErrorTrace()) {}
		
	TmcdbDuplicateKeyExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	TmcdbDuplicateKeyExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbDuplicateKeyExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbDuplicateKeyExImpl (const TmcdbErrType::TmcdbDuplicateKeyEx & ex) : 
			TmcdbErrTypeExImpl(ex.errorTrace) {}
			
	TmcdbErrType::TmcdbDuplicateKeyEx getTmcdbDuplicateKeyEx () { return TmcdbErrType::TmcdbDuplicateKeyEx (getErrorTrace()); }
	
	template <class T >
	TmcdbDuplicateKeyExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class TmcdbSqlExImpl: public TmcdbErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbErrType;
	static const ACSErr::ErrorCode m_code = TmcdbSql;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	TmcdbSqlExImpl(const TmcdbSqlExImpl& ex) :
			TmcdbErrTypeExImpl(const_cast<TmcdbSqlExImpl&>(ex).getErrorTrace()) {}
		
	TmcdbSqlExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	TmcdbSqlExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbSqlExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbSqlExImpl (const TmcdbErrType::TmcdbSqlEx & ex) : 
			TmcdbErrTypeExImpl(ex.errorTrace) {}
			
	TmcdbErrType::TmcdbSqlEx getTmcdbSqlEx () { return TmcdbErrType::TmcdbSqlEx (getErrorTrace()); }
	
	template <class T >
	TmcdbSqlExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class TmcdbKeyUpdateExImpl: public TmcdbErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbErrType;
	static const ACSErr::ErrorCode m_code = TmcdbKeyUpdate;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	TmcdbKeyUpdateExImpl(const TmcdbKeyUpdateExImpl& ex) :
			TmcdbErrTypeExImpl(const_cast<TmcdbKeyUpdateExImpl&>(ex).getErrorTrace()) {}
		
	TmcdbKeyUpdateExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	TmcdbKeyUpdateExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbKeyUpdateExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbKeyUpdateExImpl (const TmcdbErrType::TmcdbKeyUpdateEx & ex) : 
			TmcdbErrTypeExImpl(ex.errorTrace) {}
			
	TmcdbErrType::TmcdbKeyUpdateEx getTmcdbKeyUpdateEx () { return TmcdbErrType::TmcdbKeyUpdateEx (getErrorTrace()); }
	
	template <class T >
	TmcdbKeyUpdateExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class TmcdbDuplicateRowExImpl: public TmcdbErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbErrType;
	static const ACSErr::ErrorCode m_code = TmcdbDuplicateRow;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	TmcdbDuplicateRowExImpl(const TmcdbDuplicateRowExImpl& ex) :
			TmcdbErrTypeExImpl(const_cast<TmcdbDuplicateRowExImpl&>(ex).getErrorTrace()) {}
		
	TmcdbDuplicateRowExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	TmcdbDuplicateRowExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbDuplicateRowExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbDuplicateRowExImpl (const TmcdbErrType::TmcdbDuplicateRowEx & ex) : 
			TmcdbErrTypeExImpl(ex.errorTrace) {}
			
	TmcdbErrType::TmcdbDuplicateRowEx getTmcdbDuplicateRowEx () { return TmcdbErrType::TmcdbDuplicateRowEx (getErrorTrace()); }
	
	template <class T >
	TmcdbDuplicateRowExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class TmcdbInvalidDataTypeExImpl: public TmcdbErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::TmcdbErrType;
	static const ACSErr::ErrorCode m_code = TmcdbInvalidDataType;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	TmcdbInvalidDataTypeExImpl(const TmcdbInvalidDataTypeExImpl& ex) :
			TmcdbErrTypeExImpl(const_cast<TmcdbInvalidDataTypeExImpl&>(ex).getErrorTrace()) {}
		
	TmcdbInvalidDataTypeExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	TmcdbInvalidDataTypeExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbInvalidDataTypeExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	TmcdbInvalidDataTypeExImpl (const TmcdbErrType::TmcdbInvalidDataTypeEx & ex) : 
			TmcdbErrTypeExImpl(ex.errorTrace) {}
			
	TmcdbErrType::TmcdbInvalidDataTypeEx getTmcdbInvalidDataTypeEx () { return TmcdbErrType::TmcdbInvalidDataTypeEx (getErrorTrace()); }
	
	template <class T >
	TmcdbInvalidDataTypeExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			TmcdbErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

}

#endif
