#ifndef Range_h
#define Range_h
/*
 * 	  Created on 08-02-2006
 * 
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 */

#include <string.h>
#include <archive_xmlstore_ifC.h>
#include "rangeEntityC.h"
#include "ArchiveIdentifierError.h" 
#include <expat.h>

// using std::string;

class Range
{
   private:
    std::string archiveid;
      bool   isLocked;
	
    std::string rangeid;

      long documentid;
      long maxDocumentid;
      long length;

    std::string getNextID() 
  	  throw (ArchiveIdentifierError::RangeExhaustedExImpl);

      /* for xml parser */
      short parse_xmlString( const char * xmlString );
      static void start_hndl(void *data, const XML_Char *el, const XML_Char **attr);
      static void end_hndl(void *data, const XML_Char *el);
      static void char_hndl(void *data, const XML_Char *s, int len);

   public :
	
      Range(const xmlstore::IdentifierRange& identifierRange);
      virtual ~Range() {};
	
      void assignUniqueEntityId(xmlentity::EntityT& entity)
		throw (ArchiveIdentifierError::RangeLockedExImpl, ArchiveIdentifierError::RangeExhaustedExImpl);
	
      void assignUniqueEntityRef(xmlentity::EntityRefT& ref)
		throw (ArchiveIdentifierError::RangeUnlockedExImpl, ArchiveIdentifierError::RangeExhaustedExImpl);
	
      xmlstore::URI rangeId() ;

      xmlstore::URI next()
  	  throw (ArchiveIdentifierError::RangeExhaustedExImpl);

      long getLength();
};

#endif
