#ifndef _MonitorCollectorErr_H_
#define _MonitorCollectorErr_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "MonitorCollectorErrC.h"

#include "acserrExceptionManager.h"

namespace MonitorCollectorErr
{

class DeviceAlreadyRegistredCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::MonitorCollectorErr; // = 60200
	static const ACSErr::ErrorCode m_code = DeviceAlreadyRegistred;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return DeviceAlreadyRegistredCompletion::m_shortDescription; }
	DeviceAlreadyRegistredCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	DeviceAlreadyRegistredCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	DeviceAlreadyRegistredCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	DeviceAlreadyRegistredCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	DeviceAlreadyRegistredCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	DeviceAlreadyRegistredCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

	void setDevice(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Device", value); }            				
	ACE_CString getDevice (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Device");  }


};

class RegisteringDeviceProblemCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::MonitorCollectorErr; // = 60200
	static const ACSErr::ErrorCode m_code = RegisteringDeviceProblem;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return RegisteringDeviceProblemCompletion::m_shortDescription; }
	RegisteringDeviceProblemCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	RegisteringDeviceProblemCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	RegisteringDeviceProblemCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	RegisteringDeviceProblemCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	RegisteringDeviceProblemCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	RegisteringDeviceProblemCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

	void setDevice(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Device", value); }            				
	ACE_CString getDevice (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Device");  }


};

class DeviceNotRegistredCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::MonitorCollectorErr; // = 60200
	static const ACSErr::ErrorCode m_code = DeviceNotRegistred;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return DeviceNotRegistredCompletion::m_shortDescription; }
	DeviceNotRegistredCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	DeviceNotRegistredCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	DeviceNotRegistredCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	DeviceNotRegistredCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	DeviceNotRegistredCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	DeviceNotRegistredCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

	void setDevice(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Device", value); }            				
	ACE_CString getDevice (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Device");  }


};

class StartMonitoringProblemCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::MonitorCollectorErr; // = 60200
	static const ACSErr::ErrorCode m_code = StartMonitoringProblem;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return StartMonitoringProblemCompletion::m_shortDescription; }
	StartMonitoringProblemCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	StartMonitoringProblemCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	StartMonitoringProblemCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	StartMonitoringProblemCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	StartMonitoringProblemCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	StartMonitoringProblemCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

	void setDevice(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Device", value); }            				
	ACE_CString getDevice (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Device");  }


};

class StopMonitoringProblemCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::MonitorCollectorErr; // = 60200
	static const ACSErr::ErrorCode m_code = StopMonitoringProblem;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return StopMonitoringProblemCompletion::m_shortDescription; }
	StopMonitoringProblemCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	StopMonitoringProblemCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	StopMonitoringProblemCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	StopMonitoringProblemCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	StopMonitoringProblemCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	StopMonitoringProblemCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

	void setDevice(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Device", value); }            				
	ACE_CString getDevice (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Device");  }


};

class NonExsistentPropertyCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::MonitorCollectorErr; // = 60200
	static const ACSErr::ErrorCode m_code = NonExsistentProperty;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return NonExsistentPropertyCompletion::m_shortDescription; }
	NonExsistentPropertyCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	NonExsistentPropertyCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NonExsistentPropertyCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NonExsistentPropertyCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NonExsistentPropertyCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	NonExsistentPropertyCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

	void setProperty(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Property", value); }            				
	ACE_CString getProperty (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Property");  }


};

class NonSupportedTypeCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::MonitorCollectorErr; // = 60200
	static const ACSErr::ErrorCode m_code = NonSupportedType;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return NonSupportedTypeCompletion::m_shortDescription; }
	NonSupportedTypeCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	NonSupportedTypeCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NonSupportedTypeCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NonSupportedTypeCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NonSupportedTypeCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	NonSupportedTypeCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

    void setProperty(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Property", value); }            				
	ACE_CString getProperty (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Property");  }

	void setPropertyType(ACE_CString value){ getErrorTraceHelper()->setMemberValue("PropertyType", value); }            				
	ACE_CString getPropertyType (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("PropertyType");  }


};

class NotCollocatedComponentCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::MonitorCollectorErr; // = 60200
	static const ACSErr::ErrorCode m_code = NotCollocatedComponent;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return NotCollocatedComponentCompletion::m_shortDescription; }
	NotCollocatedComponentCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	NotCollocatedComponentCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NotCollocatedComponentCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NotCollocatedComponentCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NotCollocatedComponentCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	NotCollocatedComponentCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

	void setComponent(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Component", value); }            				
	ACE_CString getComponent (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Component");  }


};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class MonitorCollectorErrExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	MonitorCollectorErrExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	MonitorCollectorErrExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	MonitorCollectorErrExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	MonitorCollectorErrExImpl (MonitorCollectorErr::MonitorCollectorErrEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	MonitorCollectorErr::MonitorCollectorErrEx getMonitorCollectorErrEx () { return MonitorCollectorErr::MonitorCollectorErrEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class DeviceAlreadyRegistredExImpl: public MonitorCollectorErrExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::MonitorCollectorErr;
	static const ACSErr::ErrorCode m_code = DeviceAlreadyRegistred;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	DeviceAlreadyRegistredExImpl(const DeviceAlreadyRegistredExImpl& ex) :
			MonitorCollectorErrExImpl(const_cast<DeviceAlreadyRegistredExImpl&>(ex).getErrorTrace()) {}
		
	DeviceAlreadyRegistredExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	DeviceAlreadyRegistredExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	DeviceAlreadyRegistredExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	DeviceAlreadyRegistredExImpl (const MonitorCollectorErr::DeviceAlreadyRegistredEx & ex) : 
			MonitorCollectorErrExImpl(ex.errorTrace) {}
			
	MonitorCollectorErr::DeviceAlreadyRegistredEx getDeviceAlreadyRegistredEx () { return MonitorCollectorErr::DeviceAlreadyRegistredEx (getErrorTrace()); }
	
	template <class T >
	DeviceAlreadyRegistredExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


	void setDevice(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Device", value); }            				
	ACE_CString getDevice (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Device");  }


};

class RegisteringDeviceProblemExImpl: public MonitorCollectorErrExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::MonitorCollectorErr;
	static const ACSErr::ErrorCode m_code = RegisteringDeviceProblem;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	RegisteringDeviceProblemExImpl(const RegisteringDeviceProblemExImpl& ex) :
			MonitorCollectorErrExImpl(const_cast<RegisteringDeviceProblemExImpl&>(ex).getErrorTrace()) {}
		
	RegisteringDeviceProblemExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	RegisteringDeviceProblemExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	RegisteringDeviceProblemExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	RegisteringDeviceProblemExImpl (const MonitorCollectorErr::RegisteringDeviceProblemEx & ex) : 
			MonitorCollectorErrExImpl(ex.errorTrace) {}
			
	MonitorCollectorErr::RegisteringDeviceProblemEx getRegisteringDeviceProblemEx () { return MonitorCollectorErr::RegisteringDeviceProblemEx (getErrorTrace()); }
	
	template <class T >
	RegisteringDeviceProblemExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


	void setDevice(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Device", value); }            				
	ACE_CString getDevice (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Device");  }


};

class DeviceNotRegistredExImpl: public MonitorCollectorErrExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::MonitorCollectorErr;
	static const ACSErr::ErrorCode m_code = DeviceNotRegistred;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	DeviceNotRegistredExImpl(const DeviceNotRegistredExImpl& ex) :
			MonitorCollectorErrExImpl(const_cast<DeviceNotRegistredExImpl&>(ex).getErrorTrace()) {}
		
	DeviceNotRegistredExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	DeviceNotRegistredExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	DeviceNotRegistredExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	DeviceNotRegistredExImpl (const MonitorCollectorErr::DeviceNotRegistredEx & ex) : 
			MonitorCollectorErrExImpl(ex.errorTrace) {}
			
	MonitorCollectorErr::DeviceNotRegistredEx getDeviceNotRegistredEx () { return MonitorCollectorErr::DeviceNotRegistredEx (getErrorTrace()); }
	
	template <class T >
	DeviceNotRegistredExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


	void setDevice(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Device", value); }            				
	ACE_CString getDevice (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Device");  }


};

class StartMonitoringProblemExImpl: public MonitorCollectorErrExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::MonitorCollectorErr;
	static const ACSErr::ErrorCode m_code = StartMonitoringProblem;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	StartMonitoringProblemExImpl(const StartMonitoringProblemExImpl& ex) :
			MonitorCollectorErrExImpl(const_cast<StartMonitoringProblemExImpl&>(ex).getErrorTrace()) {}
		
	StartMonitoringProblemExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	StartMonitoringProblemExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	StartMonitoringProblemExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	StartMonitoringProblemExImpl (const MonitorCollectorErr::StartMonitoringProblemEx & ex) : 
			MonitorCollectorErrExImpl(ex.errorTrace) {}
			
	MonitorCollectorErr::StartMonitoringProblemEx getStartMonitoringProblemEx () { return MonitorCollectorErr::StartMonitoringProblemEx (getErrorTrace()); }
	
	template <class T >
	StartMonitoringProblemExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


	void setDevice(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Device", value); }            				
	ACE_CString getDevice (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Device");  }


};

class StopMonitoringProblemExImpl: public MonitorCollectorErrExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::MonitorCollectorErr;
	static const ACSErr::ErrorCode m_code = StopMonitoringProblem;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	StopMonitoringProblemExImpl(const StopMonitoringProblemExImpl& ex) :
			MonitorCollectorErrExImpl(const_cast<StopMonitoringProblemExImpl&>(ex).getErrorTrace()) {}
		
	StopMonitoringProblemExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	StopMonitoringProblemExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	StopMonitoringProblemExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	StopMonitoringProblemExImpl (const MonitorCollectorErr::StopMonitoringProblemEx & ex) : 
			MonitorCollectorErrExImpl(ex.errorTrace) {}
			
	MonitorCollectorErr::StopMonitoringProblemEx getStopMonitoringProblemEx () { return MonitorCollectorErr::StopMonitoringProblemEx (getErrorTrace()); }
	
	template <class T >
	StopMonitoringProblemExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


	void setDevice(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Device", value); }            				
	ACE_CString getDevice (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Device");  }


};

class NonExsistentPropertyExImpl: public MonitorCollectorErrExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::MonitorCollectorErr;
	static const ACSErr::ErrorCode m_code = NonExsistentProperty;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	NonExsistentPropertyExImpl(const NonExsistentPropertyExImpl& ex) :
			MonitorCollectorErrExImpl(const_cast<NonExsistentPropertyExImpl&>(ex).getErrorTrace()) {}
		
	NonExsistentPropertyExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	NonExsistentPropertyExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	NonExsistentPropertyExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	NonExsistentPropertyExImpl (const MonitorCollectorErr::NonExsistentPropertyEx & ex) : 
			MonitorCollectorErrExImpl(ex.errorTrace) {}
			
	MonitorCollectorErr::NonExsistentPropertyEx getNonExsistentPropertyEx () { return MonitorCollectorErr::NonExsistentPropertyEx (getErrorTrace()); }
	
	template <class T >
	NonExsistentPropertyExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


	void setProperty(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Property", value); }            				
	ACE_CString getProperty (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Property");  }


};

class NonSupportedTypeExImpl: public MonitorCollectorErrExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::MonitorCollectorErr;
	static const ACSErr::ErrorCode m_code = NonSupportedType;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	NonSupportedTypeExImpl(const NonSupportedTypeExImpl& ex) :
			MonitorCollectorErrExImpl(const_cast<NonSupportedTypeExImpl&>(ex).getErrorTrace()) {}
		
	NonSupportedTypeExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	NonSupportedTypeExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	NonSupportedTypeExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	NonSupportedTypeExImpl (const MonitorCollectorErr::NonSupportedTypeEx & ex) : 
			MonitorCollectorErrExImpl(ex.errorTrace) {}
			
	MonitorCollectorErr::NonSupportedTypeEx getNonSupportedTypeEx () { return MonitorCollectorErr::NonSupportedTypeEx (getErrorTrace()); }
	
	template <class T >
	NonSupportedTypeExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


    void setProperty(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Property", value); }            				
	ACE_CString getProperty (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Property");  }

	void setPropertyType(ACE_CString value){ getErrorTraceHelper()->setMemberValue("PropertyType", value); }            				
	ACE_CString getPropertyType (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("PropertyType");  }


};

class NotCollocatedComponentExImpl: public MonitorCollectorErrExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::MonitorCollectorErr;
	static const ACSErr::ErrorCode m_code = NotCollocatedComponent;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	NotCollocatedComponentExImpl(const NotCollocatedComponentExImpl& ex) :
			MonitorCollectorErrExImpl(const_cast<NotCollocatedComponentExImpl&>(ex).getErrorTrace()) {}
		
	NotCollocatedComponentExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	NotCollocatedComponentExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	NotCollocatedComponentExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	NotCollocatedComponentExImpl (const MonitorCollectorErr::NotCollocatedComponentEx & ex) : 
			MonitorCollectorErrExImpl(ex.errorTrace) {}
			
	MonitorCollectorErr::NotCollocatedComponentEx getNotCollocatedComponentEx () { return MonitorCollectorErr::NotCollocatedComponentEx (getErrorTrace()); }
	
	template <class T >
	NotCollocatedComponentExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			MonitorCollectorErrExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


	void setComponent(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Component", value); }            				
	ACE_CString getComponent (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Component");  }


};

}

#endif
