#ifndef _ErrorSystemErrType_H_
#define _ErrorSystemErrType_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "ErrorSystemErrTypeC.h"

#include "acserrExceptionManager.h"

namespace ErrorSystemErrType
{

class ErrorTraceOverFlowCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ErrorSystemErrType; // = 32
	static const ACSErr::ErrorCode m_code = ErrorTraceOverFlow;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return ErrorTraceOverFlowCompletion::m_shortDescription; }
	ErrorTraceOverFlowCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	ErrorTraceOverFlowCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ErrorTraceOverFlowCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ErrorTraceOverFlowCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ErrorTraceOverFlowCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	ErrorTraceOverFlowCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class EmptyErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ErrorSystemErrType; // = 32
	static const ACSErr::ErrorCode m_code = EmptyError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return EmptyErrorCompletion::m_shortDescription; }
	EmptyErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	EmptyErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	EmptyErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	EmptyErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	EmptyErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	EmptyErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class ErrorSystemErrTypeExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	ErrorSystemErrTypeExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	ErrorSystemErrTypeExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	ErrorSystemErrTypeExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	ErrorSystemErrTypeExImpl (ErrorSystemErrType::ErrorSystemErrTypeEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	ErrorSystemErrType::ErrorSystemErrTypeEx getErrorSystemErrTypeEx () { return ErrorSystemErrType::ErrorSystemErrTypeEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class ErrorTraceOverFlowExImpl: public ErrorSystemErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ErrorSystemErrType;
	static const ACSErr::ErrorCode m_code = ErrorTraceOverFlow;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	ErrorTraceOverFlowExImpl(const ErrorTraceOverFlowExImpl& ex) :
			ErrorSystemErrTypeExImpl(const_cast<ErrorTraceOverFlowExImpl&>(ex).getErrorTrace()) {}
		
	ErrorTraceOverFlowExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ErrorSystemErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	ErrorTraceOverFlowExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ErrorSystemErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ErrorTraceOverFlowExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ErrorSystemErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ErrorTraceOverFlowExImpl (const ErrorSystemErrType::ErrorTraceOverFlowEx & ex) : 
			ErrorSystemErrTypeExImpl(ex.errorTrace) {}
			
	ErrorSystemErrType::ErrorTraceOverFlowEx getErrorTraceOverFlowEx () { return ErrorSystemErrType::ErrorTraceOverFlowEx (getErrorTrace()); }
	
	template <class T >
	ErrorTraceOverFlowExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ErrorSystemErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class EmptyErrorExImpl: public ErrorSystemErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ErrorSystemErrType;
	static const ACSErr::ErrorCode m_code = EmptyError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	EmptyErrorExImpl(const EmptyErrorExImpl& ex) :
			ErrorSystemErrTypeExImpl(const_cast<EmptyErrorExImpl&>(ex).getErrorTrace()) {}
		
	EmptyErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ErrorSystemErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	EmptyErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ErrorSystemErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	EmptyErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ErrorSystemErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	EmptyErrorExImpl (const ErrorSystemErrType::EmptyErrorEx & ex) : 
			ErrorSystemErrTypeExImpl(ex.errorTrace) {}
			
	ErrorSystemErrType::EmptyErrorEx getEmptyErrorEx () { return ErrorSystemErrType::EmptyErrorEx (getErrorTrace()); }
	
	template <class T >
	EmptyErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ErrorSystemErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

}

#endif
