#ifndef _DAOErrType_H_
#define _DAOErrType_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "DAOErrTypeC.h"

#include "acserrExceptionManager.h"

namespace DAOErrType
{

class GettingMonitorCharacteristicsCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::DAOErrType; // = 60205
	static const ACSErr::ErrorCode m_code = GettingMonitorCharacteristics;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return GettingMonitorCharacteristicsCompletion::m_shortDescription; }
	GettingMonitorCharacteristicsCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	GettingMonitorCharacteristicsCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	GettingMonitorCharacteristicsCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	GettingMonitorCharacteristicsCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	GettingMonitorCharacteristicsCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	GettingMonitorCharacteristicsCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class StoreFailureCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::DAOErrType; // = 60205
	static const ACSErr::ErrorCode m_code = StoreFailure;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return StoreFailureCompletion::m_shortDescription; }
	StoreFailureCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	StoreFailureCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	StoreFailureCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	StoreFailureCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	StoreFailureCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	StoreFailureCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class DynConfigFailureCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::DAOErrType; // = 60205
	static const ACSErr::ErrorCode m_code = DynConfigFailure;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return DynConfigFailureCompletion::m_shortDescription; }
	DynConfigFailureCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	DynConfigFailureCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	DynConfigFailureCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	DynConfigFailureCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	DynConfigFailureCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	DynConfigFailureCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class DAOErrTypeExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	DAOErrTypeExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	DAOErrTypeExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	DAOErrTypeExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	DAOErrTypeExImpl (DAOErrType::DAOErrTypeEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	DAOErrType::DAOErrTypeEx getDAOErrTypeEx () { return DAOErrType::DAOErrTypeEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class GettingMonitorCharacteristicsExImpl: public DAOErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::DAOErrType;
	static const ACSErr::ErrorCode m_code = GettingMonitorCharacteristics;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	GettingMonitorCharacteristicsExImpl(const GettingMonitorCharacteristicsExImpl& ex) :
			DAOErrTypeExImpl(const_cast<GettingMonitorCharacteristicsExImpl&>(ex).getErrorTrace()) {}
		
	GettingMonitorCharacteristicsExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			DAOErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	GettingMonitorCharacteristicsExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			DAOErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	GettingMonitorCharacteristicsExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			DAOErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	GettingMonitorCharacteristicsExImpl (const DAOErrType::GettingMonitorCharacteristicsEx & ex) : 
			DAOErrTypeExImpl(ex.errorTrace) {}
			
	DAOErrType::GettingMonitorCharacteristicsEx getGettingMonitorCharacteristicsEx () { return DAOErrType::GettingMonitorCharacteristicsEx (getErrorTrace()); }
	
	template <class T >
	GettingMonitorCharacteristicsExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			DAOErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class StoreFailureExImpl: public DAOErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::DAOErrType;
	static const ACSErr::ErrorCode m_code = StoreFailure;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	StoreFailureExImpl(const StoreFailureExImpl& ex) :
			DAOErrTypeExImpl(const_cast<StoreFailureExImpl&>(ex).getErrorTrace()) {}
		
	StoreFailureExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			DAOErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	StoreFailureExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			DAOErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	StoreFailureExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			DAOErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	StoreFailureExImpl (const DAOErrType::StoreFailureEx & ex) : 
			DAOErrTypeExImpl(ex.errorTrace) {}
			
	DAOErrType::StoreFailureEx getStoreFailureEx () { return DAOErrType::StoreFailureEx (getErrorTrace()); }
	
	template <class T >
	StoreFailureExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			DAOErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class DynConfigFailureExImpl: public DAOErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::DAOErrType;
	static const ACSErr::ErrorCode m_code = DynConfigFailure;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	DynConfigFailureExImpl(const DynConfigFailureExImpl& ex) :
			DAOErrTypeExImpl(const_cast<DynConfigFailureExImpl&>(ex).getErrorTrace()) {}
		
	DynConfigFailureExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			DAOErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	DynConfigFailureExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			DAOErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	DynConfigFailureExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			DAOErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	DynConfigFailureExImpl (const DAOErrType::DynConfigFailureEx & ex) : 
			DAOErrTypeExImpl(ex.errorTrace) {}
			
	DAOErrType::DynConfigFailureEx getDynConfigFailureEx () { return DAOErrType::DynConfigFailureEx (getErrorTrace()); }
	
	template <class T >
	DynConfigFailureExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			DAOErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

}

#endif
