#ifndef _AcsNCTraceLog_H_
#define _AcsNCTraceLog_H_
/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) Associated Universities Inc., 2007
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: LTS2H.xslt,v 1.5 2007/12/19 14:19:31 bjeram Exp $"
*
* who       when      what
* --------  --------  ----------------------------------------------
* nbarriga  2007-01-30  created
*/

/************************************************************************
 *
 *----------------------------------------------------------------------
 */

#ifndef __cplusplus
#error This is a C++ include file and cannot be used from plain C
#endif

#include <string>
#include <logging_idlS.h>
#include <loggingACSLogger.h>
#include <logging.h>
#include <TypeSafeLog.h>

using namespace std;

namespace AcsNCTraceLog{

class LOG_NC_ChannelCreated_ATTEMPT:public Logging::TypeSafeLog{
	private:
                Logging::BaseLog::Priority priority;
                string file;
                unsigned long line;
                string routine;
                string name;
                string audience;
                string array;
                string antenna;
                string shortDescription;
                ACSLoggingLog::NameValueSeq members;
	protected:

	public:
		LOG_NC_ChannelCreated_ATTEMPT(string file,
                        unsigned long line,
                        string routine);
		LOG_NC_ChannelCreated_ATTEMPT(string file,
                        unsigned long line,
                        string routine,
                        string array,
                        string antenna);
                void init(string file, unsigned long line, string routine);
                virtual ~LOG_NC_ChannelCreated_ATTEMPT();
		void log();
                void setArray(string array);
                void setAntenna(string antenna);
                string getArray();
                string getAntenna();
		void setChannelName(string value);
		void setService(string value);

};

class LOG_NC_ChannelCreated_OK:public Logging::TypeSafeLog{
	private:
                Logging::BaseLog::Priority priority;
                string file;
                unsigned long line;
                string routine;
                string name;
                string audience;
                string array;
                string antenna;
                string shortDescription;
                ACSLoggingLog::NameValueSeq members;
	protected:

	public:
		LOG_NC_ChannelCreated_OK(string file,
                        unsigned long line,
                        string routine);
		LOG_NC_ChannelCreated_OK(string file,
                        unsigned long line,
                        string routine,
                        string array,
                        string antenna);
                void init(string file, unsigned long line, string routine);
                virtual ~LOG_NC_ChannelCreated_OK();
		void log();
                void setArray(string array);
                void setAntenna(string antenna);
                string getArray();
                string getAntenna();
		void setChannelName(string value);
		void setChannelId(long value);
		void setService(string value);

};

class LOG_NC_ChannelDestroyed_OK:public Logging::TypeSafeLog{
	private:
                Logging::BaseLog::Priority priority;
                string file;
                unsigned long line;
                string routine;
                string name;
                string audience;
                string array;
                string antenna;
                string shortDescription;
                ACSLoggingLog::NameValueSeq members;
	protected:

	public:
		LOG_NC_ChannelDestroyed_OK(string file,
                        unsigned long line,
                        string routine);
		LOG_NC_ChannelDestroyed_OK(string file,
                        unsigned long line,
                        string routine,
                        string array,
                        string antenna);
                void init(string file, unsigned long line, string routine);
                virtual ~LOG_NC_ChannelDestroyed_OK();
		void log();
                void setArray(string array);
                void setAntenna(string antenna);
                string getArray();
                string getAntenna();
		void setChannelName(string value);
		void setService(string value);

};

class LOG_NC_SubscriptionConnect_OK:public Logging::TypeSafeLog{
	private:
                Logging::BaseLog::Priority priority;
                string file;
                unsigned long line;
                string routine;
                string name;
                string audience;
                string array;
                string antenna;
                string shortDescription;
                ACSLoggingLog::NameValueSeq members;
	protected:

	public:
		LOG_NC_SubscriptionConnect_OK(string file,
                        unsigned long line,
                        string routine);
		LOG_NC_SubscriptionConnect_OK(string file,
                        unsigned long line,
                        string routine,
                        string array,
                        string antenna);
                void init(string file, unsigned long line, string routine);
                virtual ~LOG_NC_SubscriptionConnect_OK();
		void log();
                void setArray(string array);
                void setAntenna(string antenna);
                string getArray();
                string getAntenna();
		void setChannelName(string value);
		void setService(string value);

};

class LOG_NC_SubscriptionConnect_FAIL:public Logging::TypeSafeLog{
	private:
                Logging::BaseLog::Priority priority;
                string file;
                unsigned long line;
                string routine;
                string name;
                string audience;
                string array;
                string antenna;
                string shortDescription;
                ACSLoggingLog::NameValueSeq members;
	protected:

	public:
		LOG_NC_SubscriptionConnect_FAIL(string file,
                        unsigned long line,
                        string routine);
		LOG_NC_SubscriptionConnect_FAIL(string file,
                        unsigned long line,
                        string routine,
                        string array,
                        string antenna);
                void init(string file, unsigned long line, string routine);
                virtual ~LOG_NC_SubscriptionConnect_FAIL();
		void log();
                void setArray(string array);
                void setAntenna(string antenna);
                string getArray();
                string getAntenna();
		void setChannelName(string value);
		void setService(string value);

};

class LOG_NC_SubscriptionDisconnect_OK:public Logging::TypeSafeLog{
	private:
                Logging::BaseLog::Priority priority;
                string file;
                unsigned long line;
                string routine;
                string name;
                string audience;
                string array;
                string antenna;
                string shortDescription;
                ACSLoggingLog::NameValueSeq members;
	protected:

	public:
		LOG_NC_SubscriptionDisconnect_OK(string file,
                        unsigned long line,
                        string routine);
		LOG_NC_SubscriptionDisconnect_OK(string file,
                        unsigned long line,
                        string routine,
                        string array,
                        string antenna);
                void init(string file, unsigned long line, string routine);
                virtual ~LOG_NC_SubscriptionDisconnect_OK();
		void log();
                void setArray(string array);
                void setAntenna(string antenna);
                string getArray();
                string getAntenna();
		void setChannelName(string value);
		void setService(string value);

};

class LOG_NC_SubscriptionDisconnect_FAIL:public Logging::TypeSafeLog{
	private:
                Logging::BaseLog::Priority priority;
                string file;
                unsigned long line;
                string routine;
                string name;
                string audience;
                string array;
                string antenna;
                string shortDescription;
                ACSLoggingLog::NameValueSeq members;
	protected:

	public:
		LOG_NC_SubscriptionDisconnect_FAIL(string file,
                        unsigned long line,
                        string routine);
		LOG_NC_SubscriptionDisconnect_FAIL(string file,
                        unsigned long line,
                        string routine,
                        string array,
                        string antenna);
                void init(string file, unsigned long line, string routine);
                virtual ~LOG_NC_SubscriptionDisconnect_FAIL();
		void log();
                void setArray(string array);
                void setAntenna(string antenna);
                string getArray();
                string getAntenna();
		void setChannelName(string value);
		void setService(string value);

};

class LOG_NC_ProcessingTimeExceeded:public Logging::TypeSafeLog{
	private:
                Logging::BaseLog::Priority priority;
                string file;
                unsigned long line;
                string routine;
                string name;
                string audience;
                string array;
                string antenna;
                string shortDescription;
                ACSLoggingLog::NameValueSeq members;
	protected:

	public:
		LOG_NC_ProcessingTimeExceeded(string file,
                        unsigned long line,
                        string routine);
		LOG_NC_ProcessingTimeExceeded(string file,
                        unsigned long line,
                        string routine,
                        string array,
                        string antenna);
                void init(string file, unsigned long line, string routine);
                virtual ~LOG_NC_ProcessingTimeExceeded();
		void log();
                void setArray(string array);
                void setAntenna(string antenna);
                string getArray();
                string getAntenna();
		void setChannelName(string value);
		void setService(string value);
		void setEventName(string value);
		void setLogOcurrencesNumber(long value);

};

class LOG_NC_ProcessingWithoutHandler:public Logging::TypeSafeLog{
	private:
                Logging::BaseLog::Priority priority;
                string file;
                unsigned long line;
                string routine;
                string name;
                string audience;
                string array;
                string antenna;
                string shortDescription;
                ACSLoggingLog::NameValueSeq members;
	protected:

	public:
		LOG_NC_ProcessingWithoutHandler(string file,
                        unsigned long line,
                        string routine);
		LOG_NC_ProcessingWithoutHandler(string file,
                        unsigned long line,
                        string routine,
                        string array,
                        string antenna);
                void init(string file, unsigned long line, string routine);
                virtual ~LOG_NC_ProcessingWithoutHandler();
		void log();
                void setArray(string array);
                void setAntenna(string antenna);
                string getArray();
                string getAntenna();
		void setChannelName(string value);
		void setService(string value);
		void setEventName(string value);

};

class LOG_NC_EventReceive_OK:public Logging::TypeSafeLog{
	private:
                Logging::BaseLog::Priority priority;
                string file;
                unsigned long line;
                string routine;
                string name;
                string audience;
                string array;
                string antenna;
                string shortDescription;
                ACSLoggingLog::NameValueSeq members;
	protected:

	public:
		LOG_NC_EventReceive_OK(string file,
                        unsigned long line,
                        string routine);
		LOG_NC_EventReceive_OK(string file,
                        unsigned long line,
                        string routine,
                        string array,
                        string antenna);
                void init(string file, unsigned long line, string routine);
                virtual ~LOG_NC_EventReceive_OK();
		void log();
                void setArray(string array);
                void setAntenna(string antenna);
                string getArray();
                string getAntenna();
		void setChannelName(string value);
		void setService(string value);
		void setEventName(string value);

};

class LOG_NC_EventReceive_FAIL:public Logging::TypeSafeLog{
	private:
                Logging::BaseLog::Priority priority;
                string file;
                unsigned long line;
                string routine;
                string name;
                string audience;
                string array;
                string antenna;
                string shortDescription;
                ACSLoggingLog::NameValueSeq members;
	protected:

	public:
		LOG_NC_EventReceive_FAIL(string file,
                        unsigned long line,
                        string routine);
		LOG_NC_EventReceive_FAIL(string file,
                        unsigned long line,
                        string routine,
                        string array,
                        string antenna);
                void init(string file, unsigned long line, string routine);
                virtual ~LOG_NC_EventReceive_FAIL();
		void log();
                void setArray(string array);
                void setAntenna(string antenna);
                string getArray();
                string getAntenna();
		void setChannelName(string value);
		void setService(string value);
		void setEventName(string value);

};


};

#endif
