#ifndef _ACSTimeError_H_
#define _ACSTimeError_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "ACSTimeErrorC.h"

#include "acserrExceptionManager.h"

namespace ACSTimeError
{

class OverflowOrUnderflowCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSTimeError; // = 33
	static const ACSErr::ErrorCode m_code = OverflowOrUnderflow;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return OverflowOrUnderflowCompletion::m_shortDescription; }
	OverflowOrUnderflowCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	OverflowOrUnderflowCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	OverflowOrUnderflowCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	OverflowOrUnderflowCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	OverflowOrUnderflowCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	OverflowOrUnderflowCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class ArgErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSTimeError; // = 33
	static const ACSErr::ErrorCode m_code = ArgError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return ArgErrorCompletion::m_shortDescription; }
	ArgErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	ArgErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ArgErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ArgErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ArgErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	ArgErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class InvalidIDCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSTimeError; // = 33
	static const ACSErr::ErrorCode m_code = InvalidID;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return InvalidIDCompletion::m_shortDescription; }
	InvalidIDCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	InvalidIDCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	InvalidIDCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	InvalidIDCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	InvalidIDCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	InvalidIDCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class ACSTimeErrorExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	ACSTimeErrorExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	ACSTimeErrorExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	ACSTimeErrorExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	ACSTimeErrorExImpl (ACSTimeError::ACSTimeErrorEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	ACSTimeError::ACSTimeErrorEx getACSTimeErrorEx () { return ACSTimeError::ACSTimeErrorEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class OverflowOrUnderflowExImpl: public ACSTimeErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSTimeError;
	static const ACSErr::ErrorCode m_code = OverflowOrUnderflow;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	OverflowOrUnderflowExImpl(const OverflowOrUnderflowExImpl& ex) :
			ACSTimeErrorExImpl(const_cast<OverflowOrUnderflowExImpl&>(ex).getErrorTrace()) {}
		
	OverflowOrUnderflowExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSTimeErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	OverflowOrUnderflowExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSTimeErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	OverflowOrUnderflowExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSTimeErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	OverflowOrUnderflowExImpl (const ACSTimeError::OverflowOrUnderflowEx & ex) : 
			ACSTimeErrorExImpl(ex.errorTrace) {}
			
	ACSTimeError::OverflowOrUnderflowEx getOverflowOrUnderflowEx () { return ACSTimeError::OverflowOrUnderflowEx (getErrorTrace()); }
	
	template <class T >
	OverflowOrUnderflowExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSTimeErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class ArgErrorExImpl: public ACSTimeErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSTimeError;
	static const ACSErr::ErrorCode m_code = ArgError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	ArgErrorExImpl(const ArgErrorExImpl& ex) :
			ACSTimeErrorExImpl(const_cast<ArgErrorExImpl&>(ex).getErrorTrace()) {}
		
	ArgErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSTimeErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	ArgErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSTimeErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ArgErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSTimeErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ArgErrorExImpl (const ACSTimeError::ArgErrorEx & ex) : 
			ACSTimeErrorExImpl(ex.errorTrace) {}
			
	ACSTimeError::ArgErrorEx getArgErrorEx () { return ACSTimeError::ArgErrorEx (getErrorTrace()); }
	
	template <class T >
	ArgErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSTimeErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class InvalidIDExImpl: public ACSTimeErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSTimeError;
	static const ACSErr::ErrorCode m_code = InvalidID;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	InvalidIDExImpl(const InvalidIDExImpl& ex) :
			ACSTimeErrorExImpl(const_cast<InvalidIDExImpl&>(ex).getErrorTrace()) {}
		
	InvalidIDExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSTimeErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	InvalidIDExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSTimeErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	InvalidIDExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSTimeErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	InvalidIDExImpl (const ACSTimeError::InvalidIDEx & ex) : 
			ACSTimeErrorExImpl(ex.errorTrace) {}
			
	ACSTimeError::InvalidIDEx getInvalidIDEx () { return ACSTimeError::InvalidIDEx (getErrorTrace()); }
	
	template <class T >
	InvalidIDExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSTimeErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

}

#endif
