#ifndef _ACSErrTypeMonitor_H_
#define _ACSErrTypeMonitor_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "ACSErrTypeMonitorC.h"

#include "acserrExceptionManager.h"

namespace ACSErrTypeMonitor
{

class ACSErrMonitorOnTimerCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeMonitor; // = 1
	static const ACSErr::ErrorCode m_code = ACSErrMonitorOnTimer;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return ACSErrMonitorOnTimerCompletion::m_shortDescription; }
	ACSErrMonitorOnTimerCompletion () : ACSErr::CompletionImpl(m_etype, m_code) {}				
 };
 
class ACSErrMonitorOnValueCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeMonitor; // = 1
	static const ACSErr::ErrorCode m_code = ACSErrMonitorOnValue;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return ACSErrMonitorOnValueCompletion::m_shortDescription; }
	ACSErrMonitorOnValueCompletion () : ACSErr::CompletionImpl(m_etype, m_code) {}				
 };
 
class ACSErrMonitorErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeMonitor; // = 1
	static const ACSErr::ErrorCode m_code = ACSErrMonitorError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return ACSErrMonitorErrorCompletion::m_shortDescription; }
	ACSErrMonitorErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	ACSErrMonitorErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ACSErrMonitorErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ACSErrMonitorErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ACSErrMonitorErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	ACSErrMonitorErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class ACSErrTypeMonitorExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	ACSErrTypeMonitorExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	ACSErrTypeMonitorExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	ACSErrTypeMonitorExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	ACSErrTypeMonitorExImpl (ACSErrTypeMonitor::ACSErrTypeMonitorEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	ACSErrTypeMonitor::ACSErrTypeMonitorEx getACSErrTypeMonitorEx () { return ACSErrTypeMonitor::ACSErrTypeMonitorEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class ACSErrMonitorErrorExImpl: public ACSErrTypeMonitorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeMonitor;
	static const ACSErr::ErrorCode m_code = ACSErrMonitorError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	ACSErrMonitorErrorExImpl(const ACSErrMonitorErrorExImpl& ex) :
			ACSErrTypeMonitorExImpl(const_cast<ACSErrMonitorErrorExImpl&>(ex).getErrorTrace()) {}
		
	ACSErrMonitorErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeMonitorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	ACSErrMonitorErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeMonitorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ACSErrMonitorErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeMonitorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ACSErrMonitorErrorExImpl (const ACSErrTypeMonitor::ACSErrMonitorErrorEx & ex) : 
			ACSErrTypeMonitorExImpl(ex.errorTrace) {}
			
	ACSErrTypeMonitor::ACSErrMonitorErrorEx getACSErrMonitorErrorEx () { return ACSErrTypeMonitor::ACSErrMonitorErrorEx (getErrorTrace()); }
	
	template <class T >
	ACSErrMonitorErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeMonitorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

}

#endif
