#ifndef _ACSErrTypeDevIO_H_
#define _ACSErrTypeDevIO_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "ACSErrTypeDevIOC.h"

#include "acserrExceptionManager.h"

namespace ACSErrTypeDevIO
{

class ReadErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeDevIO; // = 17
	static const ACSErr::ErrorCode m_code = ReadError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return ReadErrorCompletion::m_shortDescription; }
	ReadErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	ReadErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ReadErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ReadErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ReadErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	ReadErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class WriteErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeDevIO; // = 17
	static const ACSErr::ErrorCode m_code = WriteError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return WriteErrorCompletion::m_shortDescription; }
	WriteErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	WriteErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	WriteErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	WriteErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	WriteErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	WriteErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class UnimplementedReadCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeDevIO; // = 17
	static const ACSErr::ErrorCode m_code = UnimplementedRead;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return UnimplementedReadCompletion::m_shortDescription; }
	UnimplementedReadCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	UnimplementedReadCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnimplementedReadCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnimplementedReadCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnimplementedReadCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	UnimplementedReadCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class UnimplementedWriteCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeDevIO; // = 17
	static const ACSErr::ErrorCode m_code = UnimplementedWrite;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return UnimplementedWriteCompletion::m_shortDescription; }
	UnimplementedWriteCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	UnimplementedWriteCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnimplementedWriteCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnimplementedWriteCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UnimplementedWriteCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	UnimplementedWriteCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class ACSErrTypeDevIOExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	ACSErrTypeDevIOExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	ACSErrTypeDevIOExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	ACSErrTypeDevIOExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	ACSErrTypeDevIOExImpl (ACSErrTypeDevIO::ACSErrTypeDevIOEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	ACSErrTypeDevIO::ACSErrTypeDevIOEx getACSErrTypeDevIOEx () { return ACSErrTypeDevIO::ACSErrTypeDevIOEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class ReadErrorExImpl: public ACSErrTypeDevIOExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeDevIO;
	static const ACSErr::ErrorCode m_code = ReadError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	ReadErrorExImpl(const ReadErrorExImpl& ex) :
			ACSErrTypeDevIOExImpl(const_cast<ReadErrorExImpl&>(ex).getErrorTrace()) {}
		
	ReadErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeDevIOExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	ReadErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeDevIOExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ReadErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeDevIOExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ReadErrorExImpl (const ACSErrTypeDevIO::ReadErrorEx & ex) : 
			ACSErrTypeDevIOExImpl(ex.errorTrace) {}
			
	ACSErrTypeDevIO::ReadErrorEx getReadErrorEx () { return ACSErrTypeDevIO::ReadErrorEx (getErrorTrace()); }
	
	template <class T >
	ReadErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeDevIOExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class WriteErrorExImpl: public ACSErrTypeDevIOExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeDevIO;
	static const ACSErr::ErrorCode m_code = WriteError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	WriteErrorExImpl(const WriteErrorExImpl& ex) :
			ACSErrTypeDevIOExImpl(const_cast<WriteErrorExImpl&>(ex).getErrorTrace()) {}
		
	WriteErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeDevIOExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	WriteErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeDevIOExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	WriteErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeDevIOExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	WriteErrorExImpl (const ACSErrTypeDevIO::WriteErrorEx & ex) : 
			ACSErrTypeDevIOExImpl(ex.errorTrace) {}
			
	ACSErrTypeDevIO::WriteErrorEx getWriteErrorEx () { return ACSErrTypeDevIO::WriteErrorEx (getErrorTrace()); }
	
	template <class T >
	WriteErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeDevIOExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class UnimplementedReadExImpl: public ACSErrTypeDevIOExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeDevIO;
	static const ACSErr::ErrorCode m_code = UnimplementedRead;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	UnimplementedReadExImpl(const UnimplementedReadExImpl& ex) :
			ACSErrTypeDevIOExImpl(const_cast<UnimplementedReadExImpl&>(ex).getErrorTrace()) {}
		
	UnimplementedReadExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeDevIOExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	UnimplementedReadExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeDevIOExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UnimplementedReadExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeDevIOExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UnimplementedReadExImpl (const ACSErrTypeDevIO::UnimplementedReadEx & ex) : 
			ACSErrTypeDevIOExImpl(ex.errorTrace) {}
			
	ACSErrTypeDevIO::UnimplementedReadEx getUnimplementedReadEx () { return ACSErrTypeDevIO::UnimplementedReadEx (getErrorTrace()); }
	
	template <class T >
	UnimplementedReadExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeDevIOExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class UnimplementedWriteExImpl: public ACSErrTypeDevIOExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeDevIO;
	static const ACSErr::ErrorCode m_code = UnimplementedWrite;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	UnimplementedWriteExImpl(const UnimplementedWriteExImpl& ex) :
			ACSErrTypeDevIOExImpl(const_cast<UnimplementedWriteExImpl&>(ex).getErrorTrace()) {}
		
	UnimplementedWriteExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeDevIOExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	UnimplementedWriteExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeDevIOExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UnimplementedWriteExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeDevIOExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UnimplementedWriteExImpl (const ACSErrTypeDevIO::UnimplementedWriteEx & ex) : 
			ACSErrTypeDevIOExImpl(ex.errorTrace) {}
			
	ACSErrTypeDevIO::UnimplementedWriteEx getUnimplementedWriteEx () { return ACSErrTypeDevIO::UnimplementedWriteEx (getErrorTrace()); }
	
	template <class T >
	UnimplementedWriteExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeDevIOExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

}

#endif
