-- TMCDB SQL TABLE DEFINITIONS Version 2.1.13 2009-10-17T0022:30:10.0
--
-- /////////////////////////////////////////////////////////////////
-- // WARNING!  DO NOT MODIFY THIS FILE!                          //
-- //  ---------------------------------------------------------  //
-- // | This is generated code!  Do not modify this file.       | //
-- // | Any changes will be lost when the file is re-generated. | //
-- //  ---------------------------------------------------------  //
-- /////////////////////////////////////////////////////////////////
CREATE  TABLE TMCDBVersion (
    DBName LONGVARCHAR  NOT NULL 
,
    DBVersion LONGVARCHAR  NOT NULL 
,
    DBDate LONGVARCHAR  NOT NULL 
,
    CONSTRAINT TMCDBVersionKey PRIMARY KEY (DBName)
);
CREATE  TABLE ComponentType (
    ComponentTypeId INTEGER IDENTITY
,
    IDL VARCHAR (256)  NOT NULL 
,
    URN LONGVARCHAR  NULL 
,
	CONSTRAINT ComponTAltKey UNIQUE (IDL)
);
CREATE  TABLE LRUType (
    LRUName VARCHAR (128)  NOT NULL 
,
    FullName VARCHAR (256)  NOT NULL 
,
    ICD VARCHAR (256)  NOT NULL 
,
    ICDDate BIGINT  NOT NULL 
,
    Description LONGVARCHAR  NOT NULL 
,
    Notes LONGVARCHAR  NULL 
,
    CONSTRAINT LRUTypeKey PRIMARY KEY (LRUName)
);
CREATE  TABLE AssemblyType (
    AssemblyTypeName VARCHAR (256)  NOT NULL 
,
    BaseElementType LONGVARCHAR  NOT NULL 
,
    LRUName VARCHAR (128)  NOT NULL 
,
    FullName VARCHAR (256)  NOT NULL 
,
    Description LONGVARCHAR  NOT NULL 
,
    Notes LONGVARCHAR  NULL 
,
    ComponentTypeId INTEGER  NULL 
,
    Data LONGVARCHAR  NULL 
,
    CONSTRAINT AssemblyTypeKey PRIMARY KEY (AssemblyTypeName),
    CONSTRAINT AssemblyTypeLRUName FOREIGN KEY (LRUName) REFERENCES LRUType,
    CONSTRAINT AssemblyTypeBEType CHECK (BaseElementType IN ('Antenna', 'Pad', 'CorrHWConfiguration', 'FrontEnd', 'WeatherStation', 'CentralRack', 'MasterClock', 'HolographyTower', 'Array'))
);
CREATE  TABLE Schemas (
    SchemaId INTEGER IDENTITY
,
    URN LONGVARCHAR  NOT NULL 
,
    ConfigurationId INTEGER  NOT NULL 
,
    Schema LONGVARCHAR  NULL 
,
	CONSTRAINT SchemasAltKey UNIQUE (URN, ConfigurationId)
);
CREATE  TABLE DefaultComponent (
    DefaultComponentId INTEGER  NOT NULL 
,
    ComponentTypeId INTEGER  NOT NULL 
,
    AssemblyTypeName VARCHAR (256)  NOT NULL 
,
    ImplLang LONGVARCHAR  NOT NULL 
,
    RealTime BOOLEAN  NOT NULL 
,
    Code VARCHAR (256)  NOT NULL 
,
    Path VARCHAR (256)  NOT NULL 
,
    IsAutostart BOOLEAN  NOT NULL 
,
    IsDefault BOOLEAN  NOT NULL 
,
    IsStandaloneDefined BOOLEAN  NULL 
,
    KeepAliveTime INTEGER  NOT NULL 
,
    MinLogLevel TINYINT  DEFAULT -1
,
    MinLogLevelLocal TINYINT  DEFAULT -1
,
    XMLDoc LONGVARCHAR  NULL 
,
    CONSTRAINT DefaulCKey PRIMARY KEY (DefaultComponentId),
    CONSTRAINT DefaultComponentImplLang CHECK (ImplLang IN ('java', 'cpp', 'py')),
    CONSTRAINT DefaultComponentTypeId   FOREIGN KEY (ComponentTypeId)  REFERENCES ComponentType,
    CONSTRAINT DefaultComponentAssemblyId FOREIGN KEY (AssemblyTypeName) REFERENCES AssemblyType
);
CREATE  TABLE DefaultBaciProperty (
    DefaultBaciPropId INTEGER  NOT NULL 
,
    DefaultComponentId INTEGER  NOT NULL 
,
    PropertyName VARCHAR (128)  NOT NULL 
,
    description LONGVARCHAR  NOT NULL 
,
    format LONGVARCHAR  NOT NULL 
,
    units LONGVARCHAR  NOT NULL 
,
    resolution LONGVARCHAR  NOT NULL 
,
    archive_priority INTEGER  NOT NULL 
,
    archive_min_int DOUBLE  NOT NULL 
,
    archive_max_int DOUBLE  NOT NULL 
,
    default_timer_trig DOUBLE  NOT NULL 
,
    min_timer_trig DOUBLE  NOT NULL 
,
    initialize_devio BOOLEAN  NOT NULL 
,
    min_delta_trig DOUBLE  NULL 
,
    default_value LONGVARCHAR  NOT NULL 
,
    graph_min DOUBLE  NULL 
,
    graph_max DOUBLE  NULL 
,
    min_step DOUBLE  NULL 
,
    archive_delta DOUBLE  NOT NULL 
,
    alarm_high_on DOUBLE  NULL 
,
    alarm_low_on DOUBLE  NULL 
,
    alarm_high_off DOUBLE  NULL 
,
    alarm_low_off DOUBLE  NULL 
,
    alarm_timer_trig DOUBLE  NULL 
,
    min_value DOUBLE  NULL 
,
    max_value DOUBLE  NULL 
,
    bitDescription LONGVARCHAR  NULL 
,
    whenSet LONGVARCHAR  NULL 
,
    whenCleared LONGVARCHAR  NULL 
,
    statesDescription LONGVARCHAR  NULL 
,
    condition LONGVARCHAR  NULL 
,
    alarm_on LONGVARCHAR  NULL 
,
    alarm_off LONGVARCHAR  NULL 
,
    Data LONGVARCHAR  NULL 
,
    CONSTRAINT DefaulBPKey PRIMARY KEY (DefaultBaciPropId),
    CONSTRAINT DefBACIDefaultComponentTypeId   FOREIGN KEY (DefaultComponentId)  REFERENCES DefaultComponent
);
CREATE  TABLE DefaultMonitorPoint (
    DefaultMonitorPointId INTEGER  NOT NULL 
,
    DefaultBACIPropertyId INTEGER  NOT NULL 
,
    MonitorPointName VARCHAR (128)  NOT NULL 
,
    Indice INTEGER  NOT NULL 
,
    DataType LONGVARCHAR  NOT NULL 
,
    RCA LONGVARCHAR  NOT NULL 
,
    TeRelated BOOLEAN  NOT NULL 
,
    RawDataType LONGVARCHAR  NOT NULL 
,
    WorldDataType LONGVARCHAR  NOT NULL 
,
    Units LONGVARCHAR  NULL 
,
    Scale DOUBLE  NULL 
,
    Offset DOUBLE  NULL 
,
    MinRange LONGVARCHAR  NULL 
,
    MaxRange LONGVARCHAR  NULL 
,
    Description LONGVARCHAR  NOT NULL 
,
    CONSTRAINT DefaulMPKey PRIMARY KEY (DefaultMonitorPointId),
    CONSTRAINT DefaulPntId FOREIGN KEY (DefaultBACIPropertyId) REFERENCES DefaultBaciProperty
);
CREATE  TABLE Configuration (
    ConfigurationId INTEGER IDENTITY
,
    ConfigurationName VARCHAR (128)  NOT NULL 
,
    FullName VARCHAR (256)  NOT NULL 
,
    Active BOOLEAN  NOT NULL 
,
    CreationTime TIMESTAMP (6)  NOT NULL 
,
    Description LONGVARCHAR  NOT NULL 
,
	CONSTRAINT ConfigAltKey UNIQUE (ConfigurationName)
);
CREATE  TABLE Computer (
    ComputerId INTEGER IDENTITY
,
    ComputerName VARCHAR (256)  NOT NULL 
,
    ConfigurationId INTEGER  NOT NULL 
,
    HostName VARCHAR (256)  NOT NULL 
,
    RealTime BOOLEAN  NOT NULL 
,
    ProcessorType CHAR (3)  NOT NULL 
,
    PhysicalLocation LONGVARCHAR  NULL 
,
	CONSTRAINT ComputerAltKey UNIQUE (ComputerName, ConfigurationId),
    CONSTRAINT ComputerConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
    CONSTRAINT ComputerProcessorType CHECK (ProcessorType IN ('uni', 'smp'))
);
CREATE  TABLE LoggingConfig (
    LoggingConfigId INTEGER IDENTITY
,
    ConfigurationId INTEGER  NOT NULL 
,
    MinLogLevelDefault TINYINT  DEFAULT 2
,
    MinLogLevelLocalDefault TINYINT  DEFAULT 2
,
    CentralizedLogger LONGVARCHAR  DEFAULT 'Log'
,
    DispatchPacketSize TINYINT  DEFAULT 10
,
    ImmediateDispatchLevel TINYINT  DEFAULT 10
,
    FlushPeriodSeconds TINYINT  DEFAULT 10
,
    MaxLogQueueSize INTEGER  DEFAULT 1000
,
    CONSTRAINT LoggingConfigConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration
);
CREATE  TABLE NamedLoggerConfig (
    NamedLoggerConfigId INTEGER IDENTITY
,
    LoggingConfigId INTEGER  NOT NULL 
,
    Name LONGVARCHAR  NOT NULL 
,
    MinLogLevel TINYINT  DEFAULT 2
,
    MinLogLevelLocal TINYINT  DEFAULT 2
,
	CONSTRAINT NamedLCAltKey UNIQUE (LoggingConfigId, Name),
    CONSTRAINT NamedLoggerConfigLoggingConfig FOREIGN KEY (LoggingConfigId) REFERENCES LoggingConfig
);
CREATE  TABLE Manager (
    ManagerId INTEGER IDENTITY
,
    ConfigurationId INTEGER  NOT NULL 
,
    LoggingConfigId INTEGER  NOT NULL 
,
    Startup LONGVARCHAR  NULL 
,
    ServiceComponents LONGVARCHAR  NULL 
,
    Timeout INTEGER  DEFAULT 50
,
    ClientPingInterval INTEGER  DEFAULT 60
,
    AdministratorPingInterval INTEGER  DEFAULT 45
,
    ContainerPingInterval INTEGER  DEFAULT 30
,
    ServerThreads TINYINT  DEFAULT 10
,
    DeadlockTimeout INTEGER  DEFAULT 180
,
	CONSTRAINT ManagerAltKey UNIQUE (ConfigurationId, LoggingConfigId, Startup, ServiceComponents, Timeout, ClientPingInterval, AdministratorPingInterval, ContainerPingInterval, ServerThreads, DeadlockTimeout),
    CONSTRAINT ManagerLoggingConfig FOREIGN KEY (LoggingConfigId) REFERENCES LoggingConfig,
    CONSTRAINT ManagerConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration
);
CREATE  TABLE Container (
    ContainerId INTEGER IDENTITY
,
    ContainerName VARCHAR (256)  NOT NULL 
,
    Path VARCHAR (256)  NOT NULL 
,
    ConfigurationId INTEGER  NOT NULL 
,
    LoggingConfigId INTEGER  NOT NULL 
,
    ComputerId INTEGER  NULL 
,
    ImplLang LONGVARCHAR  NOT NULL 
,
    TypeModifiers LONGVARCHAR  NULL 
,
    RealTime BOOLEAN  DEFAULT FALSE
,
    RealTimeType LONGVARCHAR  DEFAULT 'NONE'
,
    KernelModuleLocation LONGVARCHAR  NULL 
,
    KernelModule LONGVARCHAR  NULL 
,
    AcsInstance TINYINT  DEFAULT 0
,
    CmdLineArgs LONGVARCHAR  NULL 
,
    KeepAliveTime INTEGER  DEFAULT -1
,
    ServerThreads TINYINT  DEFAULT 5
,
    ManagerRetry INTEGER  DEFAULT 10
,
    CallTimeout INTEGER  DEFAULT 240
,
    Recovery BOOLEAN  DEFAULT TRUE
,
    AutoloadSharedLibs LONGVARCHAR  NULL 
,
	CONSTRAINT ContainerAltKey UNIQUE (ContainerName, Path, ConfigurationId),
    CONSTRAINT ContainerConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
    CONSTRAINT ContainerLoggingConfig FOREIGN KEY (LoggingConfigId) REFERENCES LoggingConfig,
    CONSTRAINT ContainerImplLang CHECK (ImplLang IN ('java', 'cpp', 'py')),
    CONSTRAINT ContainerRealTimeType CHECK (RealTimeType IN ('NONE', 'ABM', 'CORR'))
);
CREATE  TABLE Component (
    ComponentId INTEGER IDENTITY
,
    ComponentTypeId INTEGER  NOT NULL 
,
    ComponentName VARCHAR (256)  NOT NULL 
,
    ConfigurationId INTEGER  NOT NULL 
,
    ContainerId INTEGER  NOT NULL 
,
    ImplLang LONGVARCHAR  NOT NULL 
,
    RealTime BOOLEAN  NOT NULL 
,
    Code VARCHAR (256)  NOT NULL 
,
    Path VARCHAR (256)  NOT NULL 
,
    IsAutostart BOOLEAN  NOT NULL 
,
    IsDefault BOOLEAN  NOT NULL 
,
    IsStandaloneDefined BOOLEAN  NULL 
,
    KeepAliveTime INTEGER  NOT NULL 
,
    MinLogLevel TINYINT  DEFAULT -1
,
    MinLogLevelLocal TINYINT  DEFAULT -1
,
    XMLDoc LONGVARCHAR  NULL 
,
	CONSTRAINT ComponentAltKey UNIQUE (Path, ComponentName, ConfigurationId),
    CONSTRAINT ComponentIDL FOREIGN KEY (ComponentTypeId) REFERENCES ComponentType,
    CONSTRAINT ComponentConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
    CONSTRAINT ComponentImplLang CHECK (ImplLang IN ('java', 'cpp', 'py'))
);
CREATE  TABLE Assembly (
    AssemblyId INTEGER IDENTITY
,
    AssemblyTypeName VARCHAR (256)  NOT NULL 
,
    ConfigurationId INTEGER  NOT NULL 
,
    SerialNumber VARCHAR (256)  NOT NULL 
,
    Data LONGVARCHAR  NULL 
,
	CONSTRAINT AssemblyAltKey UNIQUE (SerialNumber, ConfigurationId),
    CONSTRAINT AssemblyConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
    CONSTRAINT AssemblyName FOREIGN KEY (AssemblyTypeName) REFERENCES AssemblyType
);
CREATE  TABLE DefaultCanAddress (
    ComponentId INTEGER  NOT NULL 
,
    NodeAddress VARCHAR (16)  NOT NULL 
,
    ChannelNumber TINYINT  NOT NULL 
,
    BaseAddress VARCHAR (16)  NULL 
,
    CONSTRAINT DefaulCAKey PRIMARY KEY (ComponentId),
    CONSTRAINT DefCanAddComp FOREIGN KEY (ComponentId) REFERENCES Component
);
CREATE  TABLE AssemblyRole (
    RoleName VARCHAR (128)  NOT NULL 
,
    NodeAddress LONGVARCHAR  NOT NULL 
,
    ChannelNumber TINYINT  NOT NULL 
,
    BaseAddress LONGVARCHAR  NULL 
,
    AssemblyTypeName VARCHAR (256)  NOT NULL 
,
    CONSTRAINT AssemblyRoleKey PRIMARY KEY (RoleName),
    CONSTRAINT AssemblyRoleAssembly FOREIGN KEY (AssemblyTypeName) REFERENCES AssemblyType
);
CREATE  TABLE BACIProperty (
    BACIPropertyId INTEGER IDENTITY
,
    ComponentId INTEGER  NOT NULL 
,
    PropertyName VARCHAR (128)  NOT NULL 
,
    description LONGVARCHAR  NOT NULL 
,
    isSequence BOOLEAN  NOT NULL 
,
    format LONGVARCHAR  NOT NULL 
,
    units LONGVARCHAR  NOT NULL 
,
    resolution LONGVARCHAR  NOT NULL 
,
    archive_priority INTEGER  NOT NULL 
,
    archive_min_int DOUBLE  NOT NULL 
,
    archive_max_int DOUBLE  NOT NULL 
,
    default_timer_trig DOUBLE  NOT NULL 
,
    min_timer_trig DOUBLE  NOT NULL 
,
    initialize_devio BOOLEAN  NOT NULL 
,
    min_delta_trig DOUBLE  NULL 
,
    default_value LONGVARCHAR  NOT NULL 
,
    graph_min DOUBLE  NULL 
,
    graph_max DOUBLE  NULL 
,
    min_step DOUBLE  NULL 
,
    archive_delta DOUBLE  NOT NULL 
,
    alarm_high_on DOUBLE  NULL 
,
    alarm_low_on DOUBLE  NULL 
,
    alarm_high_off DOUBLE  NULL 
,
    alarm_low_off DOUBLE  NULL 
,
    alarm_timer_trig DOUBLE  NULL 
,
    min_value DOUBLE  NULL 
,
    max_value DOUBLE  NULL 
,
    bitDescription LONGVARCHAR  NULL 
,
    whenSet LONGVARCHAR  NULL 
,
    whenCleared LONGVARCHAR  NULL 
,
    statesDescription LONGVARCHAR  NULL 
,
    condition LONGVARCHAR  NULL 
,
    alarm_on LONGVARCHAR  NULL 
,
    alarm_off LONGVARCHAR  NULL 
,
    Data LONGVARCHAR  NULL 
,
	CONSTRAINT BACIPropertyAltKey UNIQUE (PropertyName, ComponentId),
    CONSTRAINT BACIPropertyCompId FOREIGN KEY (ComponentId) REFERENCES Component
);
CREATE  TABLE MonitorPoint (
    MonitorPointId INTEGER  NOT NULL 
,
    BACIPropertyId INTEGER  NOT NULL 
,
    MonitorPointName VARCHAR (128)  NOT NULL 
,
    AssemblyId INTEGER  NOT NULL 
,
    Indice INTEGER  NOT NULL 
,
    DataType LONGVARCHAR  NOT NULL 
,
    RCA LONGVARCHAR  NOT NULL 
,
    TeRelated BOOLEAN  NOT NULL 
,
    RawDataType LONGVARCHAR  NOT NULL 
,
    WorldDataType LONGVARCHAR  NOT NULL 
,
    Units LONGVARCHAR  NULL 
,
    Scale DOUBLE  NULL 
,
    Offset DOUBLE  NULL 
,
    MinRange LONGVARCHAR  NULL 
,
    MaxRange LONGVARCHAR  NULL 
,
    Description LONGVARCHAR  NOT NULL 
,
    CONSTRAINT MonitorPointKey PRIMARY KEY (MonitorPointId),
    CONSTRAINT MonitorPointAssemblyId FOREIGN KEY (AssemblyId) REFERENCES Assembly,
    CONSTRAINT MonitorPointDatatype CHECK (DataType IN ('float', 'double', 'boolean', 'string', 'integer', 'enum', 'clob')),
    CONSTRAINT MonitorPointBACIPropertyId FOREIGN KEY (BACIPropertyId) REFERENCES BACIProperty
);
CREATE  TABLE MonitorData (
    MonitorPointId INTEGER  NOT NULL 
,
    StartTime BIGINT  NOT NULL 
,
    EndTime BIGINT  NOT NULL 
,
    MonitorTS TIMESTAMP (6)  NOT NULL 
,
    SampleSize INTEGER  NOT NULL 
,
    MonitorClob LONGVARCHAR  NOT NULL 
,
    MinStat DOUBLE  NULL 
,
    MaxStat DOUBLE  NULL 
,
    MeanStat DOUBLE  NULL 
,
    StdDevStat DOUBLE  NULL 
,
    CONSTRAINT MonitorDataKey PRIMARY KEY (MonitorPointId, MonitorTS),
    CONSTRAINT MonitorDataMonitorPointId FOREIGN KEY (MonitorPointId) REFERENCES MonitorPoint
);
CREATE  TABLE BaseElement (
    BaseElementId INTEGER IDENTITY
,
    BaseType LONGVARCHAR  NOT NULL 
,
    BaseElementName LONGVARCHAR  NOT NULL 
,
    ConfigurationId INTEGER  NOT NULL 
,
	CONSTRAINT BaseElementAltKey UNIQUE (BaseElementName, ConfigurationId),
    CONSTRAINT BEConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
    CONSTRAINT BEType CHECK (BaseType IN ('Antenna', 'Pad', 'CorrHWConfiguration', 'FrontEnd', 'WeatherStation', 'CentralRack', 'MasterClock', 'HolographyTower', 'Array'))
);
CREATE  TABLE BaseElementOnline (
    BaseElementOnlineId INTEGER IDENTITY
,
    BaseElementId INTEGER  NOT NULL 
,
    ConfigurationId INTEGER  NOT NULL 
,
    StartTime BIGINT  NOT NULL 
,
    EndTime BIGINT  NULL 
,
    NormalTermination BOOLEAN  NOT NULL 
,
	CONSTRAINT BaseElOAltKey UNIQUE (BaseElementId, ConfigurationId, StartTime),
    CONSTRAINT BEOnlineId FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
    CONSTRAINT BEOnlineConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration
);
CREATE  TABLE Antenna (
    BaseElementId INTEGER  NOT NULL 
,
    AntennaName VARCHAR (128)  NULL 
,
    AntennaType LONGVARCHAR  NOT NULL 
,
    DishDiameter DOUBLE  NOT NULL 
,
    CommissionDate BIGINT  NOT NULL 
,
    XPosition DOUBLE  NOT NULL 
,
    YPosition DOUBLE  NOT NULL 
,
    ZPosition DOUBLE  NOT NULL 
,
    XOffset DOUBLE  NOT NULL 
,
    YOffset DOUBLE  NOT NULL 
,
    ZOffset DOUBLE  NOT NULL 
,
    ComponentId INTEGER  NOT NULL 
,
    CONSTRAINT AntennaKey PRIMARY KEY (BaseElementId),
    CONSTRAINT AntennaBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
    CONSTRAINT AntennaComponent FOREIGN KEY (ComponentId) REFERENCES Component,
    CONSTRAINT AntennaType CHECK (AntennaType IN ('VA', 'AEC', 'ACA'))
);
CREATE  TABLE Pad (
    BaseElementId INTEGER  NOT NULL 
,
    PadName VARCHAR (128)  NULL 
,
    CommissionDate BIGINT  NOT NULL 
,
    XPosition DOUBLE  NOT NULL 
,
    YPosition DOUBLE  NOT NULL 
,
    ZPosition DOUBLE  NOT NULL 
,
    CONSTRAINT PadKey PRIMARY KEY (BaseElementId),
    CONSTRAINT PadBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement
);
CREATE  TABLE CorrHWConfiguration (
    BaseElementId INTEGER  NOT NULL 
,
    CorrHWName VARCHAR (128)  NOT NULL 
,
    CorrHWType LONGVARCHAR  NOT NULL 
,
    CONSTRAINT CorrHWCKey PRIMARY KEY (BaseElementId),
    CONSTRAINT CorrHWBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
    CONSTRAINT CorrelatorHWType CHECK (CorrHWType IN ('CORRELATOR_12m_2ANTS','CORRELATOR_12m_1QUADRANT','CORRELATOR_12m_2QUADRANT','CORRELATOR_12m_4QUADRANT'))
);
CREATE  TABLE CorrQuadrant (
    CorrQuadrantId INTEGER IDENTITY
,
    CorrHWConfigId INTEGER  NOT NULL 
,
    BaseElementId INTEGER  NOT NULL 
,
    CorrName VARCHAR (128)  NOT NULL 
,
    Quadrant TINYINT  NOT NULL 
,
    ChannelNumber TINYINT  NOT NULL 
,
    NumberOfAntennas TINYINT  NOT NULL 
,
    CommissionDate BIGINT  NOT NULL 
,
    ComponentId INTEGER  NOT NULL 
,
    NumberOfRacks TINYINT  NOT NULL 
,
    NumberOfBins TINYINT  NOT NULL 
,
    Active BOOLEAN  NOT NULL 
,
	CONSTRAINT CorrQuadrantAltKey UNIQUE (CorrName, Quadrant, BaseElementId),
    CONSTRAINT CorrHWConfig FOREIGN KEY (BaseElementId) REFERENCES CorrHWConfiguration,
    CONSTRAINT CorrQuadNumber CHECK (Quadrant IN ('0', '1', '2', '3'))
);
CREATE  TABLE CorrQuadrantRack (
    CorrQuadrantRackId INTEGER IDENTITY
,
    CorrQuadrantId INTEGER  NOT NULL 
,
    RackName VARCHAR (128)  NOT NULL 
,
    RackType LONGVARCHAR  NOT NULL 
,
    NumberOfBins TINYINT  NOT NULL 
,
    Active BOOLEAN  NOT NULL 
,
	CONSTRAINT CorrQuRAltKey UNIQUE (RackName, CorrQuadrantId),
    CONSTRAINT CorrRackType CHECK (RackType IN ('Station', 'Correlator')),
    CONSTRAINT CorrQuad FOREIGN KEY (CorrQuadrantId) REFERENCES CorrQuadrant
);
CREATE  TABLE CorrStationBin (
    CorrStationBinId INTEGER IDENTITY
,
    CorrQuadrantRackId INTEGER  NOT NULL 
,
    StationBinName VARCHAR (128)  NOT NULL 
,
    StationNodeAddr INTEGER  NOT NULL 
,
    NumberOfStationCards SMALLINT  NOT NULL 
,
    NumberOfTFBCards SMALLINT  NOT NULL 
,
    NumberOfDRXCards SMALLINT  NOT NULL 
,
    NumberOfInterfaceCards SMALLINT  NOT NULL 
,
    NumberOfPSCards SMALLINT  NOT NULL 
,
    Active BOOLEAN  NOT NULL 
,
	CONSTRAINT CorrStBAltKey UNIQUE (StationBinName, CorrQuadrantRackId),
    CONSTRAINT CorrRack FOREIGN KEY (CorrQuadrantRackId) REFERENCES CorrQuadrantRack
);
CREATE  TABLE CorrelatorBin (
    CorrelatorBinId INTEGER IDENTITY
,
    CorrQuadrantRackId INTEGER  NOT NULL 
,
    CorrelatorBinName VARCHAR (128)  NOT NULL 
,
    LTANodeAddr INTEGER  NOT NULL 
,
    NumberOfCorrelatorCards SMALLINT  NOT NULL 
,
    NumberOfInterfaceCards SMALLINT  NOT NULL 
,
    NumberOfPSCards SMALLINT  NOT NULL 
,
    Active BOOLEAN  NOT NULL 
,
	CONSTRAINT CorrelBAltKey UNIQUE (CorrelatorBinName, CorrQuadrantRackId),
    CONSTRAINT CorrStationRack FOREIGN KEY (CorrQuadrantRackId) REFERENCES CorrQuadrantRack
);
CREATE  TABLE FrontEnd (
    BaseElementId INTEGER  NOT NULL 
,
    CommissionDate BIGINT  NOT NULL 
,
    ComponentId INTEGER  NOT NULL 
,
    CONSTRAINT FrontEndKey PRIMARY KEY (BaseElementId),
    CONSTRAINT FrontEndBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
    CONSTRAINT FrontEndComponent FOREIGN KEY (ComponentId) REFERENCES Component
);
CREATE  TABLE WeatherStation (
    BaseElementId INTEGER  NOT NULL 
,
    SerialNumber VARCHAR (128)  NOT NULL 
,
    WeatherStationType VARCHAR (128)  NOT NULL 
,
    CommissionDate BIGINT  NOT NULL 
,
    XPosition DOUBLE  NOT NULL 
,
    YPosition DOUBLE  NOT NULL 
,
    ZPosition DOUBLE  NOT NULL 
,
    ComponentId INTEGER  NOT NULL 
,
    CONSTRAINT WeatheSKey PRIMARY KEY (BaseElementId),
    CONSTRAINT WeatherStationComponent FOREIGN KEY (ComponentId) REFERENCES Component,
    CONSTRAINT WeatherStationBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement
);
CREATE  TABLE CentralRack (
    BaseElementId INTEGER  NOT NULL 
,
    CommissionDate BIGINT  NOT NULL 
,
    ComponentId INTEGER  NOT NULL 
,
    CONSTRAINT CentralRackKey PRIMARY KEY (BaseElementId),
    CONSTRAINT CentralRackComponent FOREIGN KEY (ComponentId) REFERENCES Component,
    CONSTRAINT CentralRackBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement
);
CREATE  TABLE MasterClock (
    BaseElementId INTEGER  NOT NULL 
,
    CommissionDate BIGINT  NOT NULL 
,
    ComponentId INTEGER  NOT NULL 
,
    CONSTRAINT MasterClockKey PRIMARY KEY (BaseElementId),
    CONSTRAINT MasterClockComponent FOREIGN KEY (ComponentId) REFERENCES Component,
    CONSTRAINT MasterClockBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement
);
CREATE  TABLE HolographyTower (
    BaseElementId INTEGER  NOT NULL 
,
    CommissionDate BIGINT  NOT NULL 
,
    XPosition DOUBLE  NOT NULL 
,
    YPosition DOUBLE  NOT NULL 
,
    ZPosition DOUBLE  NOT NULL 
,
    CONSTRAINT HologrTKey PRIMARY KEY (BaseElementId),
    CONSTRAINT HolographyTowerBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement
);
CREATE  TABLE Array (
    ArrayId INTEGER IDENTITY
,
    BaseElementId INTEGER  NOT NULL 
,
    Type LONGVARCHAR  NOT NULL 
,
    UserId VARCHAR (256)  NULL 
,
    StartTime BIGINT  NOT NULL 
,
    EndTime BIGINT  NULL 
,
    NormalTermination BOOLEAN  NOT NULL 
,
    ComponentId INTEGER  NOT NULL 
,
	CONSTRAINT ArrayAltKey UNIQUE (StartTime, BaseElementId),
    CONSTRAINT ArrayComponent FOREIGN KEY (ComponentId) REFERENCES Component,
    CONSTRAINT ArrayBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
    CONSTRAINT ArrayType CHECK (Type IN ('automatic', 'manual'))
);
CREATE  TABLE AntennaToPad (
    AntennaId INTEGER  NOT NULL 
,
    PadId INTEGER  NOT NULL 
,
    StartTime BIGINT  NOT NULL 
,
    EndTime BIGINT  NULL 
,
    Planned BOOLEAN  NOT NULL 
,
    CONSTRAINT AntennaToPadKey PRIMARY KEY (AntennaId, PadId, StartTime),
    CONSTRAINT AntennaToPadAntennaId FOREIGN KEY (AntennaId) REFERENCES Antenna,
    CONSTRAINT AntennaToPadPadId FOREIGN KEY (PadId) REFERENCES Pad
);
CREATE  TABLE AntennaPointingModel (
    PointingModelId INTEGER IDENTITY
,
    AntennaId INTEGER  NOT NULL 
,
    PadId INTEGER  NOT NULL 
,
    ReceiverBand VARCHAR (128)  NOT NULL 
,
    StartTime BIGINT  NOT NULL 
,
    StartValidTime BIGINT  NOT NULL 
,
    EndValidTime BIGINT  NULL 
,
    AsdmUID VARCHAR (256)  NOT NULL 
,
	CONSTRAINT AntennPMAltKey UNIQUE (AntennaId, PadId, ReceiverBand, StartValidTime),
    CONSTRAINT AntennaPMAntToPad FOREIGN KEY (AntennaId, PadId, StartTime) REFERENCES AntennaToPad,
    CONSTRAINT AntennaPMBand CHECK (ReceiverBand IN ('band1', 'band2', 'band3', 'band4', 'band5', 'band6', 'band7', 'band8', 'band9', 'band10'))
);
CREATE  TABLE AntennaPointingModelTerm (
    PointingModelId INTEGER  NOT NULL 
,
    CoeffName VARCHAR (128)  NOT NULL 
,
    CoeffValue FLOAT  NOT NULL 
,
    CoeffError FLOAT  NOT NULL 
,
    CONSTRAINT AntennPMTKey PRIMARY KEY (PointingModelId, CoeffName),
    CONSTRAINT AntPMTermPointingModelId FOREIGN KEY (PointingModelId) REFERENCES AntennaPointingModel
);
CREATE  TABLE AntennaFocusModel (
    FocusModelId INTEGER IDENTITY
,
    AntennaId INTEGER  NOT NULL 
,
    ReceiverBand VARCHAR (128)  NOT NULL 
,
    StartValidTime BIGINT  NOT NULL 
,
    EndValidTime BIGINT  NULL 
,
    AsdmUID VARCHAR (256)  NOT NULL 
,
	CONSTRAINT AntennFMAltKey UNIQUE (AntennaId, ReceiverBand, StartValidTime),
    CONSTRAINT AntennaFPMAntennaId FOREIGN KEY (AntennaId) REFERENCES Antenna,
    CONSTRAINT AntennaFMBand CHECK (ReceiverBand IN ('band1', 'band2', 'band3', 'band4', 'band5', 'band6', 'band7', 'band8', 'band9', 'band10'))
);
CREATE  TABLE AntennaFocusModelTerm (
    FocusModelId INTEGER  NOT NULL 
,
    CoeffName VARCHAR (128)  NOT NULL 
,
    CoeffValue FLOAT  NOT NULL 
,
    CoeffError FLOAT  NOT NULL 
,
    CONSTRAINT AntennFMTKey PRIMARY KEY (FocusModelId, CoeffName),
    CONSTRAINT AntFMTermFocusModelId FOREIGN KEY (FocusModelId) REFERENCES AntennaFocusModel
);
CREATE  TABLE AntennaDelayModel (
    DelayModelId INTEGER IDENTITY
,
    AntennaId INTEGER  NOT NULL 
,
    PadId INTEGER  NOT NULL 
,
    ReceiverBand VARCHAR (128)  NOT NULL 
,
    StartTime BIGINT  NOT NULL 
,
    StartValidTime BIGINT  NOT NULL 
,
    EndValidTime BIGINT  NULL 
,
    AsdmUID VARCHAR (256)  NOT NULL 
,
	CONSTRAINT AntennDMAltKey UNIQUE (AntennaId, PadId, ReceiverBand, StartValidTime),
    CONSTRAINT AntennaDMAntToPad FOREIGN KEY (AntennaId, PadId, StartTime) REFERENCES AntennaToPad
);
CREATE  TABLE AntennaDelayModelTerm (
    DelayModelId INTEGER  NOT NULL 
,
    CoeffName VARCHAR (128)  NOT NULL 
,
    CoeffValue DOUBLE  NOT NULL 
,
    CoeffError DOUBLE  NOT NULL 
,
    CONSTRAINT AntennDMTKey PRIMARY KEY (DelayModelId, CoeffName),
    CONSTRAINT DelayTermDelayModelId FOREIGN KEY (DelayModelId) REFERENCES AntennaDelayModel
);
CREATE  TABLE AntennaToFrontEnd (
    AntennaId INTEGER  NOT NULL 
,
    FrontEndId INTEGER  NOT NULL 
,
    StartTime BIGINT  NOT NULL 
,
    EndTime BIGINT  NULL 
,
    CONSTRAINT AntennTFEKey PRIMARY KEY (AntennaId, FrontEndId, StartTime),
    CONSTRAINT AntennaToFEAntennaId FOREIGN KEY (AntennaId) REFERENCES Antenna,
    CONSTRAINT AntennaToFEFrontEndId FOREIGN KEY (FrontEndId) REFERENCES FrontEnd
);
CREATE  TABLE AntennaToArray (
    AntennaId INTEGER  NOT NULL 
,
    ArrayId INTEGER  NOT NULL 
,
    CONSTRAINT AntennTAKey PRIMARY KEY (AntennaId, ArrayId),
    CONSTRAINT AntennaToArrayAntennaId FOREIGN KEY (AntennaId) REFERENCES Antenna,
    CONSTRAINT AntennaToArrayArrayid FOREIGN KEY (ArrayId) REFERENCES Array
);
CREATE  TABLE SBExecution (
    ArrayId INTEGER  NOT NULL 
,
    SbUID VARCHAR (256)  NOT NULL 
,
    StartTime BIGINT  NOT NULL 
,
    EndTime BIGINT  NULL 
,
    NormalTermination BOOLEAN  NOT NULL 
,
    CONSTRAINT SBExecutionKey PRIMARY KEY (ArrayId, SbUID, StartTime),
    CONSTRAINT SBExecutionArrayId FOREIGN KEY (ArrayId) REFERENCES Array
);
CREATE  TABLE AntennaToCorr (
    AntennaId INTEGER  NOT NULL 
,
    CorrId INTEGER  NOT NULL 
,
    AntennaNumber TINYINT  NOT NULL 
,
    StartTime BIGINT  NOT NULL 
,
    EndTime BIGINT  NULL 
,
    CONSTRAINT AntennTCKey PRIMARY KEY (AntennaId, CorrId, StartTime),
    CONSTRAINT AntToCorrAntennaId FOREIGN KEY (AntennaId) REFERENCES Antenna,
    CONSTRAINT AntToCorrId FOREIGN KEY (CorrId) REFERENCES CorrQuadrant
);
CREATE  TABLE WeatherStationToPad (
    WeatherStationId INTEGER  NOT NULL 
,
    PadId INTEGER  NOT NULL 
,
    StartTime BIGINT  NOT NULL 
,
    EndTime BIGINT  NULL 
,
    Planned BOOLEAN  NOT NULL 
,
    CONSTRAINT WeatheSTPKey PRIMARY KEY (WeatherStationId, PadId, StartTime),
    CONSTRAINT WSToPadWeatherStationId FOREIGN KEY (WeatherStationId) REFERENCES WeatherStation,
    CONSTRAINT WSToPadPadId FOREIGN KEY (PadId) REFERENCES Pad
);
CREATE  TABLE BaseElementAssemblyList (
    AssemblyId INTEGER  NOT NULL 
,
    BaseElementOnlineId INTEGER  NOT NULL 
,
    GroupName VARCHAR (128)  NULL 
,
    OrderTag SMALLINT  NULL 
,
    ComponentId INTEGER  NOT NULL 
,
    RoleName VARCHAR (128)  NULL 
,
    ChannelNumber TINYINT  NULL 
,
    NodeAddress LONGVARCHAR  NULL 
,
    BaseAddress LONGVARCHAR  NULL 
,
    CONSTRAINT BaseElALKey PRIMARY KEY (AssemblyId, BaseElementOnlineId),
    CONSTRAINT BEAssemblyListId FOREIGN KEY (BaseElementOnlineId) REFERENCES BaseElementOnline,
    CONSTRAINT BEAssemblyListAssemblyId FOREIGN KEY (AssemblyId) REFERENCES Assembly,
    CONSTRAINT BEAssemblyListComponentId FOREIGN KEY (ComponentId) REFERENCES Component
);
CREATE  TABLE MasterComponent (
    MasterComponentId INTEGER IDENTITY
,
    ComponentId INTEGER  NOT NULL 
,
    ConfigurationId INTEGER  NOT NULL 
,
    SubsystemName VARCHAR (256)  NOT NULL 
,
	CONSTRAINT MasterCAltKey UNIQUE (ComponentId, ConfigurationId),
    CONSTRAINT MComponentConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
    CONSTRAINT MComponentId FOREIGN KEY (ComponentId) REFERENCES Component
);
CREATE  TABLE ComputerExecution (
    ComputerExecutionId INTEGER IDENTITY
,
    ComputerId INTEGER  NOT NULL 
,
    ConfigurationId INTEGER  NOT NULL 
,
    StartTime BIGINT  NOT NULL 
,
    EndTime BIGINT  NULL 
,
    NormalStart BOOLEAN  NOT NULL 
,
    NormalTermination BOOLEAN  NOT NULL 
,
	CONSTRAINT ComputEAltKey UNIQUE (ComputerId, ConfigurationId, StartTime),
    CONSTRAINT ComputerExecConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
    CONSTRAINT ComputerExecComputer FOREIGN KEY (ComputerId) REFERENCES Computer
);
CREATE  TABLE ContainerExecution (
    ContainerExecutionId INTEGER IDENTITY
,
    ContainerId INTEGER  NOT NULL 
,
    ConfigurationId INTEGER  NOT NULL 
,
    ComputerId INTEGER  NOT NULL 
,
    StartTime BIGINT  NOT NULL 
,
    EndTime BIGINT  NULL 
,
    NormalStart BOOLEAN  NOT NULL 
,
    NormalTermination BOOLEAN  NOT NULL 
,
	CONSTRAINT ContaiEAltKey UNIQUE (ContainerId, ComputerId, StartTime, ConfigurationId),
    CONSTRAINT ContainerExecConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
    CONSTRAINT ContainerExecContainer FOREIGN KEY (ContainerId) REFERENCES Container,
    CONSTRAINT ContainerExecComputer FOREIGN KEY (ComputerId) REFERENCES Computer
);
CREATE  TABLE ComponentExecution (
    ComponentExecutionId INTEGER IDENTITY
,
    ComponentExecutionAcsId BIGINT  NOT NULL 
,
    ComponentId INTEGER  NOT NULL 
,
    ConfigurationId INTEGER  NOT NULL 
,
    ContainerId INTEGER  NOT NULL 
,
    StartTime BIGINT  NOT NULL 
,
    EndTime BIGINT  NULL 
,
    NormalStart BOOLEAN  NOT NULL 
,
    NormalTermination BOOLEAN  NOT NULL 
,
    BaseElementOnlineId INTEGER  NULL 
,
    AssemblyId INTEGER  NULL 
,
	CONSTRAINT ComponEAltKey UNIQUE (ComponentId, StartTime, ConfigurationId),
    CONSTRAINT ComponentExecConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
    CONSTRAINT ComponentExecComponent FOREIGN KEY (ComponentId) REFERENCES Component,
    CONSTRAINT ComponentExecContainer FOREIGN KEY (ContainerId) REFERENCES Container,
    CONSTRAINT ComponentExecBaseElement FOREIGN KEY (BaseElementOnlineId) REFERENCES BaseElementOnline,
    CONSTRAINT ComponentExecAssembly FOREIGN KEY (AssemblyId) REFERENCES Assembly
);
CREATE  TABLE MasterComponentExecution (
    MasterComponentExecId INTEGER IDENTITY
,
    MasterComponentId INTEGER  NOT NULL 
,
    ConfigurationId INTEGER  NOT NULL 
,
    ContainerId INTEGER  NOT NULL 
,
    StartTime BIGINT  NOT NULL 
,
    EndTime BIGINT  NULL 
,
    NormalStart BOOLEAN  NOT NULL 
,
    NormalTermination BOOLEAN  NOT NULL 
,
	CONSTRAINT MasterCEAltKey UNIQUE (MasterComponentId, ContainerId, StartTime, ConfigurationId),
    CONSTRAINT MComponentExecConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
    CONSTRAINT MComponentExecComponent FOREIGN KEY (MasterComponentId) REFERENCES MasterComponent,
    CONSTRAINT MComponentExecContainer FOREIGN KEY (ContainerId) REFERENCES Container
);
CREATE  TABLE ACS (
    ACSId INTEGER IDENTITY
,
    ACSVersion VARCHAR (256)  NOT NULL 
,
    ConfigurationId INTEGER  NOT NULL 
,
    ComputerId INTEGER  NOT NULL 
,
    Var1 VARCHAR (256)  NULL 
,
    Var2 VARCHAR (256)  NULL 
,
    Var3 VARCHAR (256)  NULL 
,
	CONSTRAINT ACSAltKey UNIQUE (ACSVersion, ConfigurationId, ComputerId),
    CONSTRAINT ACSComputer FOREIGN KEY (ComputerId) REFERENCES Computer,
    CONSTRAINT ACSConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration
);
CREATE  TABLE ACSExecution (
    ACSId INTEGER  NOT NULL 
,
    ConfigurationId INTEGER  NOT NULL 
,
    StartTime BIGINT  NOT NULL 
,
    EndTime BIGINT  NULL 
,
    NormalStart BOOLEAN  NOT NULL 
,
    NormalTermination BOOLEAN  NOT NULL 
,
    CONSTRAINT ACSExecutionKey PRIMARY KEY (ACSId, ConfigurationId, StartTime),
    CONSTRAINT ACSExecACS FOREIGN KEY (ACSId) REFERENCES ACS,
    CONSTRAINT ACSExecConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration
);
CREATE  TABLE NotificationChannel (
    NCId INTEGER IDENTITY
,
    NCName VARCHAR (256)  NOT NULL 
,
    SubsystemName VARCHAR (256)  NOT NULL 
,
    ConfigurationId INTEGER  NOT NULL 
,
    QOS1 VARCHAR (256)  NULL 
,
    QOS2 VARCHAR (256)  NULL 
,
    QOS3 VARCHAR (256)  NULL 
,
	CONSTRAINT NotifiCAltKey UNIQUE (NCName, ConfigurationId),
    CONSTRAINT NCConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration
);
CREATE  TABLE NCExecution (
    NCId INTEGER  NOT NULL 
,
    ACSId INTEGER  NOT NULL 
,
    ConfigurationId INTEGER  NOT NULL 
,
    StartTime BIGINT  NOT NULL 
,
    EndTime BIGINT  NULL 
,
    NormalStart BOOLEAN  NOT NULL 
,
    NormalTermination BOOLEAN  NOT NULL 
,
    CONSTRAINT NCExecutionKey PRIMARY KEY (NCId, ConfigurationId, StartTime),
    CONSTRAINT NCExecNC FOREIGN KEY (NCId) REFERENCES NotificationChannel,
    CONSTRAINT NCExecConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
    CONSTRAINT NCExecACS FOREIGN KEY (ACSId) REFERENCES ACS
);
CREATE  TABLE Startup (
    StartupId INTEGER IDENTITY
,
    ConfigurationId INTEGER  NOT NULL 
,
    StartupName VARCHAR (256)  NOT NULL 
,
	CONSTRAINT StartupAltKey UNIQUE (StartupName, ConfigurationId),
    CONSTRAINT StartupConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration
);
CREATE  TABLE SystemExecution (
    StartupId INTEGER  NOT NULL 
,
    ConfigurationId INTEGER  NOT NULL 
,
    StartTime BIGINT  NOT NULL 
,
    EndTime BIGINT  NULL 
,
    NormalStart BOOLEAN  NOT NULL 
,
    NormalTermination BOOLEAN  NOT NULL 
,
    CONSTRAINT SystemEKey PRIMARY KEY (StartupId, ConfigurationId, StartTime),
    CONSTRAINT SystemExecConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
    CONSTRAINT SystemExecStartupId FOREIGN KEY (StartupId) REFERENCES Startup
);
CREATE  TABLE DeploymentStartup (
    Name VARCHAR (256)  NOT NULL 
,
    Path VARCHAR (256)  NOT NULL 
,
    StartupType LONGVARCHAR  NOT NULL 
,
    StartupId INTEGER  NOT NULL 
,
    DependsOnName VARCHAR (256)  NULL 
,
    DependsOnPath VARCHAR (256)  NULL 
,
    DependsOnType LONGVARCHAR  NULL 
,
    CONSTRAINT DeploySKey PRIMARY KEY (Name, Path, StartupType, StartupId),
    CONSTRAINT DeployStartupId FOREIGN KEY (StartupId) REFERENCES Startup,
    CONSTRAINT DeployStartupType CHECK (StartupType IN ('ACS', 'computer', 'container', 'component')),
    CONSTRAINT DeployDependsOnType CHECK (DependsOnType IN ('computer', 'container'))
);
CREATE  TABLE BaseElementStartup (
    BaseElementStartupId INTEGER IDENTITY
,
    BaseElementId INTEGER  NULL 
,
    StartupId INTEGER  NULL 
,
    BaseElementType VARCHAR (24)  NOT NULL 
,
    Parent INTEGER  NULL 
,
    IsGeneric VARCHAR (5)  NOT NULL 
,
	CONSTRAINT BaseElSAltKey UNIQUE (StartupId, BaseElementId, Parent, BaseElementType),
    CONSTRAINT BEStartupId FOREIGN KEY (StartupId) REFERENCES Startup,
    CONSTRAINT BEStartupIdBE FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
    CONSTRAINT BEStartupParent FOREIGN KEY (Parent) REFERENCES BaseElementStartup,
    CONSTRAINT BEStartupBEType CHECK (BaseElementType IN ('Antenna', 'Pad', 'CorrHWConfiguration', 'FrontEnd', 'WeatherStation', 'CentralRack', 'MasterClock', 'HolographyTower', 'Array'))
);
CREATE  TABLE AssociatedBaseElement (
    BaseElementId INTEGER  NOT NULL 
,
    StartupId INTEGER  NOT NULL 
,
    AssociatedId INTEGER  NOT NULL 
,
    AssociationType LONGVARCHAR  NOT NULL 
,
    CONSTRAINT AssociBEKey PRIMARY KEY (BaseElementId, StartupId, AssociatedId),
    CONSTRAINT ABEStartupIdBE FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
    CONSTRAINT ABEStartupId FOREIGN KEY (StartupId) REFERENCES Startup,
    CONSTRAINT ABEAssociated FOREIGN KEY (AssociatedId) REFERENCES BaseElement,
    CONSTRAINT ABEAssociationType CHECK (AssociationType IN ('AntennaToPad', 'AntennaToFrontEnd', 'AntennaToCorr'))
);
CREATE  TABLE AssemblyStartup (
    AssemblyStartupId INTEGER IDENTITY
,
    RoleName VARCHAR (128)  NOT NULL 
,
    ComponentId INTEGER  NOT NULL 
,
    BaseElementStartupId INTEGER  NOT NULL 
,
	CONSTRAINT AssembSAltKey UNIQUE (BaseElementStartupId, RoleName),
    CONSTRAINT AssemblyStartupComponent FOREIGN KEY (ComponentId) REFERENCES Component,
    CONSTRAINT AssemblyStartupRole FOREIGN KEY (RoleName) REFERENCES AssemblyRole,
    CONSTRAINT AssemblyStartupBEStartup FOREIGN KEY (BaseElementStartupId) REFERENCES BaseElementStartup
);
CREATE  TABLE SystemCounters (
    ConfigurationId INTEGER  NOT NULL 
,
    UpdateTime BIGINT  NOT NULL 
,
    AutoArrayCount SMALLINT  NOT NULL 
,
    ManArrayCount SMALLINT  NOT NULL 
,
    DataCaptureCount SMALLINT  NOT NULL 
,
    CONSTRAINT SystemCKey PRIMARY KEY (ConfigurationId),
    CONSTRAINT SystemCountersConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration
);
CREATE  TABLE Location (
    LocationId INTEGER IDENTITY
,
    Building VARCHAR (256)  NULL 
,
    Floor VARCHAR (128)  NULL 
,
    Room VARCHAR (256)  NULL 
,
    Mnemonic VARCHAR (256)  NULL 
,
    LocationPosition VARCHAR (256)  NULL 
,
	CONSTRAINT LocationAltKey UNIQUE (Building, Floor, Room, Mnemonic, LocationPosition)
);
CREATE  TABLE Contact (
    ContactId INTEGER IDENTITY
,
    ContactName VARCHAR (256)  NOT NULL 
,
    Email VARCHAR (256)  NULL 
,
    Gsm VARCHAR (256)  NULL 
,
	CONSTRAINT ContactAltKey UNIQUE (ContactName)
);
CREATE  TABLE AlarmCategory (
    AlarmCategoryName VARCHAR (128)  NOT NULL 
,
    Description LONGVARCHAR  NOT NULL 
,
    Path VARCHAR (256)  NOT NULL 
,
    IsDefault BOOLEAN  NOT NULL 
,
    CONSTRAINT AlarmCKey PRIMARY KEY (AlarmCategoryName)
);
CREATE  TABLE FaultFamily (
    FaultFamilyId INTEGER IDENTITY
,
    FamilyName VARCHAR (256)  NOT NULL 
,
    AlarmCategoryName VARCHAR (128)  NULL 
,
    AlarmSource VARCHAR (256)  DEFAULT 'ALARM_SYSTEM_SOURCES'
,
    HelpURL VARCHAR (256)  NULL 
,
    ContactId INTEGER  NOT NULL 
,
	CONSTRAINT FaultFamilyAltKey UNIQUE (FamilyName),
    CONSTRAINT FaultFamilyContact FOREIGN KEY (ContactId) REFERENCES Contact,
    CONSTRAINT FaultFamilyCategoryName FOREIGN KEY (AlarmCategoryName) REFERENCES AlarmCategory
);
CREATE  TABLE FaultMember (
    MemberName VARCHAR (256)  NOT NULL 
,
    FaultFamilyId INTEGER  NOT NULL 
,
    LocationId INTEGER  NULL 
,
    CONSTRAINT FaultMemberKey PRIMARY KEY (MemberName),
    CONSTRAINT MemberFaultFamilyRef FOREIGN KEY (FaultFamilyId) REFERENCES FaultFamily,
    CONSTRAINT LocationRef FOREIGN KEY (LocationId) REFERENCES Location
);
CREATE  TABLE DefaultMember (
    DefaultMemberId INTEGER  NOT NULL 
,
    FaultFamilyId INTEGER  NOT NULL 
,
    LocationID INTEGER  NULL 
,
    CONSTRAINT DefaulMKey PRIMARY KEY (DefaultMemberId),
    CONSTRAINT DefaultMemberFaultFamilyRef FOREIGN KEY (FaultFamilyId) REFERENCES FaultFamily,
    CONSTRAINT DefaultMemberLocationRef FOREIGN KEY (LocationId) REFERENCES Location
);
CREATE  TABLE FaultCode (
    FaultCodeId INTEGER IDENTITY
,
    FaultFamilyId INTEGER  NOT NULL 
,
    CodeValue INTEGER  NOT NULL 
,
    Priority INTEGER  NOT NULL 
,
    Cause VARCHAR (256)  NULL 
,
    Action LONGVARCHAR  NULL 
,
    Consequence LONGVARCHAR  NULL 
,
    ProblemDescription LONGVARCHAR  NOT NULL 
,
    IsInstant BOOLEAN  NOT NULL 
,
	CONSTRAINT FaultCodeAltKey UNIQUE (FaultFamilyId, CodeValue),
    CONSTRAINT CodeFaultFamilyRef FOREIGN KEY (FaultFamilyId) REFERENCES FaultFamily,
    CONSTRAINT PriorityValue CHECK (Priority IN (0,1,2,3))
);
INSERT INTO TMCDBVersion VALUES ('TMCDB','2.1.13','2009-10-17T0022:30:10.0');
COMMIT;
