/*******************************************************************************
*
* "@(#) $Id: rtlogTimeStampingTest.c,v 1.2 2007/10/11 13:43:30 bjeram Exp $"
*
* ALMA - Atacama Large Millimiter Array
* (c) Associated Universities Inc., 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* who       when        what
* --------  --------    ----------------------------------------------
* ramestic  2004-03-03  created
*/

/* 
 * System Headers
 */
#include <linux/kernel.h>
#include <linux/module.h>

/*
 * RTAI specific
 */
#include <rtai_lxrt.h>

/* 
 * Local Headers
 */
#include "rtLog.h"

MODULE_AUTHOR("Rodrigo Amestica");
MODULE_DESCRIPTION("rtlog time stamping test");
MODULE_LICENSE("GPL");

/*
 * global variables
 */
RT_TASK	task;

#define modName "rtlogTimeStampingTest"
#define N       10

void test_task(long not_used)
{
    int i;
    rtLogTimeData_t rtlogData;
    RTIME last, now;
    rtlogRecord_t logRecord;

    RTLOG(modName, RTLOG_INFO, "task started...");

    /*
     * set dummy time data
     */
    rtlogData.t0 = 122192928000000000LL + 480000LL; /* 1970.. + 48ms */
    rtlogData.ticks = 1;
    rtlogData.cpu_on_last_te = rt_get_time();
    rtlogData.cpu_hz = CPU_FREQ;
    setRtLogTimeData(rtlogData);

    for ( i = 0; i < N; i++)
    {
        last = rt_get_time_ns();
        rt_sleep(nano2count(48000000LL));
        now = rt_get_time_ns();

        RTLOG(modName, RTLOG_INFO, "diff=%lld[ns]", now - last);
    }

    RTLOG(modName, RTLOG_INFO, "task terminated");
}

/*
 * kernel module handling
 */
int init_module(void)
{
    /*
     * spawn the main task
     */
    if ( rt_task_init(&task, test_task, 0, 8000, 10, 1, 0)
	 != 0 )
    {
	rt_printk("rtlogTimeStampingTest: CANNOT SPAWN THE TEST TASK #1.\n");
	return 0;
    }

    rt_task_resume(&task);

    return 0;
}

//-----------------------------------------------------------------------------
void cleanup_module(void)
{
    rt_printk("rtlogTimeStampingTest: MODULE CLEANING UP...\n");

    /*
     * delete our main task
     */
    rt_task_delete(&task);

    rt_printk("rtlogTimeStampingTest: MODULE CLEANED UP.\n");
}

/*___oOo___*/
