#ifndef rtlogImpl_H
#define rtlogImpl_H

/************************************************************************
* "@(#) $Id: rtlogImpl.h,v 1.27 2009/10/07 09:28:14 bjeram Exp $"
*
* who       when        what
* --------  ----------  ----------------------------------------------
* ramestic  2004-04-06  created
*/

#include <acsutilTimeStamp.h>
#include <rtlogS.h>
#include <baciCharacteristicComponentImpl.h>
#include "rtlogErrType.h"
#include "rtLog.h"
#include "rtlogTimeDataThread.h"


// forward declaration
class rtlogImpl;

/**
 * RTLog thread which reads log messages from FIFO and send them to the logging system
 */
class RTLogThread : public ACS::Thread
{
  public:
    RTLogThread(const ACE_CString &_name, rtlogImpl &_rtlogImpl);

    void run();
    
  private:
    rtlogImpl *mp_rtlogImpl;
    rtlogRecord_t m_logRecord; 
    rtLogTimeData_t m_timeData; // local time data
    ACS::Time m_timeStamp; // log message time stamp
};//class RTLogThread


/**
 * Implementation of the rtlog component
 */
class rtlogImpl :
    public virtual baci::CharacteristicComponentImpl,
    public POA_ACS_RT::rtlog
{
    friend class RTLogThread;
    friend class TimeDataThread;

  public:
    rtlogImpl(const ACE_CString &name, maci::ContainerServices* containerServices);

    virtual ~rtlogImpl();

    
    /**
     *  @throw ACSErr::ACSbaseExImpl
     */
    virtual void initialize();

    virtual void cleanUp();

    /**
     *  @throw rtlogErrType::CanNotGetLevelEx
     */
    virtual ACS_RT::RTLogLevels getLevel(); 

    /**
     *  @throw rtlogErrType::CanNotSetLevelEx
     */
    virtual void setLevel(ACS_RT::RTLogLevels level);

    /**
     *  @throw rtlogErrType::CanNotSetFIFOSizeEx
     */
    virtual void setFIFOSize (CORBA::ULong size );

    virtual CORBA::ULong getFIFOSize ();

  private:
    inline rtLogTimeData_t getTimeData() { return mp_timeDataThread->getTimeData(); }
    
    int m_fd;
    unsigned long long /*TBD replaced with ACS time*/  m_timeOffset;
    CORBA::ULong m_FIFOSize;
    RTLogThread *mp_rtLogThread;
    TimeDataThread *mp_timeDataThread;
    RTLogLevelType get_rtlog_level, set_rtlog_level; //level for set/get method preallocated
    RT_TASK *set_level_task, *get_level_task;
};  

#endif /* ifndef _rtlogImpl_H */
