/*******************************************************************************
*
* "@(#) $Id: rtAlarmTest_k.c,v 1.4 2009/10/07 08:49:37 bjeram Exp $"
*
* ALMA - Atacama Large Millimiter Array
* (c) Associated Universities Inc., 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* who       when        what
* --------  --------    ----------------------------------------------
* ramestic  2004-03-03  created
*/

/* 
 * System Headers
 */
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/delay.h>
#include <linux/time.h>

/*
 * RTAI specific
 */
#include <rtai_lxrt.h>

#include "rtLog.h"

/* 
 * Local Headers
 */
#include "rtAlarm.h"

MODULE_AUTHOR("Bogdan Jeram");
MODULE_DESCRIPTION("rtAlarm Test");
MODULE_LICENSE("GPL");

/*
 * module parameters
 */
static char *rtAlarmSourceName = "rtAlX";        /* alarm source name */
static unsigned int iterNum = 50;                    /* number of iteration */
module_param(rtAlarmSourceName, charp, S_IRUGO);
module_param(iterNum, uint, S_IRUGO);

/*
 * global variables
 */
int debug = 0;
RT_TASK	task1, task2;
rtAlarmSource_t *rtas2 = 0;

#define MODULENAME	"rtAlarmTest"

void test_task1(int not_used)
{
    int i;
    rtAlarm_t alarm;
    rtlogRecord_t logRecord;
    rtAlarmSource_t *rtas;

    rtAlarmSourceName[strlen(rtAlarmSourceName)-1]='1';
    rtas = rtAlarmSourceInit(rtAlarmSourceName, 1);

//    MBX* alarmMBX_p = rt_named_mbx_init("rtAlarm", sizeof(rtAlarm_t)*12);

    alarm.alarmCode = 42;
    alarm.timeStamp = rt_get_time();
    alarm.descriptor = rtAlarm_ACTIVE;


    for ( i = 0; i < iterNum; i++ )
	{
	rtAlarmPush(rtas, i+1, rtAlarm_ACTIVE);
	rtAlarmWithPropertyPush(rtas, i+1, rtAlarm_TERMINATE, "alarm property");
	
//       rt_mbx_send(alarmMBX_p, &alarm, sizeof(rtAlarm_t));
	
	rt_printk("rtAlarmTest-task1: sent an alarm %d!\n", i+1);
	}/*for*/

    rt_sleep(nano2count(5000000000));
    rtAlarmSourceDelete(rtas,0);
    //  rt_named_mbx_delete(alarmMBX_p);
    rt_printk("rtAlarmTest: task1 finished!\n");
}



void test_task2(int not_used)
{
    int i;
    rtlogRecord_t logRecord;
   
    rtAlarmSourceName[strlen(rtAlarmSourceName)-1]='2';
    rtas2 = rtAlarmSourceInit(rtAlarmSourceName, 0);

    for ( i = 0; i < iterNum; i++ )
	{
	rtAlarmPush(rtas2, i+1, rtAlarm_ACTIVE);
	rtAlarmWithPropertyPush(rtas2, i+1, rtAlarm_TERMINATE, "alarm property");

	rt_printk("rtAlarmTest-task2: sent an alarm %d!\n", i+1);
	}/*for*/

    rt_sleep(nano2count(5000000000));
    rtAlarmSourceDelete(rtas2, 1);
    rt_printk("rtAlarmTest: task2 finished!\n");
}
/*
 * kernel module handling
 */
int init_module(void)
{


    /*
     * spawn the main task
     */
    if ( rt_task_init(&task1, test_task1, 0, 8000, 10, 1, 0)
	 != 0 )
	{
	rt_printk("rtlogTest: CANNOT SPAWN THE TEST TASK #1.\n");
	return 0;
	}


  if ( rt_task_init(&task2, test_task2, 0, 8000, 10, 1, 0)
	 != 0 )
	{
	rt_printk("rtlogTest: CANNOT SPAWN THE TEST TASK #2.\n");
	return 0;
	}


    /*
     * set the just created task as 'ready to run'
     */
    rt_task_resume(&task1);
    rt_task_resume(&task2);

    return 0;
}

//-----------------------------------------------------------------------------
void cleanup_module(void)
{
    rt_printk("rAlarmTest: MODULE CLEANING UP...\n");

    rt_task_delete(&task2);
    rt_task_delete(&task1);

    rt_printk("rtAlarmTest: MODULE CLEANED UP.\n");
}

/*___oOo___*/
