/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 * 
 * ========================================================================
 * == THIS IS GENERATED CODE!!! DO NOT MODIFY! ALL CHANGES WILL BE LOST! ==
 * ======================================================================== 
 */
 
package alma.ArchiveIdentifierError.wrappers;

import org.omg.CORBA.UserException; 
import alma.acs.exceptions.*;

import alma.ACSErr.ErrorTrace;
import alma.ArchiveIdentifierError.IdentifierUnavailable;
import alma.ArchiveIdentifierError.IdentifierUnavailableEx;

/**
 * Java native style exception class representing the error type 
 * <code>alma.ACSErr.ACSErrType.ArchiveIdentifierError</code>,
 * error code <code>IdentifierUnavailable.value</code>.     
 * 
 * @see AcsJArchiveIdentifierErrorEx
 * 
 * @author ACS Error System Code Generator
 * created Sep 25, 2003 4:18:09 PM
 */
public class AcsJIdentifierUnavailableEx extends AcsJArchiveIdentifierErrorEx
{

	public AcsJIdentifierUnavailableEx()
	{
		super();
	}
	
        /**
         * @deprecated The data in <code>message</code> should be given as parameters instead!
         */
	public AcsJIdentifierUnavailableEx(String message)
	{
		super(message);
	}

        /**
         * @deprecated The data in <code>message</code> should be given as parameters instead!
         */
	public AcsJIdentifierUnavailableEx(String message, Throwable cause)
	{
		super(message, cause);
	}

	public AcsJIdentifierUnavailableEx(Throwable cause)
	{
		super(null, cause);
	}

	public AcsJIdentifierUnavailableEx(ErrorTrace etCause)
	{
		super(etCause);
	}

        /**
         * @deprecated The data in <code>message</code> should be given as parameters instead!
         */
	public AcsJIdentifierUnavailableEx(String message, ErrorTrace etCause)
	{
		super(message, etCause);
	}


	/////////////////////////////////////////////////////////////
	// Code specific methods
	/////////////////////////////////////////////////////////////
  
       /**
        * Returns the short description of the error
        */
	public String getShortDescription() 
	{
	   return "The identifier archive is not available.";
	}
    
	/**
	 * Returns the error code, which is fixed to <code>1</code>, given by
	 * <code>IdentifierUnavailable.value</code>. 
	 * 
	 * @see alma.acs.exceptions.AcsJException#getErrorCode()
	 */ 
	protected final int getErrorCode()
	{
		return IdentifierUnavailable.value;
	 }

	/**
	 * @see alma.acs.exceptions.AcsJException#toCorbaException()
	 */
	public UserException toCorbaException()
	{
		return toIdentifierUnavailableEx();
	}
	
	/**
	 * Creates an <code>IdentifierUnavailable</code> that represents this exception
	 * with all its caused-by child exceptions.
	 * <p>
	 * Typically to be called from a top-level catch block that must
	 * convert any of the Java exceptions used internally by the Java program
	 * to an IDL type exception that can be thrown on over CORBA.
	 *   
	 * @return the type-safe subclass of <code>org.omg.CORBA.UserException</code> 
	 * 			with an embedded <code>ErrorTrace</code>.
	 * @see #toCorbaException
	 */
	public IdentifierUnavailableEx toIdentifierUnavailableEx()
	{
		ErrorTrace et = getErrorTrace(); 
		IdentifierUnavailableEx acsEx = new IdentifierUnavailableEx(et);
		return acsEx;
	}
	
	
	/**
	 * Converts a CORBA <code>IdentifierUnavailable</code> to an instance of this class.
	 * <p>
	 * Note that unlike the constructor {@link #AcsJErrTest0Ex(ErrorTrace)}, 
	 * this static conversion method
	 * does not wrap the existing chain of exceptions with a new exception. 
	 * It simply converts all exceptions found in the <code>ErrorTrace<code>
	 * of <code>corbaEx</code> to the corresponding Java exceptions, knowing that 
	 * the top level exception is of type <code>IdentifierUnavailable</code> and can 
	 * always be converted to <code>AcsJIdentifierUnavailableEx</code>.
	 * <p>
	 * Here's an example of how to use this method in a Java program that 
	 * makes a call so some other component etc.:
	 * <pre>
	 * private void methodThatMakesARemoteCall() throws AcsJIdentifierUnavailableEx
	* {
	 *   try
	 *   {
	 *     // this fakes the remote call to a method
	 *     // which can throw an IdentifierUnavailableEx...
	 *     throw new IdentifierUnavailableEx();
	 *   }
	 *   catch (IdentifierUnavailableEx corbaEx)
	 *   {
	 *     throw AcsJIdentifierUnavailableEx.fromIdentifierUnavailableEx(corbaEx);
	 *   }
	 * } 
	 * </pre> 
	 * @param corbaEx the CORBA equivalent of this class; will be converted
	 * @return  the newly created instance, with data fields and caused-by exceptions 
	 * 			converted from <code>corbaEx</code>. 
	 */
	public static AcsJIdentifierUnavailableEx fromIdentifierUnavailableEx(IdentifierUnavailableEx corbaEx)
	{
		ErrorTrace et = corbaEx.errorTrace;
		
		String message = ErrorTraceManipulator.getProperty(
			et, CorbaExceptionConverter.PROPERTY_JAVAEXCEPTION_MESSAGE);
		AcsJIdentifierUnavailableEx jEx = new AcsJIdentifierUnavailableEx(message);
		
		CorbaExceptionConverter.convertErrorTraceToJavaException(et, jEx);
		
		return jEx;
	}
	
	/////////////////////////////////////////////////////////////
	// Getter/Setter for members
	/////////////////////////////////////////////////////////////	

			
        public void setContextInfo(String value)
	{ 
		setProperty("ContextInfo", ""+value);
	}            				
	
	public String getContextInfo()
	{ 
		return (getProperty("ContextInfo")); 
	}
  
	
} 
