package alma.userrepository.shared;

import alma.userrepository.addressbook.AddressBookSession;
import alma.userrepository.errors.UserRepositoryException;
import alma.userrepository.projectdirectory.ProjectDirectorySession;
import alma.userrepository.roledirectory.RoleDirectorySession;

public abstract class DirectorySessionFactory {

	private static DirectorySessionFactory instance;

	public static DirectorySessionFactory getInstance() {
		if (instance == null) {
			synchronized (DirectorySessionFactory.class) {
				if (instance == null) {
					instance = new LdapDirectorySessionFactory();
				}
			}
		}
		return instance;
	}

	public abstract AddressBookSession newAddressBookSession(String userId,
			String password) throws UserRepositoryException;

	public abstract ProjectDirectorySession newProjectDirectorySession(
			String userId, String password) throws UserRepositoryException;

	public abstract RoleDirectorySession newRoleDirectorySession(String userId,
			String password) throws UserRepositoryException;

	public abstract boolean isAlive();

	public static boolean authenticate(String userId, String password)
			throws UserRepositoryException {
		return getInstance().authenticateImpl(userId, password);
	}

	abstract boolean authenticateImpl(String userId, String password)
			throws UserRepositoryException;

	public static void setFactory(DirectorySessionFactory inFactory) {
		instance = inFactory;
	}
}
