/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 *
 */
package alma.userrepository.domainmodel;

public interface Address {
	/**
	 * @return the city
	 */
	public String getCity();

	/**
	 * @param city
	 *            the city to set
	 */
	public void setCity(String city);

	/**
	 * @return the country
	 */
	public String getCountry();

	/**
	 * @param country
	 *            the country to set
	 */
	public void setCountry(String country);

	/**
	 * @return the department
	 */
	public String getDepartment();

	/**
	 * @param department
	 *            the department to set
	 */
	public void setDepartment(String department);

	/**
	 * @return the email
	 */
	public String getEmail();

	/**
	 * @param email
	 *            the email to set
	 */
	public void setEmail(String email);

	/**
	 * @return the fax
	 */
	public String getFax();

	/**
	 * @param fax
	 *            the fax to set
	 */
	public void setFax(String fax);

	/**
	 * @return the jobTitle
	 */
	public String getJobTitle();

	/**
	 * @param jobTitle
	 *            the jobTitle to set
	 */
	public void setJobTitle(String jobTitle);

	/**
	 * @return the mobile
	 */
	public String getMobile();

	/**
	 * @param mobile
	 *            the mobile to set
	 */
	public void setMobile(String mobile);

	/**
	 * @return the organization
	 */
	public String getOrganization();

	/**
	 * @param organization
	 *            the organization to set
	 */
	public void setOrganization(String organization);

	/**
	 * @return the pager
	 */
	public String getPager();

	/**
	 * @param pager
	 *            the pager to set
	 */
	public void setPager(String pager);

	/**
	 * @return the phone
	 */
	public String getPhone();

	/**
	 * @param phone
	 *            the phone to set
	 */
	public void setPhone(String phone);

	/**
	 * @return the postcode
	 */
	public String getPostcode();

	/**
	 * @param postcode
	 *            the postcode to set
	 */
	public void setPostcode(String postcode);

	/**
	 * @return the region
	 */
	public String getRegion();

	/**
	 * @param region
	 *            the region to set
	 */
	public void setRegion(String region);

	/**
	 * @return the streetAddress
	 */
	public String getStreetAddress();

	/**
	 * @param streetAddress
	 *            the streetAddress to set
	 */
	public void setStreetAddress(String streetAddress);

	/**
	 * @return the uid
	 */
	public String getUid();

	/**
	 * @param uid
	 *            the uid to set
	 */
	public void setUid(String uid);

	/**
	 * @return the website
	 */
	public String getWebsite();

	/**
	 * @param website
	 *            the website to set
	 */
	public void setWebsite(String website);

}
