/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 *
 */
package alma.userrepository.addressbook.ldap.beans;

import java.util.ArrayList;
import java.util.List;

import alma.userrepository.domainmodel.Address;
import alma.userrepository.domainmodel.AddressBookEntry;
import alma.userrepository.domainmodel.Preferences;
import alma.userrepository.domainmodel.User;

public class LdapAddressBookEntry implements AddressBookEntry {
	private List<Address> addresses = new ArrayList<Address>();
	private User user = null;
	private Preferences preferences = null;

	// - constructors ---------------------------------------------------------
	
	public LdapAddressBookEntry(User user, List<Address> addresses) {
		this.user = user;
		this.addresses = addresses;
		this.preferences = new LdapPreferences();
	}

	public LdapAddressBookEntry(User user, List<Address> addresses,
			Preferences preferences) {
		this.user = user;
		this.addresses = addresses;
		this.preferences = preferences;
	}

	// - public methods -------------------------------------------------------
	
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append("User with uid: " + user.getUid() + ", name: "
				+ user.getFullName() + "\n");
		int counter = 0;
		for (Address address : addresses) {
			counter++;
			sb.append("Address " + counter + " has uid: " + address.getUid());
		}
		return sb.toString();
	}

	// - getters and setters --------------------------------------------------
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see alma.userrepository.domainmodel.AddressBookEntry#getAddresses()
	 */
	public List<Address> getAddresses() {
		return addresses;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see alma.userrepository.domainmodel.AddressBookEntry#getUser()
	 */
	public User getUser() {
		return user;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see alma.userrepository.domainmodel.AddressBookEntry#getSettings()
	 */
	public Preferences getPreferences() {
		return preferences;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see alma.userrepository.domainmodel.AddressBookEntry#setAddresses(java.util.List)
	 */
	public void setAddresses(List<Address> addresses) {
		this.addresses.clear();
		this.addresses.addAll(addresses);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see alma.userrepository.domainmodel.AddressBookEntry#setUser(alma.userrepository.domainmodel.User)
	 */
	public void setUser(User user) {
		this.user = user;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see alma.userrepository.domainmodel.AddressBookEntry#setSettings(alma.userrepository.domainmodel.Settings)
	 */
	public void setPreferences(Preferences preferences) {
		this.preferences = preferences;
	}

}
