/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 *
 */
package alma.userrepository.addressbook.ldap;

import java.util.Properties;

import alma.userrepository.shared.PropertiesLoader;

public class UserInfoProperties extends PropertiesLoader {
    private static final String RESOURCE_NAME = "ldap.userinfo";

    static final String ADDRESS_OBJECT_CLASSES_KEY = "address.objectClasses";
    static final String POSIXACCOUNT_OBJECT_CLASSES_KEY = "posixaccount.objectClasses";
    static final String USER_OBJECT_CLASSES_KEY = "user.objectClasses";

    static final String USER_UID_KEY = "user.uid";
    static final String USER_NOTES_KEY = "user.notes";
    static final String USER_FIRSTNAME_KEY = "user.firstName";
    static final String USER_SURNAME_KEY = "user.surname";
    static final String USER_FULLNAME_KEY = "user.fullName";

    static final String ADDRESS_UID_KEY = "address.uid";
    static final String JOBTITLE_KEY = "address.jobTitle";
    static final String ORGANIZATION_KEY = "address.organization";
    static final String DEPARTMENT_KEY = "address.department";
    static final String STREET_ADDRESS_KEY = "address.streetAddress";
    static final String CITY_KEY = "address.city";
    static final String REGION_KEY = "address.region";
    static final String POSTCODE_KEY = "address.postcode";
    static final String COUNTRY_KEY = "address.country";
    static final String PHONE_KEY = "address.phone";
    static final String FAX_KEY = "address.fax";
    static final String MOBILE_KEY = "address.mobile";
    static final String PAGER_KEY = "address.pager";
    static final String EMAIL_KEY = "address.email";
    static final String WEBSITE_KEY = "address.website";

    static final String ADDRESS_FIRSTNAME_KEY = "address.firstName";
    static final String ADDRESS_SURNAME_KEY = "address.surname";
    static final String ADDRESS_FULLNAME_KEY = "address.fullName";

    static final String PREFERENCE1_KEY = "preferences.preference1";
    static final String PREFERENCE2_KEY = "preferences.preference2";
    static final String PREFERENCE3_KEY = "preferences.preference3";
    static final String PREFERENCE4_KEY = "preferences.preference4";

    // object class defaults.
    private String addressObjectClasses = "top,person,organizationalPerson,inetOrgPerson,almaAddress,outlookAttributes";
    private String posixAccountObjectClasses = "top,posixAccount,shadowAccount";
    private String userObjectClasses = "top,posixAccount,shadowAccount,almaUser,person,organizationalPerson,inetOrgPerson,almaAddress,outlookAttributes,almaPreferences";

    // user default properties
    private String userUid = "uid";
    private String userNotes = "description";
    private String userFirstName = "givenName";
    private String userSurname = "sn";
    private String userFullName = "cn";

    // address default properties
    private String addressUid = "uid";
    private String jobTitle = "title";
    private String organization = "o";
    private String department = "ou";
    private String streetAddress = "street";
    private String city = "l";
    private String region = "st";
    private String postcode = "postalCode";
    private String country = "c";
    private String phone = "telephoneNumber";
    private String fax = "facsimileTelephoneNumber";
    private String mobile = "mobile";
    private String pager = "pager";
    private String email = "mail";
    private String website = "url,workurl,labeledURI";

    private String addressFirstName = "givenName";
    private String addressSurname = "sn";
    private String addressFullName = "cn,displayName";

    private String preference1 = "almaPreference1";
    private String preference2 = "almaPreference2";
    private String preference3 = "almaPreference3";
    private String preference4 = "almaPreference4";

    private volatile static UserInfoProperties instance = null;

    public static UserInfoProperties getInstance() {
        if (instance == null) {
            synchronized (UserInfoProperties.class) {
                if (instance == null) {
                    instance = new UserInfoProperties();
                }
            }
        }
        return instance;
    }

    private UserInfoProperties() {
        super(RESOURCE_NAME);
        getProperties();
    }

    /** Here for testing purposes only, will not work outside of the test bench. */
    UserInfoProperties(String inResourceName) {
        super(inResourceName);
    }

    protected Properties getDefaultProperties() {
        Properties outProperties = new Properties();
        outProperties
                .put(ADDRESS_OBJECT_CLASSES_KEY, getAddressObjectClasses());
        outProperties.put(POSIXACCOUNT_OBJECT_CLASSES_KEY,
                getPosixAccountObjectClasses());
        outProperties.put(USER_OBJECT_CLASSES_KEY, getUserObjectClasses());

        outProperties.put(USER_UID_KEY, getUserUid());
        outProperties.put(USER_NOTES_KEY, getUserNotes());
        outProperties.put(USER_FIRSTNAME_KEY, getUserFirstName());
        outProperties.put(USER_SURNAME_KEY, getUserSurname());
        outProperties.put(USER_FULLNAME_KEY, getUserFullName());

        outProperties.put(ADDRESS_UID_KEY, getAddressUid());
        outProperties.put(JOBTITLE_KEY, getJobTitle());
        outProperties.put(ORGANIZATION_KEY, getOrganization());
        outProperties.put(DEPARTMENT_KEY, getDepartment());
        outProperties.put(STREET_ADDRESS_KEY, getStreetAddress());
        outProperties.put(CITY_KEY, getCity());
        outProperties.put(REGION_KEY, getRegion());
        outProperties.put(POSTCODE_KEY, getPostcode());
        outProperties.put(COUNTRY_KEY, getCountry());
        outProperties.put(PHONE_KEY, getPhone());
        outProperties.put(FAX_KEY, getFax());
        outProperties.put(MOBILE_KEY, getMobile());
        outProperties.put(PAGER_KEY, getPager());
        outProperties.put(EMAIL_KEY, getEmail());
        outProperties.put(WEBSITE_KEY, getWebsite());

        outProperties.put(ADDRESS_FIRSTNAME_KEY, getAddressFirstName());
        outProperties.put(ADDRESS_FULLNAME_KEY, getAddressFullName());
        outProperties.put(ADDRESS_SURNAME_KEY, getAddressSurname());

        outProperties.put(PREFERENCE1_KEY, getPreference1());
        outProperties.put(PREFERENCE2_KEY, getPreference2());
        outProperties.put(PREFERENCE3_KEY, getPreference3());
        outProperties.put(PREFERENCE4_KEY, getPreference4());

        return outProperties;
    }

    protected void updateSettingsFromProperties() {
        try {
            setUserObjectClasses(myProperties
                    .getProperty(USER_OBJECT_CLASSES_KEY));
            setAddressObjectClasses(myProperties
                    .getProperty(ADDRESS_OBJECT_CLASSES_KEY));
            setPosixAccountObjectClasses(myProperties
                    .getProperty(POSIXACCOUNT_OBJECT_CLASSES_KEY));

            setUserUid(myProperties.getProperty(USER_UID_KEY));
            setUserNotes(myProperties.getProperty(USER_NOTES_KEY));
            setUserFirstName(myProperties.getProperty(USER_FIRSTNAME_KEY));
            setUserSurname(myProperties.getProperty(USER_SURNAME_KEY));
            setUserFullName(myProperties.getProperty(USER_FULLNAME_KEY));

            setAddressUid(myProperties.getProperty(ADDRESS_UID_KEY));
            setJobTitle(myProperties.getProperty(JOBTITLE_KEY));
            setOrganization(myProperties.getProperty(ORGANIZATION_KEY));
            setDepartment(myProperties.getProperty(DEPARTMENT_KEY));
            setStreetAddress(myProperties.getProperty(STREET_ADDRESS_KEY));
            setCity(myProperties.getProperty(CITY_KEY));
            setRegion(myProperties.getProperty(REGION_KEY));
            setPostcode(myProperties.getProperty(POSTCODE_KEY));
            setCountry(myProperties.getProperty(COUNTRY_KEY));
            setPhone(myProperties.getProperty(PHONE_KEY));
            setFax(myProperties.getProperty(FAX_KEY));
            setMobile(myProperties.getProperty(MOBILE_KEY));
            setPager(myProperties.getProperty(PAGER_KEY));
            setEmail(myProperties.getProperty(EMAIL_KEY));
            setWebsite(myProperties.getProperty(WEBSITE_KEY));

            setAddressFirstName(myProperties.getProperty(ADDRESS_FIRSTNAME_KEY));
            setAddressFullName(myProperties.getProperty(ADDRESS_FULLNAME_KEY));
            setAddressSurname(myProperties.getProperty(ADDRESS_SURNAME_KEY));

            setPreference1(myProperties.getProperty(PREFERENCE1_KEY));
            setPreference2(myProperties.getProperty(PREFERENCE2_KEY));
            setPreference3(myProperties.getProperty(PREFERENCE3_KEY));
            setPreference4(myProperties.getProperty(PREFERENCE4_KEY));
        } catch (Exception e) {
            if (log.isErrorEnabled())
                log.error("Error updating properties: " + e);
        }
    }

    protected void updatePropertiesFromSettings() {
        myProperties.put(USER_OBJECT_CLASSES_KEY, getUserObjectClasses());
        myProperties.put(ADDRESS_OBJECT_CLASSES_KEY, getAddressObjectClasses());
        myProperties.put(POSIXACCOUNT_OBJECT_CLASSES_KEY,
                getPosixAccountObjectClasses());

        myProperties.put(USER_UID_KEY, getUserUid());
        myProperties.put(USER_NOTES_KEY, getUserNotes());
        myProperties.put(USER_FIRSTNAME_KEY, getUserFirstName());
        myProperties.put(USER_SURNAME_KEY, getUserSurname());
        myProperties.put(USER_FULLNAME_KEY, getUserFullName());

        myProperties.put(ADDRESS_UID_KEY, getAddressUid());
        myProperties.put(JOBTITLE_KEY, getJobTitle());
        myProperties.put(ORGANIZATION_KEY, getOrganization());
        myProperties.put(DEPARTMENT_KEY, getDepartment());
        myProperties.put(STREET_ADDRESS_KEY, getStreetAddress());
        myProperties.put(CITY_KEY, getCity());
        myProperties.put(REGION_KEY, getRegion());
        myProperties.put(POSTCODE_KEY, getPostcode());
        myProperties.put(COUNTRY_KEY, getCountry());
        myProperties.put(PHONE_KEY, getPhone());
        myProperties.put(FAX_KEY, getFax());
        myProperties.put(MOBILE_KEY, getMobile());
        myProperties.put(PAGER_KEY, getPager());
        myProperties.put(EMAIL_KEY, getEmail());
        myProperties.put(WEBSITE_KEY, getWebsite());

        myProperties.put(ADDRESS_FIRSTNAME_KEY, getAddressFirstName());
        myProperties.put(ADDRESS_FULLNAME_KEY, getAddressFullName());
        myProperties.put(ADDRESS_SURNAME_KEY, getAddressSurname());

        myProperties.put(PREFERENCE1_KEY, getPreference1());
        myProperties.put(PREFERENCE2_KEY, getPreference2());
        myProperties.put(PREFERENCE3_KEY, getPreference3());
        myProperties.put(PREFERENCE4_KEY, getPreference4());

    }

    // -------------------------------------------------------------- Properties

    public String getAddressFirstName() {
        return addressFirstName;
    }

    public void setAddressFirstName(String addressFirstName) {
        this.addressFirstName = addressFirstName;
    }

    public String getAddressFullName() {
        return addressFullName;
    }

    public void setAddressFullName(String addressFullName) {
        this.addressFullName = addressFullName;
    }

    public String getAddressObjectClasses() {
        return addressObjectClasses;
    }

    public void setAddressObjectClasses(String addressObjectClasses) {
        this.addressObjectClasses = addressObjectClasses;
    }

    public String getAddressSurname() {
        return addressSurname;
    }

    public void setAddressSurname(String addressSurname) {
        this.addressSurname = addressSurname;
    }

    public String getAddressUid() {
        return addressUid;
    }

    public void setAddressUid(String addressUid) {
        this.addressUid = addressUid;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getDepartment() {
        return department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFax() {
        return fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getUserFirstName() {
        return userFirstName;
    }

    public void setUserFirstName(String firstname) {
        this.userFirstName = firstname;
    }

    public String getUserFullName() {
        return userFullName;
    }

    public void setUserFullName(String fullname) {
        this.userFullName = fullname;
    }

    public String getJobTitle() {
        return jobTitle;
    }

    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getOrganization() {
        return organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getPager() {
        return pager;
    }

    public void setPager(String pager) {
        this.pager = pager;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getPostcode() {
        return postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getStreetAddress() {
        return streetAddress;
    }

    public void setStreetAddress(String streetAddress) {
        this.streetAddress = streetAddress;
    }

    public String getUserSurname() {
        return userSurname;
    }

    public void setUserSurname(String surname) {
        this.userSurname = surname;
    }

    public String getUserObjectClasses() {
        return userObjectClasses;
    }

    public void setUserObjectClasses(String userObjectClasses) {
        this.userObjectClasses = userObjectClasses;
    }

    public String getUserNotes() {
        return userNotes;
    }

    public void setUserNotes(String userNotes) {
        this.userNotes = userNotes;
    }

    public String getUserUid() {
        return userUid;
    }

    public void setUserUid(String userUid) {
        this.userUid = userUid;
    }

    public String getWebsite() {
        return website;
    }

    public void setWebsite(String webpage) {
        this.website = webpage;
    }

    public String getPreference1() {
        return preference1;
    }

    public void setPreference1(String preference) {
        this.preference1 = preference;
    }

    public String getPreference2() {
        return preference2;
    }

    public void setPreference2(String preference) {
        this.preference2 = preference;
    }

    public String getPreference3() {
        return preference3;
    }

    public void setPreference3(String preference) {
        this.preference3 = preference;
    }

    public String getPreference4() {
        return preference4;
    }

    public void setPreference4(String preference) {
        this.preference4 = preference;
    }

    public String getPosixAccountObjectClasses() {
        return posixAccountObjectClasses;
    }

    public void setPosixAccountObjectClasses(String objectClasses) {
        this.posixAccountObjectClasses = objectClasses;
    }
}
