/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 *
 */
package alma.userrepository.addressbook.ldap;

import java.util.Properties;

import alma.userrepository.shared.PropertiesLoader;

public class UserAccountProperties extends PropertiesLoader {
    private static final String RESOURCE_NAME = "ldap.useraccount";

    // OS account property keys
    static public final String HOME_DIRECTORY_KEY = "homeDirectory";
    static public final String LOGIN_SHELL_KEY = "loginShell";
    static public final String GID_NUMBER_KEY = "gidNumber";
    static public final String UID_NUMBER_KEY = "uidNumber";
    static public final String PREFERRED_LANGUAGE_KEY = "preferredLanguage";
    static public final String SHADOW_EXPIRE_KEY = "shadowExpire";
    static public final String SHADOW_FLAG_KEY = "shadowFlag";
    static public final String SHADOW_INACTIVE_KEY = "shadowInactive";
    static public final String SHADOW_MIN_KEY = "shadowMin";
    static public final String SHADOW_MAX_KEY = "shadowMax";
    static public final String SHADOW_WARNING_KEY = "shadowWarning";

    // OS account default properties
    private String homeDirectory = "not set";
    private String loginShell = "/bin/nologin";
    private String gidNumber = "-99999";
    private String uidNumber = "-99999";
    private String preferredLanguage = "EN";
    private String shadowExpire = "";
    private String shadowFlag = "";
    private String shadowInactive = "";
    private String shadowMin = "";
    private String shadowMax = "99999";
    private String shadowWarning = "7";

    private volatile static UserAccountProperties instance = null;

    public static UserAccountProperties getInstance() {
        if (instance == null) {
            synchronized (UserAccountProperties.class) {
                if (instance == null) {
                    instance = new UserAccountProperties();
                }
            }
        }
        return instance;
    }

    private UserAccountProperties() {
        super(RESOURCE_NAME);
        getProperties();
    }

    /** Here for testing purposes only, will not work outside of the test bench. */
    UserAccountProperties(String inResourceName) {
        super(inResourceName);
    }

    protected Properties getDefaultProperties() {
        Properties outProperties = new Properties();
        outProperties.put(HOME_DIRECTORY_KEY, getHomeDirectory());
        outProperties.put(LOGIN_SHELL_KEY, getLoginShell());
        outProperties.put(GID_NUMBER_KEY, getGidNumber());
        outProperties.put(UID_NUMBER_KEY, getUidNumber());
        outProperties.put(PREFERRED_LANGUAGE_KEY, getPreferredLanguage());
        outProperties.put(SHADOW_EXPIRE_KEY, getShadowExpire());
        outProperties.put(SHADOW_FLAG_KEY, getShadowFlag());
        outProperties.put(SHADOW_INACTIVE_KEY, getShadowInactive());
        outProperties.put(SHADOW_MIN_KEY, getShadowMin());
        outProperties.put(SHADOW_MAX_KEY, getShadowMax());
        outProperties.put(SHADOW_WARNING_KEY, getShadowWarning());
        return outProperties;
    }

    protected void updateSettingsFromProperties() {
        try {
            setHomeDirectory(myProperties.getProperty(HOME_DIRECTORY_KEY));
            setLoginShell(myProperties.getProperty(LOGIN_SHELL_KEY));
            setGidNumber(myProperties.getProperty(GID_NUMBER_KEY));
            setUidNumber(myProperties.getProperty(UID_NUMBER_KEY));
            setPreferredLanguage(myProperties
                    .getProperty(PREFERRED_LANGUAGE_KEY));
            setShadowExpire(myProperties.getProperty(SHADOW_EXPIRE_KEY));
            setShadowFlag(myProperties.getProperty(SHADOW_FLAG_KEY));
            setShadowInactive(myProperties.getProperty(SHADOW_INACTIVE_KEY));
            setShadowMin(myProperties.getProperty(SHADOW_MIN_KEY));
            setShadowMax(myProperties.getProperty(SHADOW_MAX_KEY));
            setShadowWarning(myProperties.getProperty(SHADOW_WARNING_KEY));
        } catch (Exception e) {
            if (log.isErrorEnabled())
                log.error("Error updating properties: " + e);
        }
    }

    protected void updatePropertiesFromSettings() {
        myProperties.put(HOME_DIRECTORY_KEY, getHomeDirectory());
        myProperties.put(LOGIN_SHELL_KEY, getLoginShell());
        myProperties.put(GID_NUMBER_KEY, getGidNumber());
        myProperties.put(UID_NUMBER_KEY, getUidNumber());
        myProperties.put(PREFERRED_LANGUAGE_KEY, getPreferredLanguage());
        myProperties.put(SHADOW_EXPIRE_KEY, getShadowExpire());
        myProperties.put(SHADOW_FLAG_KEY, getShadowFlag());
        myProperties.put(SHADOW_INACTIVE_KEY, getShadowInactive());
        myProperties.put(SHADOW_MIN_KEY, getShadowMin());
        myProperties.put(SHADOW_MAX_KEY, getShadowMax());
        myProperties.put(SHADOW_WARNING_KEY, getShadowWarning());
    }

    public String getGidNumber() {
        return gidNumber;
    }

    public void setGidNumber(String gidNumber) {
        this.gidNumber = gidNumber;
    }

    public String getHomeDirectory() {
        return homeDirectory;
    }

    public void setHomeDirectory(String homeDirectory) {
        this.homeDirectory = homeDirectory;
    }

    public String getLoginShell() {
        return loginShell;
    }

    public void setLoginShell(String loginShell) {
        this.loginShell = loginShell;
    }

    public String getPreferredLanguage() {
        return preferredLanguage;
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    public String getShadowExpire() {
        return shadowExpire;
    }

    public void setShadowExpire(String shadowExpire) {
        this.shadowExpire = shadowExpire;
    }

    public String getShadowFlag() {
        return shadowFlag;
    }

    public void setShadowFlag(String shadowFlag) {
        this.shadowFlag = shadowFlag;
    }

    public String getShadowInactive() {
        return shadowInactive;
    }

    public void setShadowInactive(String shadowInactive) {
        this.shadowInactive = shadowInactive;
    }

    public String getShadowMax() {
        return shadowMax;
    }

    public void setShadowMax(String shadowMax) {
        this.shadowMax = shadowMax;
    }

    public String getShadowMin() {
        return shadowMin;
    }

    public void setShadowMin(String shadowMin) {
        this.shadowMin = shadowMin;
    }

    public String getShadowWarning() {
        return shadowWarning;
    }

    public void setShadowWarning(String shadowWarning) {
        this.shadowWarning = shadowWarning;
    }

    public String getUidNumber() {
        return uidNumber;
    }

    public void setUidNumber(String uidNumber) {
        this.uidNumber = uidNumber;
    }

}
