/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 *
 * ========================================================================
 * == THIS IS GENERATED CODE!!! DO NOT MODIFY! ALL CHANGES WILL BE LOST! ==
 * ======================================================================== 
 *
 */
 
package alma.maciErrType.wrappers;

import alma.ACSErr.Completion;
import alma.acs.exceptions.*;
import alma.maciErrType.wrappers.AcsJCannotGetComponentEx;

public class CannotGetComponentAcsJCompletion extends AcsJCompletion
{
	/**
	 * Creates a new <code>CannotGetComponentAcsJCompletion</code>
	 * with a corresponding exception (AcsJCannotGetComponentEx) attached.
	 */
	public CannotGetComponentAcsJCompletion () {
		super(new AcsJCannotGetComponentEx()); 
	}

	/**
	 * Creates a new <code>CannotGetComponentAcsJCompletion</code>
	 * with a corresponding exception (AcsJCannotGetComponentEx) attached 
	 * that wraps an existing exception (<code>acsJEx</code>.)
	 */
	public CannotGetComponentAcsJCompletion (AcsJException acsJEx) {
		super(new AcsJCannotGetComponentEx(acsJEx));  
	}
	
	/**
	 * Creates a new <code>CannotGetComponentAcsJCompletion</code>
	 * from another <code>AcsJCompletion</code> (<code>acsJComp</code>).
	 * <p>
	 * If present, the existing error trace is converted to Java exceptions
	 * and wrapped with an <code>AcsJCannotGetComponentEx</code>.
	 */
	public CannotGetComponentAcsJCompletion(AcsJCompletion acsJComp) {		
			init(new AcsJCannotGetComponentEx(acsJComp.getAcsJException()));
	}
	
	/**
	 * Converts a Corba completion to an <code>CannotGetComponentAcsJCompletion</code>
	 * such that a new <code>AcsJCannotGetComponentEx</code> is created as the attached error.
	 * If <code>corbaComp</code> carries error information, these <code>ErrorTrace</code>
	 * objects are converted to Java exceptions, which are attached as the course of
	 * the new <code>AcsJCannotGetComponentEx</code>.
	 * @param corbaComp
	 */
	public CannotGetComponentAcsJCompletion(Completion corbaComp) {
		
		 this(AcsJCompletion.fromCorbaCompletion(corbaComp));
	}
	
       /**
        * Returns the short description of the error
        */
	public String getShortDescription() 
	{
	   return "Error retrieving component";
	}	

	/////////////////////////////////////////////////////////////
	// Getter/Setter for members
	/////////////////////////////////////////////////////////////	

		
        public void setCURL(String value)
	{ 
		setProperty("CURL", ""+value);
	}            				
	
	public String getCURL()
	{ 
		return (getProperty("CURL")); 
	}
  
		
        public void setReason(String value)
	{ 
		setProperty("Reason", ""+value);
	}            				
	
	public String getReason()
	{ 
		return (getProperty("Reason")); 
	}
  
	
}
