package alma.archive.projectcode.acs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import alma.ProjectCodeModule.ProjectCodeStruct;
import alma.ProjectCodeModule.ProjectCodeGeneratorOperations;
import alma.ProjectCodeModule.ProjectTypeCodeEnum;
import alma.acs.component.ComponentImplBase;
import alma.acs.component.ComponentLifecycleException;
import alma.acs.container.ContainerServices;
import alma.archive.projectcode.ProjectCodeGenerator;
import alma.archive.projectcode.TypeCode;

public class ProjectCodeGeneratorImpl extends ComponentImplBase implements
        ProjectCodeGeneratorOperations {

    private static Boolean isEnumChecked = false;

    HashMap<String, ProjectTypeCodeEnum> myProjectTypeCodeMap = new HashMap<String, ProjectTypeCodeEnum>();

    @Override
    public ProjectCodeStruct getNextProjectCode(ProjectTypeCodeEnum inCode) {
        // TODO Auto-generated method stub
        alma.archive.projectcode.ProjectCode javaData = ProjectCodeGenerator
                .getInstance().getNextProjectCode(
                        Enum.valueOf(TypeCode.class, inCode.toString()));
        ProjectCodeStruct idlData = new ProjectCodeStruct();
        idlData.year = javaData.getYear();
        idlData.semester = javaData.getSemester();
        idlData.sequenceNumber = javaData.getSequenceNumber();
        idlData.typeCode = inCode;
        return idlData;
    }

    @Override
    public void initialize(ContainerServices inContainerServices)
            throws ComponentLifecycleException {
        super.initialize(inContainerServices);

        initEnum();
    }

    @Override
    public void reset(int inYear, int inSemester) {
        // TODO Auto-generated method stub

    }

    private void initEnum() throws ComponentLifecycleException {
        if (!isEnumChecked) {
            synchronized (isEnumChecked) {
                if (!isEnumChecked) {
                    try {
                        for (int i = 0; i < Integer.MAX_VALUE; i++) {
                            ProjectTypeCodeEnum code = ProjectTypeCodeEnum
                                    .from_int(i);
                            this.myProjectTypeCodeMap
                                    .put(code.toString(), code);
                        }
                    } catch (Exception e) {
                        // We will always end up here which means that there are
                        // no
                        // more
                        // values to collect.
                    }

                    if (!isEnumChecked) {
                        isEnumChecked = true;
                        StringBuilder builder = new StringBuilder();

                        List<String> javaEnumStringList = new ArrayList<String>();
                        for (TypeCode role : TypeCode.class.getEnumConstants()) {
                            javaEnumStringList.add(role.name());
                        }

                        List<String> idlStringList = new ArrayList<String>(
                                this.myProjectTypeCodeMap.keySet());

                        List<String> tmpList = new ArrayList<String>(
                                idlStringList);
                        tmpList.removeAll(javaEnumStringList);
                        if (tmpList.size() != 0) {
                            builder
                                    .append("The following enums were found in IDL but not in Java: ");
                            builder.append(tmpList);
                            builder.append("\n");
                        }

                        tmpList = new ArrayList<String>(javaEnumStringList);
                        tmpList.removeAll(idlStringList);
                        if (tmpList.size() != 0) {
                            builder
                                    .append("The following enums were found in Java but not in IDL: ");
                            builder.append(tmpList);
                            builder.append("\n");
                        }

                        if (builder.length() != 0) {
                            throw new ComponentLifecycleException(builder
                                    .toString());
                        }
                    }
                }
            }
        }
    }

}
