package alma.archive.projectcode;

import java.util.HashMap;

public enum TypeCode {
    TARGET_OF_OPPORTUNITY, LARGE, NORMAL, CALIBRATION, DIRECTORS_DISCRETIONARY_TIME, ENGINEERING, MAINTENANCE, SIMULATED_DATA_SET;

    private static HashMap<String, TypeCode> typeCodeMap = new HashMap<String, TypeCode>();

    static {
        for (TypeCode code : TypeCode.class.getEnumConstants()) {
            TypeCode oldCode = typeCodeMap.put(code.getTypeCodeAbbreviation(), code);
            if (oldCode != null) {
                throw new IllegalStateException(
                        "Duplicate type code character [" + oldCode
                                + "] found in the enum");
            }
        }
    }

    public static TypeCode typeCodeAbbreviation2enum(String inString) {
        return typeCodeMap.get(inString);
    }

    public String getTypeCodeAbbreviation() {
        return name().substring(0, 1);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        char[] chars = name().toCharArray();
        boolean nextUpper = true;
        for (char character : chars) {
            if (nextUpper) {
                builder.append(character);
                nextUpper = false;
            } else if (character == '_') {
                builder.append(" ");
                nextUpper = true;
            } else {
                builder.append(Character.toLowerCase(character));
            }
        }
        return builder.toString();
    }

}
