package alma.archive.projectcode;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;

public class ProjectCodeGenerator {

    private HashMap<TypeCode, Integer> mySequenceCounterMap = new HashMap<TypeCode, Integer>();
    private int myYear;
    private int mySemester;
    private static ProjectCodeGenerator instance;

    private ProjectCodeGenerator() {
        Calendar calendar = new GregorianCalendar();
        reset(calendar.get(Calendar.YEAR), 1);
    }

    public static ProjectCodeGenerator getInstance() {
        if (instance == null) {
            synchronized (ProjectCodeGenerator.class) {
                if (instance == null) {
                    instance = new ProjectCodeGenerator();
                }
            }
        }
        return instance;
    }

    public void reset(int inYear, int inSemester) {
        this.myYear = inYear;
        this.mySemester = inSemester;
        this.mySequenceCounterMap = new HashMap<TypeCode, Integer>();
        for (TypeCode code : TypeCode.class.getEnumConstants()) {
            this.mySequenceCounterMap.put(code, new Integer(1));
        }
    }

    public ProjectCode getNextProjectCode(TypeCode inTypeCode) {
        int seqNum = this.mySequenceCounterMap.get(inTypeCode);
        this.mySequenceCounterMap.put(inTypeCode, seqNum + 1);
        return new ProjectCode(this.myYear, this.mySemester, seqNum,
                inTypeCode);
    }
}
