/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 *
 *    Created on Sep 16, 2004
 *
 */
 
  
// $Author: hsommer $
// $Date: 2006/10/10 13:39:14 $
// $Log: InternalCommunicationHelper.java,v $
// Revision 1.4  2006/10/10 13:39:14  hsommer
// ContainerException now called AcsJContainerServicesEx
//
// Revision 1.3  2005/02/02 15:46:19  hmeuss
// implemented new naming conventions
//
// Revision 1.2  2004/09/17 09:21:19  hmeuss
// *** empty log message ***
//
// Revision 1.1  2004/09/17 09:02:27  hmeuss
// Added ModuleCriticalException that will be propagated upwards through all classes
// 
 
package alma.archive.helpers;

import java.util.logging.Level;
import java.util.logging.Logger;

import alma.JavaContainerError.wrappers.AcsJContainerServicesEx;
import alma.acs.container.ContainerServices;
import alma.archive.ArchiveSubsystemMasterIF;
import alma.archive.ArchiveSubsystemMasterIFHelper;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.ArchiveCommunicationException;

/**
 * 
 * Used for communicating mainly with the ARCHIVE master component. Before first use, init MUST be called!
 * 
 * @author hmeuss
 *
 */
public class InternalCommunicationHelper {

/** Name of master component as defined in the CDB  */
protected static final String masterName = "ARCHIVE_MASTER_COMP";

/** The master component, set in init() */
protected static ArchiveSubsystemMasterIF master=null;
 

	/**
	 * Notify master component that the critical exception e was thrown.
	 * 
	 * @param e
	 */
	public static void notifyMaster(ModuleCriticalException e, ContainerServices cs, String compName, Logger logger) throws ArchiveCommunicationException {
	if (master==null) {
		try {
			master = 
					ArchiveSubsystemMasterIFHelper.narrow(
						cs.getComponent(masterName));
		} catch (AcsJContainerServicesEx e1) {
			logger.log(Level.WARNING, "Could not connect to Archive subsystem master component. Critical exception occured, master could not be notified.", e1);
			throw new ArchiveCommunicationException(e1);
		}
	}
	master.componentNeedsAttention(compName, e.getTroubleCode(), e.getTroubleMessage());
	
	}
}
