/*
 * Created on 06-May-2003
 *
 * To change this generated comment go to 
 * Window>Preferences>Java>Code Generation>Code Template
 */
package alma.archive.components;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

import alma.ACS.OffShootOperations;
import alma.ArchiveIdentifierError.wrappers.AcsJArchiveIdentifierErrorEx;
import alma.acs.container.ContainerServices;
import alma.acsErrTypeAlarmSourceFactory.ACSASFactoryNotInitedEx;
import alma.acsErrTypeAlarmSourceFactory.FaultStateCreationErrorEx;
import alma.acsErrTypeAlarmSourceFactory.SourceCreationErrorEx;
import alma.alarmsystem.source.ACSAlarmSystemInterface;
import alma.alarmsystem.source.ACSAlarmSystemInterfaceFactory;
import alma.alarmsystem.source.ACSFaultState;
import alma.archive.database.helpers.DBConfiguration;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.ArchiveCommunicationException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.helpers.InternalCommunicationHelper;
import alma.xmlstore.AdministrativeOperations;
import alma.xmlstore.ArchiveInternalError;
import alma.xmlstore.AdministrativePackage.MalformedURI;
import alma.xmlstore.AdministrativePackage.NotFound;

/**
 * @author simon
 */
public class AdministrativeImpl implements OffShootOperations,
		AdministrativeOperations {
	private Logger logger;

	protected ContainerServices m_containerServices;

	/** component instance name as found in the CDB */
	protected String myName;

	private String user;

	private InternalIF internal = null;

	// private PathManager pathmanager = null;
	private DBConfiguration dbConfig = null;

	// if an alarm is sent, this stays true until the alarm is deactivated
	private boolean alarmActive=false;
	
	// for Archive-only methods, a password must be provided (Simple protection)
	private String m_password="almabtrieb";
	
	public AdministrativeImpl(String user, Logger logger,
			ContainerServices containerServices) throws ArchiveException {
		m_containerServices = containerServices;
		myName = containerServices.getName();
		this.user = user;
		this.logger = logger;

		try {
			dbConfig = DBConfiguration.instance(logger);
		} catch (DatabaseException e) {
			logger.severe("Couldn't read dbConfig file.");
			throw new ArchiveException(e);
		}
		try {
			connect();
		} catch (ArchiveInternalError e) {
			logger.severe("Couldn't connect to the internal interface");
			throw new ArchiveException(e);
		}
	}

	/**
	 * @see alma.xmlstore.OperationalOperations#ping()
	 * 
	 * Makes sure that the Internal interface that the interface is connected to
	 * is awake and responding.
	 */
	public boolean ping() {
		try {
			InternalIF intIF = InternalIFFactory.getInternalIF(logger);
			boolean ret = intIF.ping();
			if (!ret) {
				//logger.info("Sending alarm.");
				send_alarm(true);
			} else if (alarmActive)	{
				//logger.info("Sending alarm.");
				send_alarm(false); // deactivate alarm
			}
			return ret;
		} catch (Exception e) {
			logger.warning("Caught exception: " + e.toString());
			//logger.info("Sending alarm.");
			send_alarm(true);
			return false;
		}
	}

	/**
	 * @see alma.monitorstream.AdministrativeOperations#init()
	 * 
	 * Wakes up the internal interface.
	 */
	public void init(String password) throws ArchiveInternalError {
			if (!password.equals(m_password)) {
				throw new ArchiveInternalError("Uncorrect password provided to call this method.");
			}
		try {
			internal.init();
		} catch (ModuleCriticalException e) {
			try {
				InternalCommunicationHelper.notifyMaster(e,
						m_containerServices, myName, logger);
			} catch (ArchiveCommunicationException e1) {
				// ignore
				logger.warning("Can not connect to Archive subsystem master.");
			}
			logger.severe("Could not init Administrative component: "
					+ e.toString());
			throw new ArchiveInternalError(
					"Can not initialize internal interface.");
		} catch (DatabaseException e) {
			logger.severe("Could not init Administrative component: "
					+ e.toString());
			throw new ArchiveInternalError(
					"Can not initialize internal interface.");
		}
	}

	/**
	 * Poke the internal interface if it has closed down for some reason.
	 */
	public void reinit(String password) throws ArchiveInternalError {
		if (!password.equals(m_password)) {
			throw new ArchiveInternalError("Uncorrect password provided to call this method.");
		}
		try {
			DBConfiguration.instance(logger).reinit(logger);
		} catch (DatabaseException e) {
			logger.warning("Problem during reinit of Archive/Administrative"
					+ e.toString());
			throw new ArchiveInternalError(e.toString());
		}
		this.init(m_password);
	}

	/**
	 * Conn
	 * 
	 * @throws ArchiveInternalError
	 */
	private void connect() throws ArchiveInternalError {
		if (internal == null) {
			try {
				internal = InternalIFFactory.getInternalIF(logger);
				logger.log(Level.INFO, "Connected to the internal interface");

				// moved to init()
				// pathmanager = PathManager.instance(logger);
			} catch (DatabaseException e) {
				logger.log(Level.SEVERE,
						"Unable to connect to the internal interface "
								+ e.getMessage());
			} catch (ModuleCriticalException e) {
				try {
					InternalCommunicationHelper.notifyMaster(e,
							m_containerServices, myName, logger);
				} catch (ArchiveCommunicationException e1) {
					// ignore
					logger
							.warning("Can not connect to Archive subsystem master");
				}
				logger.log(Level.SEVERE,
						"Unable to connect to the internal interface "
								+ e.getCause().getMessage());
				throw new ArchiveInternalError(e.getCause().toString());
			}
		}
		/*
		 * try { pathmanager = PathManager.instance(logger); } catch
		 * (DatabaseException e1) { throw new
		 * ArchiveInternalError(e1.toString()); } catch (ModuleCriticalException
		 * e) { try { InternalCommunicationHelper.notifyMaster(e,
		 * m_containerServices, myName, logger); } catch
		 * (ArchiveCommunicationException e1) { // ignore logger.warning("Can
		 * not connect to Archive subsystem master"); } logger.log(Level.SEVERE,
		 * "Unable to connect to the internal interface " +
		 * e.getCause().getMessage()); throw new
		 * ArchiveInternalError(e.getCause().toString()); }
		 */
	}

	/**
	 * Returns a specific config value
	 * 
	 * @return configuration string
	 */
	public String config(String name) {
		if (dbConfig.get(name) != null) {
			return dbConfig.get(name);
		} else
			return "";
	}

	/**
	 * Close down the interface, disconnects from the internal interface and
	 * frees up resources.
	 */
	public void close(String password) throws ArchiveInternalError {
		if (!password.equals(m_password)) {
			throw new ArchiveInternalError("Uncorrect password provided to call this method.");
		}
		if (internal != null) {
			try {
				internal.close();
				logger.log(Level.INFO,
						"Disconnected from the internal interface");
			} catch (DatabaseException e) {
				logger.log(Level.INFO,
						"Unable to disconnect from the internal interface");
				throw new ArchiveInternalError(e.getMessage());
			} catch (ModuleCriticalException e) {
				try {
					InternalCommunicationHelper.notifyMaster(e,
							m_containerServices, myName, logger);
				} catch (ArchiveCommunicationException e1) {
					// ignore
					logger
							.warning("Cannot connect to Archive subsystem master");
				}
				logger.log(Level.INFO,
						"Unable to disconnect from the internal interface");
				throw new ArchiveInternalError(e.getMessage());
			}
		}
	}

	/**
	 * @see alma.xmlstore.OperationalOperations#remove(java.lang.String)
	 * 
	 * Remove a specific document from the archive. Removes a document specified
	 * by the uid from the archive totally, including all of it's history. This
	 * action is not reversible. Deep remove is not implemented at this time.
	 */
	public void remove(String uid, boolean deep) throws NotFound, MalformedURI,
			ArchiveInternalError {
		if (internal == null) {
			throw new ArchiveInternalError(
					"ARCHIVE: The Archive has not been initialised call .init()");
		}
		try {
			URI uri = new URI(uid);
			internal.remove(uri, false, user);
			// pathmanager.removePath(uri);
		} catch (URISyntaxException e) {
			throw new MalformedURI(e.getMessage());
		} catch (ArchiveException e) {
			throw new ArchiveInternalError(e.getMessage());
		} catch (ModuleCriticalException e) {
			try {
				InternalCommunicationHelper.notifyMaster(e,
						m_containerServices, myName, logger);
			} catch (ArchiveCommunicationException e1) {
				// ignore
				logger.warning("Can nont connect to Archive subsystem master");
			}
			throw new ArchiveInternalError(e.getCause().getMessage());
		}
	}

	/**
	 * Removes all of the documents in the test area, this does not affect the
	 * operational section of the archive.
	 */
	public void cleanTestArea() throws ArchiveInternalError {
		if (internal == null) {
			throw new ArchiveInternalError(
					"ARCHIVE: The Archive has not been initialised call .init()");
		}
		try {
			internal.cleanTestArea(user);
			// TODO: revisit exception handling. Unclear when exactly master
			// comp is notified.
		} catch (ArchiveException e) {
			throw new ArchiveInternalError(e.getMessage());
		} catch (AcsJArchiveIdentifierErrorEx e) {
			throw new ArchiveInternalError(e.getMessage());
		} catch (ModuleCriticalException e) {
			try {
				InternalCommunicationHelper.notifyMaster(e,
						m_containerServices, myName, logger);
			} catch (ArchiveCommunicationException e1) {
				// ignore
				logger.warning("Can nont connect to Archive subsystem master");
			}
			throw new ArchiveInternalError(e.getCause().getMessage());
		}
	}

	/** 
	 * convenience method for send_alarm/4
	 * Also avoids sending of multiple alarms.
	 * If active is true, we send activate as faultState, otherwise we send deactivate 
	 *
	 */
	protected void send_alarm(boolean active) {
		String faultFamily = "Backend";
		String faultMember;
		int faultCode=1;
		String faultState;
		if (config("archive.db.backend").equals("oracle")) {
			faultMember = "Oracle"; 
		} else {
			faultMember = "eXist";
		}
		if (active) {
			faultState=ACSFaultState.ACTIVE;
		} else {
			faultState=ACSFaultState.TERMINATE;
		}
		try {
			send_alarm(faultFamily, faultMember, faultCode, faultState);
			alarmActive=active;
		} catch (ACSASFactoryNotInitedEx e) {
			logger.warning("Could not activate/deactivate alarm: "+e.toString());
		} catch (SourceCreationErrorEx e) {
			logger.warning("Could not activate/deactivate alarm: "+e.toString());
		} catch (FaultStateCreationErrorEx e) {
			logger.warning("Could not activate/deactivate alarm: "+e.toString());
		}
	}
	
	/**
	 * sends an alarm to the ACS alarm system. Alarms must be configured in the CDB. 
	 * @param faultFamily
	 * @param faultMember
	 * @param faultCode
	 * @param faultState
	 * @throws ACSASFactoryNotInitedEx
	 * @throws SourceCreationErrorEx
	 * @throws FaultStateCreationErrorEx
	 */
	protected void send_alarm(
			String faultFamily,
			String faultMember,
			int faultCode,
			String faultState) throws ACSASFactoryNotInitedEx, SourceCreationErrorEx, FaultStateCreationErrorEx
			{
			ACSAlarmSystemInterface alarmSource =
	ACSAlarmSystemInterfaceFactory.createSource(this.myName);
	ACSFaultState fs =
	ACSAlarmSystemInterfaceFactory.createFaultState(
	faultFamily, faultMember, faultCode);
	fs.setDescriptor(faultState);
	fs.setUserTimestamp(new Timestamp(System.currentTimeMillis()));
    Properties props = new Properties();
    props.setProperty(ACSFaultState.ASI_PREFIX_PROPERTY, "prefix");
    props.setProperty(ACSFaultState.ASI_SUFFIX_PROPERTY, "suffix");
    fs.setUserProperties(props);
	alarmSource.push(fs);
	//logger.info("ALARM SENT!");
			}
}
